/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.util;

import org.eclipse.cbi.p2repo.util.LogLevel;
import org.eclipse.cbi.p2repo.util.P2RepoUtil;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class LogUtils {
    private static final int MAGIC = P2RepoUtil.getPluginID().hashCode();

    public static void debug(String msg, Object ... args) {
        LogUtils.log(LogLevel.DEBUG, msg, args);
    }

    public static void debug(Throwable t, String msg, Object ... args) {
        LogUtils.log(LogLevel.DEBUG, t, msg, args);
    }

    public static void error(String msg, Object ... args) {
        LogUtils.log(LogLevel.ERROR, msg, args);
    }

    public static void error(Throwable t, String msg, Object ... args) {
        LogUtils.log(LogLevel.ERROR, t, msg, args);
    }

    public static ILog getLog() {
        if (P2RepoUtil.getPlugin().getBundle() == null) {
            return new ILog(){

                public void removeLogListener(ILogListener listener) {
                }

                public void log(IStatus status) {
                    System.out.println(status);
                }

                public Bundle getBundle() {
                    return null;
                }

                public void addLogListener(ILogListener listener) {
                }
            };
        }
        return Platform.getLog((Bundle)P2RepoUtil.getPlugin().getBundle());
    }

    public static void info(String msg, Object ... args) {
        LogUtils.log(LogLevel.INFO, msg, args);
    }

    public static void info(Throwable t, String msg, Object ... args) {
        LogUtils.log(LogLevel.INFO, t, msg, args);
    }

    public static void log(IStatus status) {
        P2RepoUtil plugin = P2RepoUtil.getPlugin();
        if (status.getSeverity() >= plugin.getConsoleLogLevel().ordinal()) {
            String fullMessage = status.getMessage();
            if (status.getSeverity() >= 2) {
                System.err.println(fullMessage);
            } else {
                System.out.println(fullMessage);
            }
        }
        LogUtils.getLog().log(status);
    }

    public static void log(LogLevel level, String msg, Object ... args) {
        LogUtils.log(level, null, msg, args);
    }

    public static void log(LogLevel level, Throwable t, String msg, Object ... args) {
        String fullMessage = args == null || args.length == 0 ? msg : String.format(msg, args);
        P2RepoUtil plugin = P2RepoUtil.getPlugin();
        if (level.ordinal() >= plugin.getConsoleLogLevel().ordinal()) {
            if (level.ordinal() >= 2) {
                System.err.println(fullMessage);
            } else {
                System.out.println(fullMessage);
            }
        }
        if (level.ordinal() >= plugin.getEclipseLogLevel().ordinal()) {
            LogUtils.getLog().log((IStatus)new Status(level.getStatusLevel(), P2RepoUtil.getPluginID(), MAGIC, fullMessage, t));
        }
    }

    public static void warning(String msg, Object ... args) {
        LogUtils.log(LogLevel.WARNING, msg, args);
    }

    public static void warning(Throwable t, String msg, Object ... args) {
        LogUtils.log(LogLevel.WARNING, t, msg, args);
    }
}

