/*
 * Decompiled with CFR 0.152.
 */
package xpt.diagram.updater;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramUpdater;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.GenModelUtils_qvto;
import xpt.diagram.updater.LinkDescriptor;
import xpt.diagram.updater.NodeDescriptor;
import xpt.diagram.updater.UpdaterLinkType;
import xpt.diagram.updater.Utils_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.providers.ElementTypes;

@Singleton
public class DiagramUpdater {
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    @Extension
    private GenModelUtils_qvto _genModelUtils_qvto;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private ElementTypes xptElementTypes;
    @Inject
    private NodeDescriptor nodeDescriptor;
    @Inject
    private LinkDescriptor linkDescriptor;

    @MetaDef
    public CharSequence getSemanticChildrenMethodName(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("get");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier((GenCommonBase)it);
        _builder.append(_stringUniqueIdentifier);
        _builder.append("_SemanticChildren");
        return _builder;
    }

    @MetaDef
    public CharSequence getSemanticChildrenMethodCall(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _diagramUpdaterInstanceToUse = this.diagramUpdaterInstanceToUse(this.diagramUpdater((GenCommonBase)it));
        _builder.append((Object)_diagramUpdaterInstanceToUse);
        _builder.append(".");
        CharSequence _semanticChildrenMethodName = this.getSemanticChildrenMethodName(it);
        _builder.append((Object)_semanticChildrenMethodName);
        return _builder;
    }

    @MetaDef
    public CharSequence getContainedLinksMethodCall(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _doGetSomeLinksMethodCall = this.doGetSomeLinksMethodCall(it, UpdaterLinkType.CONTAINED);
        _builder.append((Object)_doGetSomeLinksMethodCall);
        return _builder;
    }

    @MetaDef
    public CharSequence getIncomingLinksMethodCall(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _doGetSomeLinksMethodCall = this.doGetSomeLinksMethodCall(it, UpdaterLinkType.INCOMING);
        _builder.append((Object)_doGetSomeLinksMethodCall);
        return _builder;
    }

    @MetaDef
    public CharSequence getOutgoingLinksMethodCall(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _doGetSomeLinksMethodCall = this.doGetSomeLinksMethodCall(it, UpdaterLinkType.OUTGOING);
        _builder.append((Object)_doGetSomeLinksMethodCall);
        return _builder;
    }

    @MetaDef
    protected CharSequence doGetSomeLinksMethodCall(GenCommonBase it, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _diagramUpdaterInstanceToUse = this.diagramUpdaterInstanceToUse(this.diagramUpdater((GenCommonBase)it.getDiagram()));
        _builder.append((Object)_diagramUpdaterInstanceToUse);
        _builder.append(".");
        CharSequence _linkGetterName = this.linkGetterName(it, linkType);
        _builder.append((Object)_linkGetterName);
        return _builder;
    }

    @MetaDef
    protected CharSequence linkGetterName(GenCommonBase it, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("get");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
        _builder.append(_stringUniqueIdentifier);
        _builder.append("_");
        String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
        _builder.append(_linkMethodSuffix);
        _builder.append("Links");
        return _builder;
    }

    @MetaDef
    public CharSequence runtimeTypedInstanceName(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("TYPED_INSTANCE");
        return _builder;
    }

    @MetaDef
    public CharSequence runtimeTypedInstanceCall(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(".");
        CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
        _builder.append((Object)_runtimeTypedInstanceName);
        return _builder;
    }

    public CharSequence className(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        String _diagramUpdaterClassName = it.getDiagramUpdaterClassName();
        _builder.append(_diagramUpdaterClassName);
        return _builder;
    }

    public CharSequence packageName(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getEditorGen().getEditor().getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence DiagramUpdater(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" implements  org.eclipse.papyrus.infra.gmfdiag.common.updater.DiagramUpdater {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _classSingleton = this.classSingleton(it);
        _builder.append((Object)_classSingleton, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence __constructor = this._constructor(it);
        _builder.append((Object)__constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _isShortcutOrphaned = this.isShortcutOrphaned(it);
        _builder.append((Object)_isShortcutOrphaned, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        Functions.Function1 _function = container -> this._utils_qvto.hasSemanticChildren((GenContainerBase)container);
        Iterable semanticContainers = IterableExtensions.filter((Iterable)it.getEditorGen().getDiagram().getAllContainers(), (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _genericSemanticChildrenOfView = this.getGenericSemanticChildrenOfView(it, semanticContainers);
        _builder.append((Object)_genericSemanticChildrenOfView, "\t");
        _builder.newLineIfNotEmpty();
        for (GenContainerBase next : semanticContainers) {
            _builder.append("\t");
            CharSequence _semanticChildrenOfView = this.getSemanticChildrenOfView(next);
            _builder.append((Object)_semanticChildrenOfView, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _phantomNodesIterator = this.getPhantomNodesIterator(it);
        _builder.append((Object)_phantomNodesIterator, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _genericConnectedLinks = this.getGenericConnectedLinks(it, this._utils_qvto.getAllSemanticElements(it.getEditorGen().getDiagram()), UpdaterLinkType.CONTAINED);
        _builder.append((Object)_genericConnectedLinks, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _genericConnectedLinks_1 = this.getGenericConnectedLinks(it, this._utils_qvto.getAllSemanticDiagramElements(it.getEditorGen().getDiagram()), UpdaterLinkType.INCOMING);
        _builder.append((Object)_genericConnectedLinks_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _genericConnectedLinks_2 = this.getGenericConnectedLinks(it, this._utils_qvto.getAllSemanticDiagramElements(it.getEditorGen().getDiagram()), UpdaterLinkType.OUTGOING);
        _builder.append((Object)_genericConnectedLinks_2, "\t");
        _builder.newLineIfNotEmpty();
        Iterable<GenCommonBase> _allSemanticElements = this._utils_qvto.getAllSemanticElements(it.getEditorGen().getDiagram());
        for (GenCommonBase e : _allSemanticElements) {
            _builder.append("\t");
            CharSequence _containedLinks = this.getContainedLinks(e);
            _builder.append((Object)_containedLinks, "\t");
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenLinkEnd> _allSemanticDiagramElements = this._utils_qvto.getAllSemanticDiagramElements(it.getEditorGen().getDiagram());
        for (GenLinkEnd e_1 : _allSemanticDiagramElements) {
            _builder.append("\t");
            CharSequence _incomingLinks = this.getIncomingLinks(e_1);
            _builder.append((Object)_incomingLinks, "\t");
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenLinkEnd> _allSemanticDiagramElements_1 = this._utils_qvto.getAllSemanticDiagramElements(it.getEditorGen().getDiagram());
        for (GenLinkEnd e_2 : _allSemanticDiagramElements_1) {
            _builder.append("\t");
            CharSequence _outgoingLinks = this.getOutgoingLinks(e_2);
            _builder.append((Object)_outgoingLinks, "\t");
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenLink> _allContainedLinks = this._utils_qvto.getAllContainedLinks(it.getEditorGen().getDiagram());
        for (GenLink link : _allContainedLinks) {
            _builder.append("\t");
            CharSequence _containedLinksByTypeMethod = this.getContainedLinksByTypeMethod(link);
            _builder.append((Object)_containedLinksByTypeMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenLink> _allIncomingLinks = this._utils_qvto.getAllIncomingLinks(it.getEditorGen().getDiagram());
        for (GenLink link_1 : _allIncomingLinks) {
            _builder.append("\t");
            CharSequence _incomingLinksByTypeMethod = this.getIncomingLinksByTypeMethod(link_1);
            _builder.append((Object)_incomingLinksByTypeMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        Iterable<GenLink> _allOutgoingLinks = this._utils_qvto.getAllOutgoingLinks(it.getEditorGen().getDiagram());
        for (GenLink link_2 : _allOutgoingLinks) {
            _builder.append("\t");
            CharSequence _outgoingLinksByTypeMethod = this.getOutgoingLinksByTypeMethod(link_2);
            _builder.append((Object)_outgoingLinksByTypeMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isShortcutOrphaned(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _notEmpty = this._common_qvto.notEmpty(it.getEditorGen().getDiagram().getContainsShortcutsTo());
        if (_notEmpty) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            _builder.append("public static boolean isShortcutOrphaned(org.eclipse.gmf.runtime.notation.View view) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return !view.isSetElement() || view.getElement() == null || view.getElement().eIsProxy();");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected GenDiagramUpdater diagramUpdater(GenCommonBase base) {
        return base.getDiagram().getEditorGen().getDiagramUpdater();
    }

    protected CharSequence nodeDescriptorQualifiedClassName(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(this.diagramUpdater(it));
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    protected CharSequence linkDescriptorQualifiedClassName(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater(it));
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    protected CharSequence _listOfNodeDescriptors(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("java.util.List<");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _listOfNodeDescriptors(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _listOfNodeDescriptors = this.listOfNodeDescriptors((EObject)this.diagramUpdater(it));
        _builder.append((Object)_listOfNodeDescriptors);
        return _builder;
    }

    protected CharSequence _listOfLinkDescriptors(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("java.util.List<");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence _listOfLinkDescriptors(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _listOfLinkDescriptors = this.listOfLinkDescriptors((EObject)this.diagramUpdater(it));
        _builder.append((Object)_listOfLinkDescriptors);
        return _builder;
    }

    protected CharSequence newEmptyList() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("java.util.Collections.emptyList()");
        return _builder;
    }

    protected CharSequence newLinkedListOfNodeDescriptors(GenDiagramUpdater it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("java.util.LinkedList<");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append("> result = new java.util.LinkedList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it.getEditorGen().getDiagram(), it.getNodeDescriptorQualifiedClassName());
        _builder.append(_diamondOp);
        _builder.append(">");
        return _builder;
    }

    protected CharSequence newLinkedListOfLinkDescriptors(GenDiagramUpdater it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("java.util.LinkedList<");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        _builder.append("> result = new java.util.LinkedList<");
        String _diamondOp = this._codeStyle.diamondOp((GenCommonBase)it.getEditorGen().getDiagram(), it.getLinkDescriptorQualifiedClassName());
        _builder.append(_diamondOp);
        _builder.append(">");
        return _builder;
    }

    public CharSequence getGenericSemanticChildrenOfView(GenDiagramUpdater it, Iterable<GenContainerBase> semanticContainers) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        CharSequence _listOfNodeDescriptors = this.listOfNodeDescriptors((EObject)it);
        _builder.append((Object)_listOfNodeDescriptors);
        _builder.append(" getSemanticChildren(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(semanticContainers);
        if (_notEmpty) {
            _builder.append("\t");
            _builder.append("String vid = ");
            CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
            _builder.append((Object)_visualIDMethodCall, "\t");
            _builder.append("(view);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (vid != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("switch (vid) {");
            _builder.newLine();
            for (GenContainerBase next : semanticContainers) {
                _builder.append("\t");
                _builder.append("\t\t\t");
                CharSequence _semanticChildrenCase = this.getSemanticChildrenCase(next);
                _builder.append((Object)_semanticChildrenCase, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append((Object)_newEmptyList, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getSemanticChildrenCase(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID((GenCommonBase)it);
        _builder.append((Object)_caseVisualID);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _semanticChildrenMethodName = this.getSemanticChildrenMethodName(it);
        _builder.append((Object)_semanticChildrenMethodName, "\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getSemanticChildrenOfView(GenContainerBase it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _specificDiagramUpdaterClassName = it.getSpecificDiagramUpdaterClassName();
        boolean bl = _tripleNotEquals = _specificDiagramUpdaterClassName != null;
        if (_tripleNotEquals) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            _builder.append("public  ");
            CharSequence _listOfNodeDescriptors = this.listOfNodeDescriptors((EObject)it);
            _builder.append((Object)_listOfNodeDescriptors);
            _builder.append(" ");
            CharSequence _semanticChildrenMethodName = this.getSemanticChildrenMethodName(it);
            _builder.append((Object)_semanticChildrenMethodName);
            _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _iCustomDiagramUpdater = this.getICustomDiagramUpdater(it);
            _builder.append((Object)_iCustomDiagramUpdater, "\t");
            _builder.append(" customUpdater = new ");
            String _specificDiagramUpdaterClassName_1 = it.getSpecificDiagramUpdaterClassName();
            _builder.append(_specificDiagramUpdaterClassName_1, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return customUpdater.getSemanticChildren(view);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        } else {
            CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_1);
            _builder.newLineIfNotEmpty();
            _builder.append("public  ");
            CharSequence _listOfNodeDescriptors_1 = this.listOfNodeDescriptors((EObject)it);
            _builder.append((Object)_listOfNodeDescriptors_1);
            _builder.append(" ");
            CharSequence _semanticChildrenMethodName_1 = this.getSemanticChildrenMethodName(it);
            _builder.append((Object)_semanticChildrenMethodName_1);
            _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
            _builder.newLineIfNotEmpty();
            if (this._common_qvto.notEmpty(this._utils_qvto.getSemanticChildrenChildFeatures(it)) || this._common_qvto.notEmpty(this._utils_qvto.getPhantomNodes(it))) {
                _builder.append("\t");
                CharSequence _defineModelElement = this.defineModelElement(it);
                _builder.append((Object)_defineModelElement, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _newLinkedListOfNodeDescriptors = this.newLinkedListOfNodeDescriptors(this.diagramUpdater((GenCommonBase)it), "result");
                _builder.append((Object)_newLinkedListOfNodeDescriptors, "\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                Set<GenFeature> _semanticChildrenChildFeatures = this._utils_qvto.getSemanticChildrenChildFeatures(it);
                for (GenFeature childMetaFeature : _semanticChildrenChildFeatures) {
                    if (childMetaFeature == null) {
                        _builder.append("\t");
                        _builder.append("{ \t/*FIXME no containment/child feature found in the genmodel, toolsmith need to specify Class here manually*/ childElement = ");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("/*FIXME no containment/child feature found in the genmodel, toolsmith need to specify correct one here manually*/;");
                        _builder.newLine();
                    } else {
                        boolean _isListType = childMetaFeature.isListType();
                        if (_isListType) {
                            _builder.append("\t");
                            _builder.append("for (java.util.Iterator<?> it = ");
                            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(childMetaFeature, "modelElement", this._utils_qvto.getModelElementType(it));
                            _builder.append((Object)_featureValue, "\t");
                            _builder.append(".iterator(); it.hasNext();) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)childMetaFeature.getTypeGenClass(), "childElement", "it.next()", true);
                            _builder.append((Object)_DeclareAndAssign, "\t");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("\t");
                            _builder.append("{ ");
                            CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(childMetaFeature.getTypeGenClass(), "childElement", "modelElement", this._utils_qvto.getModelElementType(it), childMetaFeature);
                            _builder.append((Object)_DeclareAndAssign_1, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append("\t");
                    _builder.append("String visualID = ");
                    CharSequence _nodeVisualIDMethodCall = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(it.getDiagram());
                    _builder.append((Object)_nodeVisualIDMethodCall, "\t");
                    _builder.append("(view, ");
                    CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(childMetaFeature.getTypeGenClass(), "childElement");
                    _builder.append((Object)_DowncastToEObject, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    Iterable<GenNode> _semanticChildren = this._utils_qvto.getSemanticChildren(it, childMetaFeature);
                    for (GenNode next : _semanticChildren) {
                        _builder.append("\t");
                        CharSequence _checkChildElementVisualID = this.checkChildElementVisualID(next, childMetaFeature != null && childMetaFeature.isListType());
                        _builder.append((Object)_checkChildElementVisualID, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                boolean _notEmpty = this._common_qvto.notEmpty(this._utils_qvto.getPhantomNodes(it));
                if (_notEmpty) {
                    _builder.append("\t");
                    _builder.append("org.eclipse.emf.ecore.resource.Resource resource = modelElement.eResource();");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.EObject> it = getPhantomNodesIterator(resource); it.hasNext();) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("org.eclipse.emf.ecore.EObject childElement = it.next();");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (childElement == modelElement) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("continue;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    Iterable<GenNode> _phantomNodes = this._utils_qvto.getPhantomNodes(it);
                    for (GenNode phantom : _phantomNodes) {
                        _builder.append("\t");
                        _builder.append("\t");
                        CharSequence _addNextIfPhantom = this.addNextIfPhantom(phantom);
                        _builder.append((Object)_addNextIfPhantom, "\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("return result;");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("return ");
                CharSequence _newEmptyList = this.newEmptyList();
                _builder.append((Object)_newEmptyList, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _defineModelElement(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (!view.isSetElement()) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append((Object)_newEmptyList, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(this._utils_qvto.getModelElementType(it), "modelElement", "view.getElement()");
        _builder.append((Object)_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _defineModelElement(GenCompartment it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (false == view.eContainer() instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append((Object)_newEmptyList, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("org.eclipse.gmf.runtime.notation.View containerView = (org.eclipse.gmf.runtime.notation.View) view.eContainer();");
        _builder.newLine();
        _builder.append("if (!containerView.isSetElement()) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _newEmptyList_1 = this.newEmptyList();
        _builder.append((Object)_newEmptyList_1, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(this._utils_qvto.getModelElementType((GenContainerBase)it), "modelElement", "containerView.getElement()");
        _builder.append((Object)_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence checkChildElementVisualID(GenNode it, Boolean inLoop) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID);
        _builder.append(".equals(visualID)) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("result.add(new ");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)it.getDiagram()));
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append("(");
        GenFeature _childMetaFeature = it.getModelFacet().getChildMetaFeature();
        boolean bl = _tripleNotEquals = _childMetaFeature != null;
        if (_tripleNotEquals) {
            CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getModelFacet().getChildMetaFeature().getTypeGenClass(), "childElement");
            _builder.append((Object)_DowncastToEObject, "\t");
            _builder.append(", ");
        }
        _builder.append("visualID));");
        _builder.newLineIfNotEmpty();
        if (inLoop.booleanValue()) {
            _builder.append("continue;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addNextIfPhantom(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        CharSequence _nodeVisualIDMethodCall = this.xptVisualIDRegistry.getNodeVisualIDMethodCall(it.getDiagram());
        _builder.append((Object)_nodeVisualIDMethodCall);
        _builder.append("(view, childElement) == ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("result.add(new ");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)it.getDiagram()));
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append("(childElement, ");
        CharSequence _visualID_1 = VisualIDRegistry.visualID((GenCommonBase)it);
        _builder.append((Object)_visualID_1, "\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getPhantomNodesIterator(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasPhantomNodes = this._utils_qvto.hasPhantomNodes(it.getEditorGen().getDiagram());
        if (_hasPhantomNodes) {
            _builder.newLine();
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            _builder.append("private static java.util.Iterator<org.eclipse.emf.ecore.EObject> getPhantomNodesIterator(org.eclipse.emf.ecore.resource.Resource resource) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return resource.getAllContents();");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getGenericConnectedLinks(GenDiagramUpdater it, Iterable<? extends GenCommonBase> linkContainers, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        CharSequence _listOfLinkDescriptors = this.listOfLinkDescriptors((EObject)it);
        _builder.append((Object)_listOfLinkDescriptors);
        _builder.append(" get");
        String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
        _builder.append(_linkMethodSuffix);
        _builder.append("Links(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(linkContainers);
        if (_notEmpty) {
            _builder.append("\t\t");
            _builder.append("String vid = ");
            CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
            _builder.append((Object)_visualIDMethodCall, "\t\t");
            _builder.append("(view);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if (vid != null) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("switch (vid) {");
            _builder.newLine();
            for (GenCommonBase genCommonBase : linkContainers) {
                _builder.append("\t\t");
                _builder.append("\t\t");
                CharSequence _containedLinksCase = this.getContainedLinksCase(genCommonBase, linkType);
                _builder.append((Object)_containedLinksCase, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("return ");
        CharSequence _newEmptyList = this.newEmptyList();
        _builder.append((Object)_newEmptyList, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getContainedLinksCase(GenCommonBase it, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(it);
        _builder.append((Object)_caseVisualID);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ");
        CharSequence _linkGetterName = this.linkGetterName(it, linkType);
        _builder.append((Object)_linkGetterName, "\t");
        _builder.append("(view);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getContainedLinks(GenCommonBase it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _connectedLinks = this.getConnectedLinks(it, this._utils_qvto.computeContainedLinks(this._utils_qvto.getMetaClass((EObject)it), it.getDiagram()), UpdaterLinkType.CONTAINED, false);
        _builder.append((Object)_connectedLinks);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getContainedLinks(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _connectedLinks = this.getConnectedLinks((GenCommonBase)it, this._utils_qvto.computeContainedLinks(this._utils_qvto.getMetaClass((EObject)it), it.getDiagram()), UpdaterLinkType.CONTAINED, false);
        _builder.append((Object)_connectedLinks);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getIncomingLinks(GenLinkEnd it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _connectedLinks = this.getConnectedLinks((GenCommonBase)it, this._utils_qvto.computeIncomingLinks(it), UpdaterLinkType.INCOMING, true);
        _builder.append((Object)_connectedLinks);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getOutgoingLinks(GenLinkEnd it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _connectedLinks = this.getConnectedLinks((GenCommonBase)it, this._utils_qvto.computeOutgoingLinks(it), UpdaterLinkType.OUTGOING, false);
        _builder.append((Object)_connectedLinks);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getConnectedLinks(GenCommonBase it, Iterable<GenLink> genLinks, UpdaterLinkType linkType, boolean needCrossReferencer) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("public ");
        CharSequence _listOfLinkDescriptors = this.listOfLinkDescriptors((EObject)it);
        _builder.append((Object)_listOfLinkDescriptors, "\t\t");
        _builder.append(" ");
        CharSequence _linkGetterName = this.linkGetterName(it, linkType);
        _builder.append((Object)_linkGetterName, "\t\t");
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        boolean _notEmpty = this._common_qvto.notEmpty(genLinks);
        if (_notEmpty) {
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(this._utils_qvto.getMetaClass((EObject)it), "modelElement", "view.getElement()");
            _builder.append((Object)_DeclareAndAssign);
            _builder.newLineIfNotEmpty();
            if (needCrossReferencer) {
                CharSequence _typeOfCrossReferenceAdapter = this.typeOfCrossReferenceAdapter();
                _builder.append((Object)_typeOfCrossReferenceAdapter);
                _builder.append(" crossReferencer = ");
                CharSequence _typeOfCrossReferenceAdapter_1 = this.typeOfCrossReferenceAdapter();
                _builder.append((Object)_typeOfCrossReferenceAdapter_1);
                _builder.append(".getCrossReferenceAdapter(view.eResource().getResourceSet());");
                _builder.newLineIfNotEmpty();
            }
            CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(this.diagramUpdater(it), "result");
            _builder.append((Object)_newLinkedListOfLinkDescriptors);
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            for (GenLink link : genLinks) {
                CharSequence _colectConnectedLinks = this.colectConnectedLinks(link, linkType, needCrossReferencer, this._genModelUtils_qvto.isExternalInterface(this._utils_qvto.getMetaClass((EObject)it)));
                _builder.append((Object)_colectConnectedLinks);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("return result;");
            _builder.newLine();
        } else {
            _builder.append("return ");
            CharSequence _newEmptyList = this.newEmptyList();
            _builder.append((Object)_newEmptyList);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence colectConnectedLinks(GenLink it, UpdaterLinkType linkType, boolean needCrossReferencer, boolean isExternalInterface) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        LinkModelFacet _modelFacet = it.getModelFacet();
        boolean bl = _tripleNotEquals = _modelFacet != null;
        if (_tripleNotEquals) {
            if (isExternalInterface && !this._common_qvto.oclIsKindOf(it.getModelFacet(), FeatureLinkModelFacet.class)) {
                _builder.append("if (");
                CharSequence _IsInstance = this.xptMetaModel.IsInstance(this._utils_qvto.getLinkEndType(it.getModelFacet(), linkType), "modelElement");
                _builder.append((Object)_IsInstance);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("result.addAll(");
            CharSequence _chooseConnectedLinksByTypeMethodName = this.chooseConnectedLinksByTypeMethodName(it.getModelFacet(), linkType, it);
            _builder.append((Object)_chooseConnectedLinksByTypeMethodName);
            _builder.append("(");
            if (isExternalInterface && !this._common_qvto.oclIsKindOf(it.getModelFacet(), FeatureLinkModelFacet.class)) {
                CharSequence _CastEObject = this.xptMetaModel.CastEObject(this._utils_qvto.getLinkEndType(it.getModelFacet(), linkType), "modelElement");
                _builder.append((Object)_CastEObject);
            } else {
                _builder.append("modelElement");
            }
            if (needCrossReferencer) {
                _builder.append(", crossReferencer");
            }
            _builder.append("));  ");
            _builder.newLineIfNotEmpty();
            if (isExternalInterface && !this._common_qvto.oclIsKindOf(it.getModelFacet(), FeatureLinkModelFacet.class)) {
                _builder.append("}");
                _builder.newLine();
            }
        }
        return _builder;
    }

    protected CharSequence _chooseConnectedLinksByTypeMethodName(LinkModelFacet it, UpdaterLinkType type, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet);
        return _builder;
    }

    protected CharSequence _chooseConnectedLinksByTypeMethodName(FeatureLinkModelFacet it, UpdaterLinkType type, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = Objects.equals((Object)type, (Object)UpdaterLinkType.CONTAINED);
        if (_equals) {
            CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(genLink, UpdaterLinkType.OUTGOING);
            _builder.append((Object)_connectedLinksByTypeMethodName);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _connectedLinksByTypeMethodName_1 = this.getConnectedLinksByTypeMethodName(genLink, type);
            _builder.append((Object)_connectedLinksByTypeMethodName_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _chooseConnectedLinksByTypeMethodName(TypeLinkModelFacet it, UpdaterLinkType type, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        if (Objects.equals((Object)type, (Object)UpdaterLinkType.OUTGOING) && it.getSourceMetaFeature() == null) {
            CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(genLink, UpdaterLinkType.CONTAINED);
            _builder.append((Object)_connectedLinksByTypeMethodName);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _connectedLinksByTypeMethodName_1 = this.getConnectedLinksByTypeMethodName(genLink, type);
            _builder.append((Object)_connectedLinksByTypeMethodName_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getContainedLinksByTypeMethod(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _containedLinksByTypeMethod = this.getContainedLinksByTypeMethod(it.getModelFacet(), it);
        _builder.append((Object)_containedLinksByTypeMethod);
        return _builder;
    }

    public CharSequence getConnectedLinksByTypeMethodName(GenLink it, UpdaterLinkType linkType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("get");
        String _linkMethodSuffix = this._utils_qvto.getLinkMethodSuffix(linkType);
        _builder.append(_linkMethodSuffix);
        CharSequence _connectedLinksByTypeMethodFragment = this.getConnectedLinksByTypeMethodFragment(it.getModelFacet());
        _builder.append((Object)_connectedLinksByTypeMethodFragment);
        _builder.append("_");
        String _stringVisualID = this._common.stringVisualID((GenCommonBase)it);
        _builder.append(_stringVisualID);
        return _builder;
    }

    protected CharSequence _getConnectedLinksByTypeMethodFragment(TypeLinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("TypeModelFacetLinks");
        return _builder;
    }

    protected CharSequence _getConnectedLinksByTypeMethodFragment(FeatureLinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("FeatureModelFacetLinks");
        return _builder;
    }

    protected CharSequence _getConnectedLinksByTypeMethodFragment(LinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet);
        return _builder;
    }

    protected CharSequence _getContainedLinksByTypeMethod(LinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet);
        return _builder;
    }

    protected CharSequence _getContainedLinksByTypeMethod(FeatureLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _getContainedLinksByTypeMethod(TypeLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected java.util.Collection<");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)genLink));
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append("> ");
        CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(genLink, UpdaterLinkType.CONTAINED);
        _builder.append((Object)_connectedLinksByTypeMethodName, "\t");
        _builder.append("(");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getChildMetaFeature().getGenClass());
        _builder.append((Object)_QualifiedClassName, "\t");
        _builder.append(" container) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _containedLinksByTypeMethodBody = this.getContainedLinksByTypeMethodBody(it, genLink, false);
        _builder.append((Object)_containedLinksByTypeMethodBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getContainedLinksByTypeMethodBody(TypeLinkModelFacet it, GenLink genLink, boolean sourceVarDefined) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(this.diagramUpdater((GenCommonBase)genLink), "result");
        _builder.append((Object)_newLinkedListOfLinkDescriptors);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        boolean inLoop = it.getChildMetaFeature().isListType();
        _builder.newLineIfNotEmpty();
        if (inLoop) {
            _builder.append("for (java.util.Iterator<?> links = ");
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getChildMetaFeature(), "container", it.getChildMetaFeature().getGenClass());
            _builder.append((Object)_featureValue);
            _builder.append(".iterator(); links.hasNext();) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("org.eclipse.emf.ecore.EObject linkObject = (org.eclipse.emf.ecore.EObject ) links.next();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (");
            CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getMetaClass(), "linkObject");
            _builder.append((Object)_NotInstance, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("continue;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(it.getMetaClass(), "link", "linkObject");
            _builder.append((Object)_DeclareAndAssign, "\t");
            _builder.newLineIfNotEmpty();
        } else {
            GenClass _metaClass;
            GenClass _typeGenClass = it.getChildMetaFeature().getTypeGenClass();
            boolean _equals = Objects.equals(_typeGenClass, _metaClass = it.getMetaClass());
            if (_equals) {
                CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(it.getMetaClass(), "link", "container", it.getSourceType(), it.getChildMetaFeature());
                _builder.append((Object)_DeclareAndAssign_1);
                _builder.newLineIfNotEmpty();
            } else {
                CharSequence _DeclareAndAssign_2 = this.xptMetaModel.DeclareAndAssign(it.getChildMetaFeature().getTypeGenClass(), "linkObject", "container", it.getSourceType(), it.getChildMetaFeature());
                _builder.append((Object)_DeclareAndAssign_2);
                _builder.newLineIfNotEmpty();
                _builder.append("if (");
                CharSequence _NotInstance_1 = this.xptMetaModel.NotInstance(it.getMetaClass(), "linkObject");
                _builder.append((Object)_NotInstance_1);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return result;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                CharSequence _DeclareAndAssign_3 = this.xptMetaModel.DeclareAndAssign(it.getMetaClass(), "link", "linkObject");
                _builder.append((Object)_DeclareAndAssign_3);
                _builder.newLineIfNotEmpty();
            }
        }
        CharSequence _checkLinkVisualID = this.checkLinkVisualID(it, genLink, inLoop);
        _builder.append((Object)_checkLinkVisualID);
        _builder.newLineIfNotEmpty();
        CharSequence _defineLinkDestination = this.defineLinkDestination(it, inLoop);
        _builder.append((Object)_defineLinkDestination);
        _builder.newLineIfNotEmpty();
        GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
        boolean bl = _tripleNotEquals = _sourceMetaFeature != null;
        if (_tripleNotEquals) {
            CharSequence _defineLinkSource = this.defineLinkSource(it, inLoop);
            _builder.append((Object)_defineLinkSource);
            _builder.newLineIfNotEmpty();
            if (sourceVarDefined) {
                CharSequence _checkLinkSource = this.checkLinkSource(it, inLoop);
                _builder.append((Object)_checkLinkSource);
                _builder.newLineIfNotEmpty();
            }
            CharSequence _addLinkDescriptor = this.addLinkDescriptor(it, genLink, "src", "dst");
            _builder.append((Object)_addLinkDescriptor);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _addLinkDescriptor_1 = this.addLinkDescriptor(it, genLink, "container", "dst");
            _builder.append((Object)_addLinkDescriptor_1);
            _builder.newLineIfNotEmpty();
        }
        if (inLoop) {
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("return result;\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addLinkDescriptor(TypeLinkModelFacet it, GenLink genLink, String srcVar, String dstVar) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("result.add(new ");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)genLink));
        _builder.append((Object)_qualifiedClassName);
        _builder.append("(");
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getSourceType(), srcVar);
        _builder.append((Object)_DowncastToEObject);
        _builder.append(", ");
        CharSequence _DowncastToEObject_1 = this.xptMetaModel.DowncastToEObject(it.getTargetType(), dstVar);
        _builder.append((Object)_DowncastToEObject_1);
        _builder.append(", ");
        CharSequence _DowncastToEObject_2 = this.xptMetaModel.DowncastToEObject(it.getMetaClass(), "link");
        _builder.append((Object)_DowncastToEObject_2);
        _builder.append(", ");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType((GenCommonBase)genLink);
        _builder.append((Object)_accessElementType);
        _builder.append(", ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)genLink);
        _builder.append((Object)_visualID);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence checkLinkVisualID(TypeLinkModelFacet it, GenLink genLink, boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (!");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)genLink);
        _builder.append((Object)_visualID);
        _builder.append(".equals(");
        CharSequence _linkWithClassVisualIDMethodCall = this.xptVisualIDRegistry.getLinkWithClassVisualIDMethodCall(genLink.getDiagram());
        _builder.append((Object)_linkWithClassVisualIDMethodCall);
        _builder.append("(");
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getMetaClass(), "link");
        _builder.append((Object)_DowncastToEObject);
        _builder.append("))) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
        _builder.append((Object)_stopLinkProcessing, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence defineLinkSource(TypeLinkModelFacet it, boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isListType = it.getSourceMetaFeature().isListType();
        if (_isListType) {
            _builder.append("java.util.List<?> sources = ");
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getSourceMetaFeature(), "link", it.getMetaClass());
            _builder.append((Object)_featureValue);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("Object theSource = sources.size() == 1 ? sources.get(0) : null;");
            _builder.newLine();
            _builder.append("if (");
            CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getSourceType(), "theSource");
            _builder.append((Object)_NotInstance);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
            _builder.append((Object)_stopLinkProcessing, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)it.getSourceType(), "src", "theSource", true);
            _builder.append((Object)_DeclareAndAssign);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(it.getSourceType(), "src", "link", it.getMetaClass(), it.getSourceMetaFeature());
            _builder.append((Object)_DeclareAndAssign_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence checkLinkSource(TypeLinkModelFacet it, boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (src != source) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
        _builder.append((Object)_stopLinkProcessing, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence defineLinkDestination(TypeLinkModelFacet it, Boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isListType = it.getTargetMetaFeature().isListType();
        if (_isListType) {
            _builder.append("java.util.List<?> targets = ");
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getTargetMetaFeature(), "link", it.getMetaClass());
            _builder.append((Object)_featureValue);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("Object theTarget = targets.size() == 1 ? targets.get(0) : null;");
            _builder.newLine();
            _builder.append("if (");
            CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getTargetType(), "theTarget");
            _builder.append((Object)_NotInstance);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
            _builder.append((Object)_stopLinkProcessing, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)it.getTargetType(), "dst", "theTarget", true);
            _builder.append((Object)_DeclareAndAssign);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(it.getTargetType(), "dst", "link", it.getMetaClass(), it.getTargetMetaFeature());
            _builder.append((Object)_DeclareAndAssign_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence stopLinkProcessing(boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        if (inLoop) {
            _builder.append("continue;");
            _builder.newLine();
        } else {
            _builder.append("return result;");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getIncomingLinksByTypeMethod(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("protected java.util.Collection<");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)it));
        _builder.append((Object)_qualifiedClassName, "\t\t\t");
        _builder.append("> ");
        CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(it, UpdaterLinkType.INCOMING);
        _builder.append((Object)_connectedLinksByTypeMethodName, "\t\t\t");
        _builder.append("(");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getModelFacet().getTargetType());
        _builder.append((Object)_QualifiedClassName, "\t\t\t");
        _builder.append(" target, ");
        CharSequence _typeOfCrossReferenceAdapter = this.typeOfCrossReferenceAdapter();
        _builder.append((Object)_typeOfCrossReferenceAdapter, "\t\t\t");
        _builder.append(" crossReferencer) {");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(this.diagramUpdater((GenCommonBase)it), "result");
        _builder.append((Object)_newLinkedListOfLinkDescriptors, " ");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("java.util.Collection<org.eclipse.emf.ecore.EStructuralFeature.Setting> settings = crossReferencer.getInverseReferences(target);");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("for (org.eclipse.emf.ecore.EStructuralFeature.Setting setting : settings) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _incomingLinksByTypeMethodBody = this.getIncomingLinksByTypeMethodBody(it.getModelFacet(), it);
        _builder.append((Object)_incomingLinksByTypeMethodBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("}");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("return result;  ");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _getIncomingLinksByTypeMethodBody(TypeLinkModelFacet it, GenLink genLink) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (setting.getEStructuralFeature() != ");
        CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(it.getTargetMetaFeature());
        _builder.append((Object)_MetaFeature);
        _builder.append(" || ");
        CharSequence _NotInstance = this.xptMetaModel.NotInstance(it.getMetaClass(), "setting.getEObject()");
        _builder.append((Object)_NotInstance);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("continue;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(it.getMetaClass(), "link", "setting.getEObject()");
        _builder.append((Object)_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _checkLinkVisualID = this.checkLinkVisualID(it, genLink, true);
        _builder.append((Object)_checkLinkVisualID, "\t");
        _builder.newLineIfNotEmpty();
        GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
        boolean bl = _tripleNotEquals = _sourceMetaFeature != null;
        if (_tripleNotEquals) {
            _builder.append("\t");
            CharSequence _defineLinkSource = this.defineLinkSource(it, true);
            _builder.append((Object)_defineLinkSource, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _addLinkDescriptor = this.addLinkDescriptor(it, genLink, "src", "target");
            _builder.append((Object)_addLinkDescriptor, "\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            CharSequence _defineLinkContainer = this.defineLinkContainer(it, true);
            _builder.append((Object)_defineLinkContainer, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _addLinkDescriptor_1 = this.addLinkDescriptor(it, genLink, "container", "target");
            _builder.append((Object)_addLinkDescriptor_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence defineLinkContainer(TypeLinkModelFacet it, boolean inLoop) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (false == ");
        CharSequence _IsContainerInstance = this.xptMetaModel.IsContainerInstance(it.getContainmentMetaFeature().getGenClass(), "link", it.getMetaClass());
        _builder.append((Object)_IsContainerInstance);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _stopLinkProcessing = this.stopLinkProcessing(inLoop);
        _builder.append((Object)_stopLinkProcessing, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        CharSequence _DeclareAndAssignContainer = this.xptMetaModel.DeclareAndAssignContainer(it.getContainmentMetaFeature().getGenClass(), "container", "link", it.getMetaClass());
        _builder.append((Object)_DeclareAndAssignContainer);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _getIncomingLinksByTypeMethodBody(FeatureLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (setting.getEStructuralFeature() == ");
        CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(it.getMetaFeature());
        _builder.append((Object)_MetaFeature);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("result.add(new ");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)genLink));
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append("(setting.getEObject(), ");
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getTargetType(), "target");
        _builder.append((Object)_DowncastToEObject, "\t");
        _builder.append(", ");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType((GenCommonBase)genLink);
        _builder.append((Object)_accessElementType, "\t");
        _builder.append(", ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)genLink);
        _builder.append((Object)_visualID, "\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _getIncomingLinksByTypeMethodBody(LinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet);
        return _builder;
    }

    public CharSequence getOutgoingLinksByTypeMethod(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _outgoingLinksByTypeMethod = this.getOutgoingLinksByTypeMethod(it.getModelFacet(), it);
        _builder.append((Object)_outgoingLinksByTypeMethod);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getOutgoingLinksByTypeMethodSignature(GenLink it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("protected java.util.Collection<");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)it));
        _builder.append((Object)_qualifiedClassName);
        _builder.append("> ");
        CharSequence _connectedLinksByTypeMethodName = this.getConnectedLinksByTypeMethodName(it, UpdaterLinkType.OUTGOING);
        _builder.append((Object)_connectedLinksByTypeMethodName);
        _builder.append("(");
        CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getModelFacet().getSourceType());
        _builder.append((Object)_QualifiedClassName);
        _builder.append(" source)");
        return _builder;
    }

    protected CharSequence _getOutgoingLinksByTypeMethod(FeatureLinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _outgoingLinksByTypeMethodSignature = this.getOutgoingLinksByTypeMethodSignature(genLink);
        _builder.append((Object)_outgoingLinksByTypeMethodSignature);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _newLinkedListOfLinkDescriptors = this.newLinkedListOfLinkDescriptors(this.diagramUpdater((GenCommonBase)genLink), "result");
        _builder.append((Object)_newLinkedListOfLinkDescriptors, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        boolean _isListType = it.getMetaFeature().isListType();
        if (_isListType) {
            _builder.append("\t");
            _builder.append("for (java.util.Iterator<?> destinations = ");
            CharSequence _featureValue = this.xptMetaModel.getFeatureValue(it.getMetaFeature(), "source", it.getSourceType());
            _builder.append((Object)_featureValue, "\t");
            _builder.append(".iterator(); destinations.hasNext();) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign((GenClassifier)it.getTargetType(), "destination", "destinations.next()", true);
            _builder.append((Object)_DeclareAndAssign, "\t\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            CharSequence _DeclareAndAssign_1 = this.xptMetaModel.DeclareAndAssign(it.getTargetType(), "destination", "source", it.getSourceType(), it.getMetaFeature());
            _builder.append((Object)_DeclareAndAssign_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if (destination == null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("result.add(new ");
        CharSequence _qualifiedClassName = this.linkDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)genLink));
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append("(");
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getSourceType(), "source");
        _builder.append((Object)_DowncastToEObject, "\t");
        _builder.append(", ");
        CharSequence _DowncastToEObject_1 = this.xptMetaModel.DowncastToEObject(it.getTargetType(), "destination");
        _builder.append((Object)_DowncastToEObject_1, "\t");
        _builder.append(", ");
        CharSequence _accessElementType = this.xptElementTypes.accessElementType((GenCommonBase)genLink);
        _builder.append((Object)_accessElementType, "\t");
        _builder.append(", ");
        CharSequence _visualID = VisualIDRegistry.visualID((GenCommonBase)genLink);
        _builder.append((Object)_visualID, "\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        boolean _isListType_1 = it.getMetaFeature().isListType();
        if (_isListType_1) {
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _getOutgoingLinksByTypeMethod(TypeLinkModelFacet it, GenLink genLink) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
        boolean bl = _tripleNotEquals = _sourceMetaFeature != null;
        if (_tripleNotEquals) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            CharSequence _outgoingLinksByTypeMethodSignature = this.getOutgoingLinksByTypeMethodSignature(genLink);
            _builder.append((Object)_outgoingLinksByTypeMethodSignature);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName((GenClassifier)it.getContainmentMetaFeature().getGenClass());
            _builder.append((Object)_QualifiedClassName, "\t");
            _builder.append(" container = null;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("// Find container element for the link.");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// Climb up by containment hierarchy starting from the source");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// and return the first element that is instance of the container class.");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for (org.eclipse.emf.ecore.EObject element = ");
            CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getSourceType(), "source");
            _builder.append((Object)_DowncastToEObject, "\t");
            _builder.append("; element != null && container == null; element = element.eContainer()) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("if (");
            CharSequence _IsInstance = this.xptMetaModel.IsInstance(it.getContainmentMetaFeature().getGenClass(), "element");
            _builder.append((Object)_IsInstance, "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("container = ");
            CharSequence _CastEObject = this.xptMetaModel.CastEObject(it.getContainmentMetaFeature().getGenClass(), "element");
            _builder.append((Object)_CastEObject, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (container == null) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return ");
            CharSequence _newEmptyList = this.newEmptyList();
            _builder.append((Object)_newEmptyList, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _containedLinksByTypeMethodBody = this.getContainedLinksByTypeMethodBody(it, genLink, true);
            _builder.append((Object)_containedLinksByTypeMethodBody, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}\t\t");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _getOutgoingLinksByTypeMethod(LinkModelFacet it, GenLink genLink) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _incorrectLinkModelFacet = this.incorrectLinkModelFacet(it);
        _builder.append((Object)_incorrectLinkModelFacet);
        return _builder;
    }

    public CharSequence incorrectLinkModelFacet(LinkModelFacet it) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Incorrect LinkModelFacet: " + String.valueOf(it));
        return _builder;
    }

    public CharSequence additions(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public CharSequence diagramUpdaterInstanceToUse(GenDiagramUpdater it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _customDiagramUpdaterSingletonPath = it.getCustomDiagramUpdaterSingletonPath();
        boolean bl = _tripleNotEquals = _customDiagramUpdaterSingletonPath != null;
        if (_tripleNotEquals) {
            String _customDiagramUpdaterSingletonPath_1 = it.getCustomDiagramUpdaterSingletonPath();
            _builder.append(_customDiagramUpdaterSingletonPath_1);
            _builder.newLineIfNotEmpty();
        } else {
            String _diagramUpdaterQualifiedClassName = it.getDiagramUpdaterQualifiedClassName();
            _builder.append(_diagramUpdaterQualifiedClassName);
            _builder.append(".INSTANCE");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence typeOfCrossReferenceAdapter() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter");
        return _builder;
    }

    public CharSequence _constructor(GenDiagramUpdater it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected ");
        String _diagramUpdaterClassName = it.getDiagramUpdaterClassName();
        _builder.append(_diagramUpdaterClassName);
        _builder.append("(){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// to prevent instantiation allowing the override");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence classSingleton(GenDiagramUpdater it) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _customDiagramUpdaterSingletonPath = it.getCustomDiagramUpdaterSingletonPath();
        boolean bl = _tripleEquals = _customDiagramUpdaterSingletonPath == null;
        if (_tripleEquals) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            _builder.append("public static final  ");
            String _diagramUpdaterQualifiedClassName = it.getDiagramUpdaterQualifiedClassName();
            _builder.append(_diagramUpdaterQualifiedClassName);
            _builder.append(" INSTANCE = new ");
            String _diagramUpdaterClassName = it.getDiagramUpdaterClassName();
            _builder.append(_diagramUpdaterClassName);
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence getICustomDiagramUpdater(GenContainerBase it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.papyrus.uml.diagram.common.part.ICustomDiagramUpdater<");
        CharSequence _qualifiedClassName = this.nodeDescriptor.qualifiedClassName(this.diagramUpdater((GenCommonBase)it));
        _builder.append((Object)_qualifiedClassName);
        _builder.append(">");
        return _builder;
    }

    @XbaseGenerated
    protected CharSequence listOfNodeDescriptors(EObject it) {
        if (it instanceof GenCommonBase) {
            return this._listOfNodeDescriptors((GenCommonBase)it);
        }
        if (it instanceof GenDiagramUpdater) {
            return this._listOfNodeDescriptors((GenDiagramUpdater)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    protected CharSequence listOfLinkDescriptors(EObject it) {
        if (it instanceof GenCommonBase) {
            return this._listOfLinkDescriptors((GenCommonBase)it);
        }
        if (it instanceof GenDiagramUpdater) {
            return this._listOfLinkDescriptors((GenDiagramUpdater)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence defineModelElement(GenContainerBase it) {
        if (it instanceof GenCompartment) {
            return this._defineModelElement((GenCompartment)it);
        }
        if (it != null) {
            return this._defineModelElement(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence getContainedLinks(GenCommonBase it) {
        if (it instanceof GenLink) {
            return this._getContainedLinks((GenLink)it);
        }
        if (it != null) {
            return this._getContainedLinks(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence chooseConnectedLinksByTypeMethodName(LinkModelFacet it, UpdaterLinkType type, GenLink genLink) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._chooseConnectedLinksByTypeMethodName((FeatureLinkModelFacet)it, type, genLink);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._chooseConnectedLinksByTypeMethodName((TypeLinkModelFacet)it, type, genLink);
        }
        if (it != null) {
            return this._chooseConnectedLinksByTypeMethodName(it, type, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{it, type, genLink}).toString());
    }

    @XbaseGenerated
    public CharSequence getConnectedLinksByTypeMethodFragment(LinkModelFacet it) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._getConnectedLinksByTypeMethodFragment((FeatureLinkModelFacet)it);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._getConnectedLinksByTypeMethodFragment((TypeLinkModelFacet)it);
        }
        if (it != null) {
            return this._getConnectedLinksByTypeMethodFragment(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence getContainedLinksByTypeMethod(LinkModelFacet it, GenLink genLink) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._getContainedLinksByTypeMethod((FeatureLinkModelFacet)it, genLink);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._getContainedLinksByTypeMethod((TypeLinkModelFacet)it, genLink);
        }
        if (it != null) {
            return this._getContainedLinksByTypeMethod(it, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, genLink).toString());
    }

    @XbaseGenerated
    public CharSequence getIncomingLinksByTypeMethodBody(LinkModelFacet it, GenLink genLink) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._getIncomingLinksByTypeMethodBody((FeatureLinkModelFacet)it, genLink);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._getIncomingLinksByTypeMethodBody((TypeLinkModelFacet)it, genLink);
        }
        if (it != null) {
            return this._getIncomingLinksByTypeMethodBody(it, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, genLink).toString());
    }

    @XbaseGenerated
    public CharSequence getOutgoingLinksByTypeMethod(LinkModelFacet it, GenLink genLink) {
        if (it instanceof FeatureLinkModelFacet) {
            return this._getOutgoingLinksByTypeMethod((FeatureLinkModelFacet)it, genLink);
        }
        if (it instanceof TypeLinkModelFacet) {
            return this._getOutgoingLinksByTypeMethod((TypeLinkModelFacet)it, genLink);
        }
        if (it != null) {
            return this._getOutgoingLinksByTypeMethod(it, genLink);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, genLink).toString());
    }
}

