/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.outline;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.m2m.atl.adt.debug.core.AtlBreakpoint;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.outline.AlphabeticalSorter;
import org.eclipse.m2m.atl.adt.ui.outline.AtlContentProvider;
import org.eclipse.m2m.atl.adt.ui.outline.AtlEMFConstants;
import org.eclipse.m2m.atl.adt.ui.outline.AtlLabelProvider;
import org.eclipse.m2m.atl.adt.ui.outline.AtlOutlinePage;
import org.eclipse.m2m.atl.adt.ui.outline.DefaultFilter;
import org.eclipse.m2m.atl.adt.ui.outline.DefaultSorter;
import org.eclipse.m2m.atl.adt.ui.outline.HideHelperFilter;
import org.eclipse.m2m.atl.adt.ui.outline.HideRuleFilter;
import org.eclipse.m2m.atl.adt.ui.outline.Root;
import org.eclipse.m2m.atl.engine.AtlNbCharFile;
import org.eclipse.m2m.atl.engine.AtlParser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AtlContentOutlinePage
extends AtlOutlinePage {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    public static final String ATL_OUTLINE_VIEW_CONTEXT_MENU_ID = "org.eclipse.m2m.atl.adt.outline.contextMenu";
    private ViewerSorter alphabeticalSorter;
    private ViewerSorter defaultSorter;
    private String cursorPosition;
    private int depth = 1;
    private IEditorInput editorInput;
    private AtlNbCharFile help;
    private ViewerFilter helperFilter;
    private ViewerFilter ruleFilter;
    private ViewerFilter defaultFilter;
    private boolean inputSet = false;
    private PerspectiveListener perspectiveListener;
    private Action refreshItemAction;
    private Action filterHelperAction;
    private Action filterRuleAction;
    private Action sorterAction;
    private Action addBreakPointAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Root root;
    private EObject selectedEo;
    private ITextEditor textEditor;

    public AtlContentOutlinePage(ITextEditor textEditor, IEditorInput editorInput, IDocumentProvider documentProvider) {
        this.textEditor = textEditor;
        this.editorInput = editorInput;
    }

    private void addBreakpoint() {
        IStructuredSelection is = (IStructuredSelection)this.treeViewer.getSelection();
        EObject element = (EObject)is.getFirstElement();
        String location = (String)element.eGet(AtlEMFConstants.sfLocation);
        int[] pos = this.help.getIndexChar(location);
        int charStart = pos[0];
        int charEnd = pos[1];
        IFileEditorInput ifei = (IFileEditorInput)this.editorInput;
        IFile ifile = ifei.getFile();
        int lineNumber = Integer.parseInt(location.split("-")[0].split(":")[0]);
        try {
            new AtlBreakpoint((IResource)ifile, location, lineNumber, charStart, charEnd);
        }
        catch (DebugException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private void addPerspectiveListener(IPerspectiveListener l) {
        this.getSite().getPage().getWorkbenchWindow().addPerspectiveListener(l);
    }

    private int computeDepth(IPerspectiveDescriptor ipd) {
        if ("org.eclipse.debug.ui.DebugPerspective".equals(ipd.getId())) {
            return -1;
        }
        return 1;
    }

    public void createActions() {
        this.cutAction = new Action("Cut"){

            public void run() {
            }
        };
        this.cutAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("cut.gif"));
        this.copyAction = new Action("Copy"){

            public void run() {
            }
        };
        this.copyAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("copy.gif"));
        this.pasteAction = new Action("Paste"){

            public void run() {
            }
        };
        this.pasteAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("paste.gif"));
        this.addBreakPointAction = new Action("Add breakpoint"){

            public void run() {
                AtlContentOutlinePage.this.addBreakpoint();
            }
        };
        this.refreshItemAction = new Action("Refresh"){

            public void run() {
                AtlContentOutlinePage.this.setUnit();
            }
        };
        this.refreshItemAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("refresh.gif"));
        this.refreshItemAction.setToolTipText("refresh outline");
        this.filterHelperAction = new Action("Hide Helpers", 2){

            public void run() {
                AtlContentOutlinePage.this.updateFilters(AtlContentOutlinePage.this.filterHelperAction);
            }
        };
        this.filterHelperAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("hideHelper.gif"));
        this.filterHelperAction.setToolTipText("Hide helpers");
        this.filterRuleAction = new Action("Hide rules", 2){

            public void run() {
                AtlContentOutlinePage.this.updateFilters(AtlContentOutlinePage.this.filterRuleAction);
            }
        };
        this.filterRuleAction.setToolTipText("Hide the rules");
        this.filterRuleAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("hideMatchedRule.gif"));
        this.sorterAction = new Action("Alphabetical sort", 2){

            public void run() {
                AtlContentOutlinePage.this.updateSorter(AtlContentOutlinePage.this.sorterAction);
            }
        };
        this.sorterAction.setImageDescriptor(AtlUIPlugin.getImageDescriptor("alphab_sort.gif"));
        this.sorterAction.setToolTipText("sort alphabetically");
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AtlContentOutlinePage.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(ATL_OUTLINE_VIEW_CONTEXT_MENU_ID, menuMgr, (ISelectionProvider)this);
    }

    public void createControl(Composite arg0) {
        super.createControl(arg0);
        this.root = new Root();
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.selectionChangedListeners.remove(listeners[i]);
            this.treeViewer.addPostSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        this.treeViewer.setContentProvider((IContentProvider)new AtlContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AtlLabelProvider());
        this.createActions();
        this.createContextMenu();
        this.createToolbar();
        this.createMenu();
        this.createFiltersAndSorters();
        this.setUnit();
        this.treeViewer.addFilter(this.defaultFilter);
        this.treeViewer.setSorter(this.defaultSorter);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.perspectiveListener = new PerspectiveListener();
        this.addPerspectiveListener(this.perspectiveListener);
        this.depth = this.computeDepth(this.getCurrentPerspective());
    }

    public void createFiltersAndSorters() {
        this.helperFilter = new HideHelperFilter();
        this.ruleFilter = new HideRuleFilter();
        this.defaultFilter = new DefaultFilter();
        this.alphabeticalSorter = new AlphabeticalSorter();
        this.defaultSorter = new DefaultSorter();
    }

    private void createMenu() {
        IMenuManager mgr = this.getSite().getActionBars().getMenuManager();
        mgr.add((IAction)this.refreshItemAction);
        mgr.add((IAction)this.filterHelperAction);
        mgr.add((IAction)this.filterRuleAction);
        mgr.add((IAction)this.sorterAction);
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.refreshItemAction);
        mgr.add((IAction)this.filterHelperAction);
        mgr.add((IAction)this.filterRuleAction);
        mgr.add((IAction)this.sorterAction);
    }

    private void doSetSelection(String cursorPosition) {
        if (cursorPosition != null && !this.treeViewer.getTree().isDisposed()) {
            this.cursorPosition = cursorPosition;
            Root input = (Root)this.treeViewer.getInput();
            if (input != null) {
                EObject unit = input.getUnit();
                int cursorIndexChar = this.help.getIndex(cursorPosition);
                if (cursorIndexChar == -1) {
                    return;
                }
                this.selectedEo = unit;
                this.setSelection(unit, cursorIndexChar, 0);
                this.treeViewer.collapseAll();
                this.treeViewer.expandToLevel(2);
                this.showItem(this.selectedEo);
            }
        }
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IAction)this.cutAction);
        mgr.add((IAction)this.copyAction);
        mgr.add((IAction)this.pasteAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.addBreakPointAction);
        mgr.add((IContributionItem)new Separator());
    }

    private IPerspectiveDescriptor getCurrentPerspective() {
        return this.getSite().getPage().getPerspective();
    }

    private int[] getPos(EObject eo) {
        String location = (String)eo.eGet(AtlEMFConstants.sfLocation);
        if (location == null) {
            return null;
        }
        int[] pos = this.help.getIndexChar(location);
        return pos;
    }

    private void initAtlNbCharFile(String content) {
        this.help = new AtlNbCharFile(this.toInputStream(content));
        ((DefaultSorter)this.defaultSorter).setHelp(this.help);
        ((AtlEditor)this.textEditor).setHelp(this.help);
    }

    public void setUnit() {
        String newContent = ((AtlEditor)this.textEditor).getDocumentProviderContent();
        AtlParser parser = AtlParser.getDefault();
        EObject eo = parser.parse(this.toInputStream(newContent));
        if (eo != null) {
            this.root.setUnit(eo);
            if (!this.inputSet) {
                this.treeViewer.setInput((Object)this.root);
                this.inputSet = true;
            }
            this.initAtlNbCharFile(newContent);
            this.treeViewer.refresh((Object)this.root);
            this.treeViewer.expandToLevel(2);
        }
    }

    private void setSelection(EObject input, int cursorIndexChar, int currentLevel) {
        if (input == null || input.eContents() == null || input.eContents().isEmpty()) {
            return;
        }
        Object[] contents = input.eContents().toArray();
        int i = 0;
        while (i < contents.length) {
            EObject eo = (EObject)contents[i];
            int[] pos = this.getPos(eo);
            if (pos != null) {
                int eoStartChar = pos[0];
                int eoEndChar = pos[1];
                if (eoStartChar <= cursorIndexChar && eoEndChar >= cursorIndexChar) {
                    this.selectedEo = eo;
                    if (currentLevel + 1 >= this.depth && this.depth != -1) break;
                    this.setSelection(eo, cursorIndexChar, currentLevel + 1);
                    break;
                }
            }
            ++i;
        }
    }

    public void setSelection(String cursorPosition) {
        this.doSetSelection(cursorPosition);
    }

    public void setTextEditorOpened(boolean isTextEditorOpened) {
    }

    private void showItem(EObject element) {
        int[] pos = this.getPos(element);
        if (pos != null) {
            this.textEditor.setHighlightRange(pos[0], pos[1] - pos[0], false);
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
    }

    private InputStream toInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    protected void updateFilters(Action action) {
        if (action == this.filterHelperAction) {
            if (action.isChecked()) {
                this.treeViewer.addFilter(this.helperFilter);
            } else {
                this.treeViewer.removeFilter(this.helperFilter);
            }
        } else if (action == this.filterRuleAction) {
            if (action.isChecked()) {
                this.treeViewer.addFilter(this.ruleFilter);
            } else {
                this.treeViewer.removeFilter(this.ruleFilter);
            }
        }
    }

    protected void updateSorter(Action action) {
        if (action == this.sorterAction) {
            if (action.isChecked()) {
                this.treeViewer.setSorter(this.alphabeticalSorter);
            } else {
                this.treeViewer.setSorter(this.defaultSorter);
            }
        }
    }

    public EObject getModel() {
        return this.root.getUnit();
    }

    private class PerspectiveListener
    implements IPerspectiveListener {
        private PerspectiveListener() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (page == AtlContentOutlinePage.this.getSite().getPage()) {
                int newDepth = AtlContentOutlinePage.this.computeDepth(perspective);
                if (AtlContentOutlinePage.this.depth != newDepth) {
                    AtlContentOutlinePage.this.depth = newDepth;
                    AtlContentOutlinePage.this.doSetSelection(AtlContentOutlinePage.this.cursorPosition);
                }
            }
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    }
}

