/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AssociationStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.AttributeStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.ClassStatus;
import org.eclipse.qvtd.pivot.qvtimperative.evaluationstatus.PropertyStatus;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;
import org.eclipse.qvtd.runtime.evaluation.AbstractExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.ExecutionVisitor;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.evaluation.Transformer;

public class Execution2GraphVisitor
extends AbstractExecutionVisitor<String> {
    protected static @NonNull String NULL_PLACEHOLDER = "\"<null>\"";
    protected final @NonNull GraphStringBuilder context;
    private Map<AssociationStatus, String> associationId = new HashMap<AssociationStatus, String>();
    private Map<ClassStatus, String> classId = new HashMap<ClassStatus, String>();
    private Map<Invocation, GraphStringBuilder.GraphNode> invocation2node = new HashMap<Invocation, GraphStringBuilder.GraphNode>();
    private Map<Object, GraphStringBuilder.GraphNode> object2node = new HashMap<Object, GraphStringBuilder.GraphNode>();
    private Map<SlotState, GraphStringBuilder.GraphNode> slot2node = new HashMap<SlotState, GraphStringBuilder.GraphNode>();

    public Execution2GraphVisitor(@NonNull GraphStringBuilder s) {
        this.context = s;
    }

    protected void appendEdge(@NonNull GraphStringBuilder.GraphNode sourceNode, @NonNull GraphStringBuilder.GraphNode targetNode, @NonNull String color) {
        this.context.appendEdge(sourceNode, new ExecutionEdge(sourceNode, targetNode, color), targetNode);
    }

    protected @NonNull String getAssociationColor(@NonNull AssociationStatus associationStatus) {
        if (associationStatus.isIsInput()) {
            return associationStatus.isIsOutput() ? "#ccffff" : "#ccff00";
        }
        return associationStatus.isIsOutput() ? "#cc80ff" : "#cc0000";
    }

    protected @NonNull String getAssociationId(@NonNull AssociationStatus object) {
        String id = this.associationId.get(object);
        if (id == null) {
            id = "a" + this.associationId.size() + 1;
            this.associationId.put(object, id);
        }
        return id;
    }

    protected String getAssociationLabel(@NonNull AssociationStatus associationStatus) {
        EReference forwardReference = associationStatus.getForwardEReference();
        EReference oppositeReference = forwardReference.getEOpposite();
        String firstName = forwardReference.getName();
        String secondName = oppositeReference.getName();
        boolean swap = false;
        swap = forwardReference.isMany() != oppositeReference.isMany() ? forwardReference.isMany() : firstName.compareTo(secondName) > 0;
        return swap ? String.valueOf(secondName) + " / " + firstName : String.valueOf(firstName) + " / " + secondName;
    }

    protected @NonNull String getAttributeId(@NonNull AttributeStatus attributeStatus) {
        ClassStatus classStatus = attributeStatus.getOwningClassStatus();
        assert (classStatus != null);
        return String.valueOf(this.getClassId(classStatus)) + "-" + attributeStatus.getEFeature().getName();
    }

    protected @NonNull String getClassColor(@NonNull ClassStatus classStatus) {
        if (classStatus.isIsInput()) {
            return classStatus.isIsOutput() ? "#ccffff" : "#ccff00";
        }
        return classStatus.isIsOutput() ? "#cc80ff" : "#cc0000";
    }

    protected @NonNull String getClassId(@NonNull ClassStatus object) {
        String id = this.classId.get(object);
        if (id == null) {
            id = String.valueOf(object.getType().getName()) + "-" + (this.classId.size() + 1);
            this.classId.put(object, id);
        }
        return id;
    }

    protected @NonNull GraphStringBuilder.GraphNode getInvocationNode(@NonNull Invocation object) {
        GraphStringBuilder.GraphNode node = this.invocation2node.get(object);
        if (node == null) {
            final String label = object instanceof EObject ? String.valueOf(((EObject)object).eClass().getName()) + "-" + (this.invocation2node.size() + 1) : object.toString().replace("@", "\n@");
            node = new GraphStringBuilder.GraphNode(){

                @Override
                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(label);
                    s.setShape("hexagon");
                    s.setColor("orange");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.invocation2node.put(object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    protected @NonNull GraphStringBuilder.GraphNode getObjectNode(@NonNull Object object) {
        GraphStringBuilder.GraphNode node = this.object2node.get(object);
        if (node == null) {
            final String label = object instanceof EObject ? String.valueOf(((EObject)object).eClass().getName()) + "-" + (this.object2node.size() + 1) : object.toString().replace("@", "\n@");
            node = new GraphStringBuilder.GraphNode(){

                @Override
                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(label);
                    s.setShape("rectangle");
                    s.setColor("blue");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.object2node.put(object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    protected @NonNull String getPropertyId(@NonNull PropertyStatus object) {
        if (object instanceof AssociationStatus) {
            return this.getAssociationId((AssociationStatus)object);
        }
        if (object instanceof AttributeStatus) {
            return this.getAttributeId((AttributeStatus)object);
        }
        throw new UnsupportedOperationException();
    }

    protected @NonNull GraphStringBuilder.GraphNode getSlotNode(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SlotState.Incremental object) {
        GraphStringBuilder.GraphNode node;
        if (object.getValue() != null) {
            object = object.getPrimarySlotState();
        }
        if ((node = this.slot2node.get(object)) == null) {
            EReference eOpposite;
            final EStructuralFeature eFeature = object.getEFeature();
            String label = eFeature.getName();
            if (eFeature instanceof EReference && (eOpposite = ((EReference)eFeature).getEOpposite()) != null) {
                label = String.valueOf(label) + " / " + eOpposite.getName();
            }
            final String finalLabel = label;
            node = new GraphStringBuilder.GraphNode(){

                @Override
                public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
                    s.setLabel(finalLabel);
                    s.setShape("rectangle");
                    if (eFeature instanceof EAttribute) {
                        s.setStyle("rounded");
                    }
                    s.setColor("blue");
                    s.appendAttributedNode(nodeName);
                }
            };
            this.slot2node.put((SlotState)object, node);
            this.context.appendNode(node);
        }
        return node;
    }

    public @Nullable String visitInvocation(@NonNull Invocation object) {
        GraphStringBuilder.GraphNode invocationNode = this.getInvocationNode(object);
        return null;
    }

    public @Nullable String visitInvocationManager(@NonNull InvocationManager object) {
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable String visitObjectManager(@NonNull ObjectManager objectManager) {
        HashSet<@NonNull E> allInvocations = new HashSet();
        HashSet<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SlotState.Incremental> allSlots = new HashSet<SlotState.Incremental>();
        HashMap<@NonNull T, ArrayList<@NonNull E>> object2slots = new HashMap();
        for (Object object : objectManager.getObjects()) {
            ArrayList<SlotState.Incremental> objectSlots = new ArrayList<SlotState.Incremental>();
            for (SlotState slotState : objectManager.getSlotStates(object)) {
                if (!(slotState instanceof SlotState.Incremental)) continue;
                allSlots.add((SlotState.Incremental)slotState);
                objectSlots.add((SlotState.Incremental)slotState);
            }
            object2slots.put(object, objectSlots);
        }
        for (SlotState.Incremental slotState : allSlots) {
            Iterables.addAll(allInvocations, (Iterable)slotState.getSources());
            Iterables.addAll(allInvocations, (Iterable)slotState.getTargets());
            slotState.accept((ExecutionVisitor)this);
        }
        for (Invocation.Incremental invocation : allInvocations) {
            invocation.accept((ExecutionVisitor)this);
            GraphStringBuilder.GraphNode invocationNode = this.getInvocationNode((Invocation)invocation);
            for (Object createdObject : invocation.getCreatedObjects()) {
                GraphStringBuilder.GraphNode objectNode = this.getObjectNode(createdObject);
                this.appendEdge(invocationNode, objectNode, "green");
            }
        }
        for (SlotState.Incremental slotState : allSlots) {
            GraphStringBuilder.GraphNode slotNode = this.getSlotNode(slotState);
            slotState.accept((ExecutionVisitor)this);
            for (Invocation invocation : slotState.getSources()) {
                this.appendEdge(this.getInvocationNode(invocation), slotNode, "green");
            }
            for (Invocation invocation : slotState.getTargets()) {
                this.appendEdge(slotNode, this.getInvocationNode(invocation), "cyan");
            }
            Iterables.addAll(allInvocations, (Iterable)slotState.getTargets());
        }
        for (Object object : objectManager.getObjects()) {
            GraphStringBuilder.GraphNode objectNode = this.getObjectNode(object);
            @NonNull List slots = (List)object2slots.get(object);
            if (slots == null) continue;
            for (SlotState.Incremental slotState : slots) {
                GraphStringBuilder.GraphNode slotNode = this.getSlotNode(slotState);
                slotState.accept((ExecutionVisitor)this);
                this.appendEdge(objectNode, slotNode, "blue");
            }
        }
        return null;
    }

    public @Nullable String visitSlotState(@NonNull SlotState object) {
        GraphStringBuilder.GraphNode slotNode = this.getSlotNode((SlotState.Incremental)object);
        return null;
    }

    public @Nullable String visitTransformer(@NonNull Transformer object) {
        return null;
    }

    protected static final class ExecutionEdge
    implements GraphStringBuilder.GraphEdge {
        private final @NonNull GraphStringBuilder.GraphNode sourceNode;
        private final @NonNull GraphStringBuilder.GraphNode targetNode;
        private final @NonNull String color;

        protected ExecutionEdge(@NonNull GraphStringBuilder.GraphNode sourceNode, @NonNull GraphStringBuilder.GraphNode targetNode, @NonNull String color) {
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            this.color = color;
        }

        @Override
        public void appendEdgeAttributes(@NonNull GraphStringBuilder s, @NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphNode target) {
            s.setColor(this.color);
            s.appendAttributedEdge(source, this, target);
        }

        @Override
        public @NonNull GraphStringBuilder.GraphNode getSource() {
            return this.sourceNode;
        }

        @Override
        public @NonNull GraphStringBuilder.GraphNode getTarget() {
            return this.targetNode;
        }
    }
}

