/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphMLBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public class GraphMLStringBuilder
extends GraphMLBuilder
implements GraphStringBuilder {
    private static final @NonNull Map<String, String> colorName2colorCode = new HashMap<String, String>();
    private final @NonNull Map<Object, String> node2name = new HashMap<Object, String>();
    private int graphCount = 0;
    private @NonNull String color = "#cccccc";
    private @Nullable String label = null;
    private @NonNull String penwidth = "2.0";
    private @NonNull String shape = "rectangle";
    private @NonNull GraphMLBuilder.LineType lineType = GraphMLBuilder.LineType.line;
    private @NonNull String labelColor = "#000000";
    private @NonNull GraphMLBuilder.ArrowType sourceArrowType = GraphMLBuilder.ArrowType.none;
    private @NonNull GraphMLBuilder.ArrowType targetArrowType = GraphMLBuilder.ArrowType.delta;

    static {
        colorName2colorCode.put("black", "#000000");
        colorName2colorCode.put("brown", "#993300");
        colorName2colorCode.put("blue", "#0000ff");
        colorName2colorCode.put("cyan", "#00ffff");
        colorName2colorCode.put("green", "#00ff00");
        colorName2colorCode.put("magenta", "#ff00ff");
        colorName2colorCode.put("orange", "#ffcc00");
        colorName2colorCode.put("red", "#ff0000");
        colorName2colorCode.put("white", "#ffffff");
        colorName2colorCode.put("yellow", "#ffff00");
    }

    public GraphMLStringBuilder() {
        this.open();
    }

    @Override
    public void appendAttributedEdge(@NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphEdge edge, @NonNull GraphStringBuilder.GraphNode target) {
        String sourceName = this.appendNode(source);
        String targetName = this.appendNode(target);
        String sourceId = sourceName;
        String targetId = targetName;
        String lineColor = this.color;
        Double width = Double.valueOf(this.penwidth);
        this.s.pushTag("edge");
        this.appendEdgeId();
        this.appendEdgeSource(sourceId);
        this.appendEdgeTarget(targetId);
        this.s.pushTag("data");
        this.s.appendElement("key", "d9");
        this.s.pushTag("y:PolyLineEdge");
        this.appendLineStyle(new GraphMLBuilder.LineStyle(lineColor, this.lineType, width));
        this.appendArrows(this.sourceArrowType.name(), this.targetArrowType.name());
        this.appendEdgeLabel(this.label, this.labelColor);
        this.s.popTag();
        this.s.popTag();
        this.s.popTag();
        this.resetAttributes();
    }

    @Override
    public void appendAttributedNode(@NonNull String nodeName) {
        String id = nodeName;
        String shapeName = this.shape;
        String fillColor = "#ffffff";
        String lineColor = this.color;
        GraphMLBuilder.LineType lineType = GraphMLBuilder.LineType.line;
        Double width = Double.valueOf(this.penwidth);
        this.s.pushTag("node");
        this.s.appendElement("id", "n" + id);
        this.appendData("d5");
        this.s.pushTag("data");
        this.s.appendElement("key", "d6");
        this.s.pushTag("y:ShapeNode");
        GraphMLBuilder.Geometry g = new GraphMLBuilder.Geometry();
        g.adjustToText(this.label, 12, shapeName);
        this.appendGeometry(g);
        this.appendFill(fillColor);
        this.appendBorder(new GraphMLBuilder.BorderStyle(lineColor, lineType, width));
        this.appendNodeLabel(this.label, this.labelColor);
        this.appendShape(shapeName);
        this.s.popTag();
        this.s.popTag();
        this.s.popTag();
        this.resetAttributes();
    }

    @Override
    public void appendEdge(@NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphEdge edge, @NonNull GraphStringBuilder.GraphNode target) {
        this.resetAttributes();
        edge.appendEdgeAttributes(this, source, target);
        this.resetAttributes();
    }

    @Override
    public @NonNull String appendNode(@NonNull GraphStringBuilder.GraphNode object) {
        String name = this.node2name.get(object);
        if (name == null) {
            name = "a" + this.node2name.size();
            this.node2name.put(object, name);
            this.resetAttributes();
            object.appendNode(this, name);
        }
        return name;
    }

    @Override
    public void popCluster() {
        this.s.popTag();
        this.s.popTag();
    }

    @Override
    public void pushCluster() {
        this.s.pushTag("node");
        this.s.appendElement("id", "gn" + this.graphCount++);
        this.appendData("d5");
        this.s.pushTag("data");
        this.s.appendElement("key", "d6");
        this.s.pushTag("y:ShapeNode");
        this.appendFill("#ffffff");
        this.s.appendTextBegin("y:NodeLabel");
        this.s.appendElement("fontSize", "16");
        this.s.appendElement("modelName", "sides");
        this.s.appendElement("modelPosition", "n");
        this.s.appendTextEnd(this.label);
        this.s.popTag();
        this.s.popTag();
        this.s.pushTag("graph");
        this.s.appendElement("id", "gg" + this.graphCount++);
        this.s.appendElement("edgedefault", "directed");
    }

    protected void resetAttributes() {
        this.color = "#000000";
        this.label = null;
        this.lineType = GraphMLBuilder.LineType.line;
        this.penwidth = "2.0";
        this.shape = "rectangle";
        this.sourceArrowType = GraphMLBuilder.ArrowType.none;
        this.targetArrowType = GraphMLBuilder.ArrowType.delta;
    }

    @Override
    public void setArrowhead(@NonNull String arrowhead) {
        if ("oinv".equals(arrowhead)) {
            this.sourceArrowType = GraphMLBuilder.ArrowType.delta;
            this.targetArrowType = GraphMLBuilder.ArrowType.none;
        }
    }

    @Override
    public void setColor(@NonNull String colorName) {
        String colorCode = colorName2colorCode.get(colorName);
        this.color = colorCode != null ? colorCode : "#777777";
    }

    @Override
    public void setHead() {
    }

    @Override
    public void setLabel(String label) {
        String replace = "  " + label.replace("\\n", "  \n  ") + "  ";
        if (replace.length() < 10) {
            replace = "   " + replace + "    ";
        }
        this.label = replace;
    }

    @Override
    public void setPenwidth(@NonNull Integer penwidth) {
        this.penwidth = penwidth.toString();
    }

    @Override
    public void setShape(@NonNull String shape) {
        this.shape = shape;
    }

    @Override
    public void setStyle(@NonNull String style) {
        if ("dashed".equals(style)) {
            this.lineType = GraphMLBuilder.LineType.dashed;
        } else if ("dotted".equals(style)) {
            this.lineType = GraphMLBuilder.LineType.dotted;
        }
        if ("rounded".equals(style)) {
            this.shape = GraphMLBuilder.ShapeType.roundrectangle.toString();
        }
    }

    @Override
    public @NonNull String toString() {
        this.close();
        return super.toString();
    }
}

