/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.internal.qvtc2qvtu.QVTuConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.utilities.JavaSourceFileObject;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

public class QVTrCompilerChain
extends AbstractCompilerChain {
    public QVTrCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @Nullable Map<@NonNull String, @NonNull Map<@NonNull CompilerChain.Key<?>, @Nullable Object>> options) {
        super(environmentFactory, txURI, options);
    }

    @Override
    public @NonNull Transformation compile(@NonNull String enforcedOutputName) throws IOException {
        Resource rResource = QVTrelationUtil.loadTransformations((EnvironmentFactory)this.environmentFactory, (URI)this.txURI, (boolean)false);
        List missingOperationCallSources = QVTbaseUtil.rewriteMissingOperationCallSources((EnvironmentFactory)this.environmentFactory, (Resource)rResource);
        if (missingOperationCallSources != null) {
            System.err.println("Missing OperationCallExp sources  were fixed up for '" + this.txURI + "'");
        }
        this.compiled("QVTr", rResource);
        Resource cResource = this.qvtr2qvtc(rResource);
        assert (cResource != null);
        QVTuConfiguration qvtuConfiguration = this.createQVTuConfiguration(cResource, QVTuConfiguration.Mode.ENFORCE, enforcedOutputName);
        Resource pResource = this.qvtc2qvtp(cResource, qvtuConfiguration);
        return this.qvtp2qvti(pResource);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Resource qvtr2qvtc(@NonNull Resource rResource) throws IOException {
        URI classURI = (URI)this.getOption("Class", URI_KEY);
        URI qvtcURI = this.getURI("QVTc", URI_KEY);
        URI traceURI = this.getURI("Trace", URI_KEY);
        URI genModelURI = this.getURI("GenModel", URI_KEY);
        @NonNull @Nullable Map traceOptions = (Map)this.getOption("Trace", TRACE_OPTIONS_KEY);
        String traceNsURI = traceOptions != null ? (String)traceOptions.get("traceNsURI") : null;
        Resource cResource = this.createResource(qvtcURI);
        Resource traceResource = this.createResource(PivotUtilInternal.getASURI((URI)traceURI));
        QVTr2QVTc t = new QVTr2QVTc((EnvironmentFactory)this.environmentFactory, rResource, cResource);
        if (traceNsURI != null) {
            t.setTraceNsURI(traceNsURI);
        }
        t.prepare();
        t.transformToTracePackages();
        Map saveOptions = (Map)this.getOption("Trace", SAVE_OPTIONS_KEY);
        if (saveOptions == null) {
            saveOptions = XMIUtil.createSaveOptions();
        }
        t.saveTrace(traceResource, traceURI, genModelURI, traceOptions, saveOptions);
        QVTrCompilerChain.assertNoResourceErrors("Trace save", traceResource);
        this.compiled("Trace", cResource);
        t.transformToCoreTransformations();
        saveOptions = (Map)this.getOption("QVTr", SAVE_OPTIONS_KEY);
        if (saveOptions == null) {
            saveOptions = XMIUtil.createSaveOptions();
        }
        t.saveCore(cResource, saveOptions);
        QVTrCompilerChain.assertNoResourceErrors("Core save", cResource);
        this.compiled("QVTc", cResource);
        saveOptions = (Map)this.getOption("GenModel", SAVE_OPTIONS_KEY);
        if (saveOptions == null) {
            saveOptions = XMIUtil.createSaveOptions();
        }
        saveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        @NonNull Collection usedGenPackages = (Collection)this.getOption("GenModel", GENMODEL_USED_GENPACKAGES_KEY);
        GenModel genModel = t.saveGenModel(traceResource, traceURI, genModelURI, (Map)this.getOption("GenModel", GENMODEL_OPTIONS_KEY), saveOptions, usedGenPackages);
        if (classURI != null) {
            List<String> classpathProjects;
            String sourcePathPrefix;
            String objectPath;
            File binFile;
            t.generateModels(genModel);
            String binProjectName = t.getProjectName(traceURI);
            if (EcorePlugin.IS_ECLIPSE_RUNNING) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject binProject = root.getProject(binProjectName);
                IFolder binFolder = binProject.getFolder("bin");
                binFile = URIUtil.toFile((java.net.URI)binFolder.getLocationURI());
                objectPath = binFile.toString().replace("\\", "/");
                IFile genIFile = root.getFile((IPath)new Path(genModel.getModelDirectory()));
                File genFile = URIUtil.toFile((java.net.URI)genIFile.getLocationURI());
                sourcePathPrefix = genFile.getAbsolutePath().replace("\\", "/");
                classpathProjects = JavaSourceFileObject.createClasspathProjectList("org.eclipse.emf.common", "org.eclipse.emf.ecore", "org.eclipse.jdt.annotation", "org.eclipse.ocl.pivot", "org.eclipse.osgi", "org.eclipse.qvtd.runtime");
            } else {
                ResourceSet resourceSet = this.environmentFactory.getResourceSet();
                URI normalizedClassURI = resourceSet.getURIConverter().normalize(classURI);
                objectPath = normalizedClassURI.toFileString();
                assert (objectPath != null);
                URI location = (URI)ClassUtil.nonNullState((Object)((StandaloneProjectMap)this.environmentFactory.getProjectManager()).getLocation(binProjectName));
                binFile = new File(location.appendSegment("bin").toFileString());
                URI genModelDirectoryURI = URI.createPlatformResourceURI((String)genModel.getModelDirectory(), (boolean)true);
                sourcePathPrefix = String.valueOf(resourceSet.getURIConverter().normalize(genModelDirectoryURI).toFileString()) + "/";
                classpathProjects = null;
            }
            binFile.mkdir();
            for (GenPackage genPackage : genModel.getGenPackages()) {
                String basePackage = genPackage.getBasePackage();
                String sourcePath = String.valueOf(sourcePathPrefix) + (basePackage != null ? "/" + basePackage.replace(".", "/") : "");
                JavaSourceFileObject.compileClasses(sourcePath, objectPath, classpathProjects);
            }
        }
        this.compiled("GenModel", cResource);
        return cResource;
    }
}

