/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassRelationships;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Connection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DependencyAnalyzer;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.EdgeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.QVTp2QVTg;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Symbolable;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameReservation;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.DOTStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.schedule.AbstractDatum;
import org.eclipse.qvtd.pivot.schedule.ClassDatum;
import org.eclipse.qvtd.pivot.schedule.MappingAction;
import org.eclipse.qvtd.pivot.schedule.PropertyDatum;
import org.eclipse.qvtd.pivot.schedule.Schedule;

public abstract class SchedulerConstants {
    public static final @NonNull List<@NonNull Connection> EMPTY_CONNECTION_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull EdgeConnection> EMPTY_EDGE_CONNECTION_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull Edge> EMPTY_EDGE_LIST = Collections.emptyList();
    public static final @NonNull Set<@NonNull SimpleMappingRegion> EMPTY_MAPPING_REGION_SET = Collections.emptySet();
    public static final @NonNull List<@NonNull NavigationEdge> EMPTY_NAVIGATION_EDGE_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull Node> EMPTY_NODE_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull NodeConnection> EMPTY_NODE_CONNECTION_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull Region> EMPTY_REGION_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull SimpleEdge> EMPTY_SIMPLE_EDGE_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull SimpleNode> EMPTY_SIMPLE_NODE_LIST = Collections.emptyList();
    public static final @NonNull List<@NonNull TypedElement> EMPTY_TYPED_ELEMENT_LIST = Collections.emptyList();
    private final @NonNull Schedule dependencyGraph;
    private final @NonNull RootDomainUsageAnalysis domainAnalysis;
    private final @NonNull QVTp2QVTg qvtp2qvtg;
    private final @NonNull DomainUsage inputUsage;
    private final @NonNull EnvironmentFactory environmentFactory;
    private final @NonNull Transformation transformation;
    private final @NonNull OperationId collectionSelectByKindId;
    private final @NonNull OperationId oclAnyEqualsId;
    private final @NonNull OperationId oclAnyOclAsSetId;
    private final @NonNull OperationId oclAnyOclAsTypeId;
    private final @NonNull OperationId oclAnyOclIsKindOfId;
    private final @NonNull OperationId oclElementOclContainerId;
    private final @NonNull ClassDatumAnalysis oclVoidClassDatumAnalysis;
    private final @NonNull Property oclContainerProperty;
    private final @NonNull Map<ClassDatum, ClassDatumAnalysis> classDatum2classDatumAnalysis = new HashMap<ClassDatum, ClassDatumAnalysis>();
    private final @NonNull Map<Property, PropertyDatum> property2propertyDatum = new HashMap<Property, PropertyDatum>();
    private final @NonNull Map<Type, Property> type2castProperty = new HashMap<Type, Property>();
    private final @NonNull Map<Type, Property> type2iterateProperty = new HashMap<Type, Property>();
    private final @NonNull Map<String, Property> name2argumentProperty = new HashMap<String, Property>();
    private @Nullable DependencyAnalyzer dependencyAnalyzer = null;
    private @NonNull SymbolNameReservation symbolNameReservation = new SymbolNameReservation();

    public static @NonNull String getMultiplicity(@NonNull TypedElement typedElement) {
        StringBuilder s = new StringBuilder();
        Type type = typedElement.getType();
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            Number lower = collectionType.getLower();
            Number upper = collectionType.getUpper();
            StringUtil.appendMultiplicity((StringBuilder)s, (long)lower.intValue(), (long)(upper instanceof Unlimited ? -1 : upper.intValue()), (boolean)collectionType.isIsNullFree());
        } else {
            s.append(typedElement.isIsRequired() ? "[1]" : "[?]");
        }
        return s.toString();
    }

    public SchedulerConstants(@NonNull EnvironmentFactory environmentFactory, @NonNull Schedule dependencyGraph, @NonNull QVTp2QVTg qvtp2qvtg) {
        this.environmentFactory = environmentFactory;
        this.dependencyGraph = dependencyGraph;
        this.domainAnalysis = qvtp2qvtg.getDomainUsageAnalysis();
        this.qvtp2qvtg = qvtp2qvtg;
        this.transformation = (Transformation)ClassUtil.nonNullState((Object)QVTbaseUtil.getContainingTransformation((EObject)((MappingAction)dependencyGraph.getActions().get(0)).getMapping()));
        this.inputUsage = this.domainAnalysis.getInputUsage();
        StandardLibrary standardLibrary = environmentFactory.getStandardLibrary();
        Class oclAnyType = standardLibrary.getOclAnyType();
        Class oclElementType = standardLibrary.getOclElementType();
        Operation operation1 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"=");
        assert (operation1 != null);
        this.oclAnyEqualsId = operation1.getOperationId();
        Operation operation2 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"oclAsType");
        assert (operation2 != null);
        this.oclAnyOclAsTypeId = operation2.getOperationId();
        Operation operation3 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"oclIsKindOf");
        assert (operation3 != null);
        this.oclAnyOclIsKindOfId = operation3.getOperationId();
        Operation operation4 = (Operation)NameUtil.getNameable((Iterable)oclElementType.getOwnedOperations(), (String)"oclContainer");
        assert (operation4 != null);
        this.oclElementOclContainerId = operation4.getOperationId();
        Operation operation5 = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"oclAsSet");
        assert (operation5 != null);
        this.oclAnyOclAsSetId = operation5.getOperationId();
        Operation operation6 = (Operation)NameUtil.getNameable((Iterable)standardLibrary.getCollectionType().getOwnedOperations(), (String)"selectByKind");
        assert (operation6 != null);
        this.collectionSelectByKindId = operation6.getOperationId();
        this.oclVoidClassDatumAnalysis = this.getClassDatumAnalysis(standardLibrary.getOclVoidType(), this.domainAnalysis.getPrimitiveTypeModel());
        Property candidateOclContainerProperty = (Property)NameUtil.getNameable((Iterable)oclElementType.getOwnedProperties(), (String)"oclContainer");
        assert (candidateOclContainerProperty != null) : "OCL Standard Librarty has no OclElement::oclContainer property";
        this.oclContainerProperty = candidateOclContainerProperty;
        this.analyzeDatums((List<? extends AbstractDatum>)dependencyGraph.getDatums());
    }

    private void analyzeDatums(List<? extends AbstractDatum> datums) {
        for (AbstractDatum abstractDatum : datums) {
            if (abstractDatum instanceof ClassDatum) {
                ClassDatum classDatum = (ClassDatum)abstractDatum;
                this.analyzeDatums((List<? extends AbstractDatum>)classDatum.getPropertyDatums());
            } else if (abstractDatum instanceof PropertyDatum) {
                PropertyDatum propertyDatum = (PropertyDatum)abstractDatum;
                this.property2propertyDatum.put(propertyDatum.getProperty(), propertyDatum);
            }
            this.analyzeDatums((List<? extends AbstractDatum>)abstractDatum.getSub());
        }
    }

    protected abstract @NonNull ClassDatumAnalysis createClassDatumAnalysis(@NonNull ClassDatum var1);

    public @NonNull Property getArgumentProperty(@NonNull String argumentName) {
        Property argumentProperty = this.name2argumentProperty.get(argumentName);
        if (argumentProperty == null) {
            argumentProperty = QVTimperativeUtil.createProperty((String)argumentName, (Type)this.getStandardLibrary().getOclAnyType(), (boolean)true);
            this.name2argumentProperty.put(argumentName, argumentProperty);
        }
        return argumentProperty;
    }

    public @NonNull Property getCastProperty(@NonNull Type type) {
        Property castProperty = this.type2castProperty.get(type);
        if (castProperty == null) {
            castProperty = QVTimperativeUtil.createProperty((String)("\u00abcast\u00bb\\n" + type.toString()), (Type)type, (boolean)true);
            this.type2castProperty.put(type, castProperty);
        }
        return castProperty;
    }

    public @NonNull ClassDatum getClassDatum(@NonNull TypedElement asTypedElement) {
        TypedModel typedModel;
        Class asType = (Class)asTypedElement.getType();
        assert (asType != null);
        Type elementType = QVTbaseUtil.getElementalType((Type)asType);
        if (elementType instanceof DataType) {
            typedModel = this.getDomainAnalysis().getPrimitiveTypeModel();
        } else {
            DomainUsage domainUsage = this.getDomainUsage((Element)asTypedElement);
            assert (domainUsage != null);
            typedModel = domainUsage.getTypedModel((Element)asTypedElement);
            assert (typedModel != null);
        }
        return this.qvtp2qvtg.getClassDatum(typedModel, asType);
    }

    public @NonNull ClassDatum getClassDatum(@NonNull Class asType, @NonNull TypedModel typedModel) {
        return this.qvtp2qvtg.getClassDatum(typedModel, asType);
    }

    public @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull ClassDatum classDatum) {
        ClassDatumAnalysis classDatumAnalysis = this.classDatum2classDatumAnalysis.get(classDatum);
        if (classDatumAnalysis == null) {
            classDatumAnalysis = this.createClassDatumAnalysis(classDatum);
            this.classDatum2classDatumAnalysis.put(classDatum, classDatumAnalysis);
        }
        return classDatumAnalysis;
    }

    public @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull TypedElement typedElement) {
        ClassDatum classDatum = this.getClassDatum(typedElement);
        return this.getClassDatumAnalysis(classDatum);
    }

    public @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull Class type, @NonNull TypedModel typedModel) {
        ClassDatum classDatum = this.qvtp2qvtg.getClassDatum(typedModel, type);
        return this.getClassDatumAnalysis(classDatum);
    }

    public @NonNull Iterable<ClassDatumAnalysis> getClassDatumAnalyses() {
        return this.classDatum2classDatumAnalysis.values();
    }

    public @NonNull ClassRelationships getClassRelationships() {
        return this.qvtp2qvtg.getClassRelationships();
    }

    public @NonNull OperationId getCollectionSelectByKindId() {
        return this.collectionSelectByKindId;
    }

    public @NonNull DependencyAnalyzer getDependencyAnalyzer() {
        @Nullable DependencyAnalyzer dependencyAnalyzer2 = this.dependencyAnalyzer;
        if (dependencyAnalyzer2 == null) {
            this.dependencyAnalyzer = dependencyAnalyzer2 = new DependencyAnalyzer(this);
        }
        return dependencyAnalyzer2;
    }

    public @NonNull Schedule getDependencyGraph() {
        return this.dependencyGraph;
    }

    public @NonNull RootDomainUsageAnalysis getDomainAnalysis() {
        return this.domainAnalysis;
    }

    public @NonNull DomainUsage getDomainUsage(@NonNull Element element) {
        RootDomainUsageAnalysis analysis = this.domainAnalysis;
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            analysis = this.domainAnalysis.getAnalysis(operation);
        }
        return (DomainUsage)ClassUtil.nonNullState((Object)analysis.getUsage(element));
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    protected @NonNull URI getGraphsBaseURI() {
        return this.dependencyGraph.eResource().getURI().trimSegments(1).appendSegment("graphs").appendSegment("");
    }

    public @NonNull Property getIterateProperty(@NonNull Type type) {
        Property iterateProperty = this.type2iterateProperty.get(type);
        if (iterateProperty == null) {
            iterateProperty = QVTimperativeUtil.createProperty((String)"\u00abiterate\u00bb", (Type)type, (boolean)true);
            this.type2iterateProperty.put(type, iterateProperty);
        }
        return iterateProperty;
    }

    public @NonNull OperationId getOclAnyEqualsId() {
        return this.oclAnyEqualsId;
    }

    public @NonNull OperationId getOclAnyOclAsSetId() {
        return this.oclAnyOclAsSetId;
    }

    public @NonNull OperationId getOclAnyOclAsTypeId() {
        return this.oclAnyOclAsTypeId;
    }

    public @NonNull OperationId getOclAnyOclIsKindOfId() {
        return this.oclAnyOclIsKindOfId;
    }

    public @NonNull Property getOclContainerProperty() {
        return this.oclContainerProperty;
    }

    public @NonNull OperationId getOclElementOclContainerId() {
        return this.oclElementOclContainerId;
    }

    public @NonNull ClassDatumAnalysis getOclVoidClassDatumAnalysis() {
        return this.oclVoidClassDatumAnalysis;
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    public @NonNull Transformation getTransformation() {
        return this.transformation;
    }

    public @NonNull SymbolNameReservation getSymbolNameReservation() {
        return this.symbolNameReservation;
    }

    public boolean isDirty(@NonNull Property property) {
        return this.domainAnalysis.isDirty(property);
    }

    public boolean isKnown(@NonNull VariableDeclaration sourceVariable) {
        if (sourceVariable.eContainer() == null) {
            return false;
        }
        DomainUsage usage = this.getDomainUsage((Element)sourceVariable);
        assert (usage != null);
        return !usage.isOutput();
    }

    public @NonNull String reserveSymbolName(@NonNull SymbolNameBuilder symbolNameBuilder, @NonNull Symbolable symbolable) {
        return this.symbolNameReservation.reserveSymbolName(symbolNameBuilder, symbolable);
    }

    public void writeCallDOTfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName().replace("\n", "_").replace("\\n", "_c")) + suffix + ".dot")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            DOTStringBuilder s = new DOTStringBuilder();
            region.toCallGraph((GraphStringBuilder)s);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
    }

    public void writeCallGraphMLfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName().replace("\n", "_").replace("\\n", "_c")) + suffix + ".graphml")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            GraphMLStringBuilder s = new GraphMLStringBuilder();
            region.toCallGraph((GraphStringBuilder)s);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
    }

    public void writeDOTfile(@NonNull Region region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName().replace("\n", "_").replace("\\n", "_").replace("::", "_")) + suffix + ".dot")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            DOTStringBuilder s = new DOTStringBuilder();
            region.toGraph((GraphStringBuilder)s);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
    }

    public void writeGraphMLfile(@NonNull Region region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName().replace("\n", "_").replace("\\n", "_").replace("::", "_")) + suffix + ".graphml")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            GraphMLStringBuilder s = new GraphMLStringBuilder();
            region.toGraph((GraphStringBuilder)s);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
    }

    public void writeRegionDOTfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName().replace("\n", "_").replace("\\n", "_")) + suffix + ".dot")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            DOTStringBuilder s = new DOTStringBuilder();
            region.toRegionGraph((GraphStringBuilder)s);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
        for (Region nestedRegion : region.getRegions()) {
            if (!(nestedRegion instanceof ScheduledRegion)) continue;
            this.writeRegionDOTfile((ScheduledRegion)nestedRegion, suffix);
        }
    }

    public void writeRegionGraphMLfile(@NonNull ScheduledRegion region, @NonNull String suffix) {
        URI baseURI = this.getGraphsBaseURI();
        URI dotURI = URI.createURI((String)(String.valueOf(region.getSymbolName().replace("\n", "_").replace("\\n", "_")) + suffix + ".graphml")).resolve(baseURI);
        try {
            OutputStream outputStream = URIConverter.INSTANCE.createOutputStream(dotURI);
            GraphMLStringBuilder s = new GraphMLStringBuilder();
            region.toRegionGraph((GraphStringBuilder)s);
            outputStream.write(s.toString().getBytes());
            outputStream.close();
        }
        catch (IOException e) {
            System.err.println("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage());
        }
        for (Region nestedRegion : region.getRegions()) {
            if (!(nestedRegion instanceof ScheduledRegion)) continue;
            this.writeRegionGraphMLfile((ScheduledRegion)nestedRegion, suffix);
        }
    }
}

