/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractForestBuilder;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;

class NavigationForestBuilder
extends AbstractForestBuilder {
    private final @NonNull Set<@NonNull NavigableEdge> untraversedEdges = new HashSet<NavigableEdge>();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public NavigationForestBuilder(@NonNull Iterable<@NonNull Node> rootNodes, @NonNull Iterable<@NonNull NavigableEdge> navigationEdges) {
        super(rootNodes, navigationEdges);
        @NonNull HashSet predicateEdges = Sets.newHashSet(this.getForwardEdges());
        for (NavigableEdge traversedEdge : this.getTraversedEdges()) {
            predicateEdges.remove(traversedEdge);
            NavigableEdge oppositeEdge = traversedEdge.getOppositeEdge();
            if (oppositeEdge == null) continue;
            predicateEdges.remove(oppositeEdge);
        }
        this.untraversedEdges.addAll(predicateEdges);
    }

    @Override
    protected void addEdge(@NonNull NavigableEdge edge) {
        if (!edge.isRealized() && !edge.isCast()) {
            assert (!edge.isExpression());
            assert (!edge.isComputation());
            Node targetNode = edge.getEdgeTarget();
            targetNode = RegionUtil.getCastTarget((Node)targetNode);
            super.addEdge(edge.getForwardEdge());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull NavigableEdge> getForestNavigations() {
        @NonNull ArrayList forestNavigations = Lists.newArrayList(this.getTraversedEdges());
        Collections.sort(forestNavigations, this);
        return forestNavigations;
    }

    public @NonNull List<@NonNull NavigableEdge> getGraphPredicates() {
        ArrayList<@NonNull NavigableEdge> graphPredicateEdges = new ArrayList<NavigableEdge>();
        for (NavigableEdge untraversedEdge : this.untraversedEdges) {
            graphPredicateEdges.add(untraversedEdge);
        }
        Collections.sort(graphPredicateEdges, NameUtil.NAMEABLE_COMPARATOR);
        return graphPredicateEdges;
    }
}

