/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.action;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.internal.qvt.oml.common.ui.action.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class WindowActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow myWindow;
    private ISelection mySelection;

    public void init(IWorkbenchWindow window) {
        this.myWindow = window;
    }

    public void dispose() {
        this.myWindow = null;
        this.mySelection = null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelection = selection;
    }

    protected abstract void runImpl(IAction var1) throws Exception;

    public void run(IAction action) {
        try {
            this.runImpl(action);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            this.showError(action, e.getMessage(), e);
        }
    }

    public void showError(IAction action, String message, Exception e) {
        String exMessage = e.getMessage();
        if (exMessage == null) {
            exMessage = "";
        }
        if (message == null) {
            message = exMessage;
        }
        Logger.getLogger().log(Logger.SEVERE, message, e);
        Status status = new Status(4, "org.eclipse.m2m.qvt.oml", 4, exMessage, (Throwable)e);
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ActionDelegate_Failed, (String)action.getText(), (IStatus)status);
    }

    protected Object getSelectedElement() {
        if (!(this.mySelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection elements = (IStructuredSelection)this.mySelection;
        if (elements.size() != 1) {
            return null;
        }
        return elements.getFirstElement();
    }

    public ISelection getSelection() {
        return this.mySelection;
    }

    public Shell getShell() {
        return this.myWindow != null ? this.myWindow.getShell() : null;
    }
}

