/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEnvironmentBase;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtTypeResolverImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.env.TypeCheckerImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.HiddenElementAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.MappingsMapKey;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.parser.AbstractOCLAnalyzer;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalEnv
extends QvtEnvironmentBase {
    public static final String THIS = "this";
    public static final String MAIN = "main";
    public static final String TAG_ALIAS = "alias";
    public static final String METAMODEL_COMPLIANCE_KIND_STRICT = "strict";
    private EPackage.Registry myPackageRegistry;
    private final Set<QvtMessage> myWarningSet = new LinkedHashSet<QvtMessage>(2);
    private final Set<QvtMessage> myErrorSet = new LinkedHashSet<QvtMessage>(2);
    private boolean myCheckForDuplicateErrors;
    private QvtCompilerOptions myCompilerOptions;
    private boolean myParentLocal = false;
    private boolean myIsWithinInitMappingSection = false;
    private final Map<String, ModelType> myModelTypeRegistry;
    private final Map<List<String>, EClassifier> fRegisteredClassifiers;
    private final Map<MappingsMapKey, List<MappingOperation>> myMappingsMap = new HashMap<MappingsMapKey, List<MappingOperation>>();
    private final Map<ResolveInExp, MappingsMapKey> myResolveInExps = new HashMap<ResolveInExp, MappingsMapKey>();
    private final LookupPackageableElementDelegate<EClassifier> LOOKUP_CLASSIFIER_DELEGATE = new LookupPackageableElementDelegate<EClassifier>(){

        @Override
        public EClassifier lookupPackageableElement(List<String> names) {
            return QvtOperationalEnv.super.lookupClassifier(names);
        }
    };
    private final LookupPackageableElementDelegate<EPackage> LOOKUP_PACKAGE_DELEGATE = new LookupPackageableElementDelegate<EPackage>(){

        @Override
        public EPackage lookupPackageableElement(List<String> names) {
            return QvtOperationalEnv.super.lookupPackage(names);
        }
    };

    protected QvtOperationalEnv(QvtOperationalEnv parent) {
        super(parent);
        if (parent == null) {
            throw new IllegalArgumentException("Non-null parent QVT environment expected");
        }
        this.myCheckForDuplicateErrors = false;
        this.myModelTypeRegistry = parent.myModelTypeRegistry;
        this.myCompilerOptions = parent.myCompilerOptions;
        this.fRegisteredClassifiers = parent.fRegisteredClassifiers;
    }

    protected QvtOperationalEnv(EPackage.Registry packageRegistry, Resource resource) {
        super(packageRegistry, resource);
        this.myPackageRegistry = packageRegistry;
        this.myModelTypeRegistry = new LinkedHashMap<String, ModelType>(1);
        this.fRegisteredClassifiers = new HashMap<List<String>, EClassifier>();
    }

    protected void setContextOperation(EOperation operation) {
        super.setContextOperation((Object)operation);
        this.defineOperationParameters(operation);
    }

    protected TypeResolver<EClassifier, EOperation, EStructuralFeature> createTypeResolver(Resource resource) {
        return new QvtTypeResolverImpl(this, resource);
    }

    protected TypeChecker<EClassifier, EOperation, EStructuralFeature> createTypeChecker() {
        return new TypeCheckerImpl(this);
    }

    public EPackage.Registry getEPackageRegistry() {
        EPackage.Registry registry;
        if (this.myPackageRegistry != null) {
            return this.myPackageRegistry;
        }
        if (this.getInternalParent() == null) {
            if (this.getFactory() != null) {
                registry = this.getFactory().getEPackageRegistry();
            } else {
                this.myPackageRegistry = registry = QvtOperationalEnv.createDefaultPackageRegistry();
            }
        } else {
            QvtOperationalEnv parentEnv = (QvtOperationalEnv)this.getInternalParent();
            registry = parentEnv.getEPackageRegistry();
        }
        return registry;
    }

    public Map<String, ModelType> getModelTypeRegistry() {
        return this.myModelTypeRegistry;
    }

    public QvtOperationalEnvFactory getFactory() {
        EnvironmentFactory superFactory = super.getFactory();
        if (superFactory instanceof QvtOperationalEnvFactory) {
            return (QvtOperationalEnvFactory)superFactory;
        }
        QvtOperationalEnvFactory qvtFactory = new QvtOperationalEnvFactory(this.getEPackageRegistry());
        this.setFactory((EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)qvtFactory);
        return qvtFactory;
    }

    protected void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        if (!(factory instanceof QvtOperationalEnvFactory)) {
            throw new IllegalArgumentException("QVT EnvFactory required");
        }
        super.setFactory(factory);
    }

    public void setParentLocal() {
        this.myParentLocal = true;
    }

    public void enterInitMappingSection() {
        this.myIsWithinInitMappingSection = true;
    }

    public void exitInitMappingSection() {
        this.myIsWithinInitMappingSection = false;
    }

    public boolean isWithinInitMappingSection() {
        return this.myIsWithinInitMappingSection;
    }

    public Variable<EClassifier, EParameter> lookupLocal(String name) {
        Variable result = super.lookupLocal(name);
        if (result == null && this.myParentLocal) {
            result = this.getInternalParent().lookupLocal(name);
        }
        return result;
    }

    @Override
    public EStructuralFeature lookupPropertyAlias(EClassifier owner, String aliasName) {
        Module module = this.getModuleContextType();
        if (module != null) {
            for (EAnnotation nextTag : module.getOwnedTag()) {
                EObject element;
                String newName = (String)nextTag.getDetails().get((Object)TAG_ALIAS);
                EList references = nextTag.getReferences();
                EObject eObject = element = references.isEmpty() ? null : (EObject)references.get(0);
                if (!aliasName.equals(newName) || !(element instanceof EStructuralFeature) || !TypeUtil.compatibleTypeMatch((Environment)this, (Object)owner, (Object)((EClassifier)this.getUMLReflection().getOwningClassifier((Object)element)))) continue;
                return (EStructuralFeature)element;
            }
        }
        return null;
    }

    public EOperation tryLookupOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        EOperation result = this.doLookupOperation(owner, name, args);
        if (result == null && AbstractOCLAnalyzer.isEscaped((String)name)) {
            result = this.doLookupOperation(owner, AbstractOCLAnalyzer.unescape((String)name), args);
        }
        return result;
    }

    private EOperation doLookupOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        TypeChecker typeChecker;
        if (owner == null) {
            Variable<EClassifier, EParameter> vdcl = this.lookupImplicitSourceForOperation(name, args);
            if (vdcl == null) {
                return null;
            }
            owner = (EClassifier)vdcl.getType();
        }
        if ((typeChecker = this.getTypeChecker()) instanceof TypeCheckerImpl) {
            return ((TypeCheckerImpl)typeChecker).findMostSpecificOperationMatching(owner, name, args);
        }
        return (EOperation)TypeUtil.findOperationMatching((Environment)this, (Object)owner, (String)name, args);
    }

    public List<MappingOperation> lookupMappingOperations(EClassifier owner, String name) {
        if (owner == null && (owner = this.getModuleContextType()) == null) {
            return Collections.emptyList();
        }
        UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml = this.getUMLReflection();
        List operations = TypeUtil.getOperations((Environment)this, (Object)owner);
        ArrayList<MappingOperation> result = new ArrayList<MappingOperation>();
        for (EOperation operation : operations) {
            if (!uml.getName((Object)operation).equals(name) || !QvtOperationalUtil.isMappingOperation(operation)) continue;
            result.add((MappingOperation)operation);
        }
        return result;
    }

    public EOperation tryLookupConstructorOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) throws LookupException {
        List<EOperation> operations = this.lookupConstructorOperations(owner, name, args);
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        TypeChecker typeChecker = this.getTypeChecker();
        if (typeChecker instanceof TypeCheckerImpl) {
            TypeCheckerImpl specificChecker = (TypeCheckerImpl)typeChecker;
            return specificChecker.getMostSpecificOperation(operations, args);
        }
        for (EOperation op : operations) {
            EList params = op.getEParameters();
            boolean isMatched = true;
            int i = 0;
            int n = params.size();
            while (i < n) {
                if (!TypeUtil.exactTypeMatch((Environment)this, (Object)((EClassifier)this.getUMLReflection().getOCLType(args.get(i))), (Object)((EClassifier)this.getUMLReflection().getOCLType(params.get(i))))) {
                    isMatched = false;
                    break;
                }
                ++i;
            }
            if (!isMatched) continue;
            return op;
        }
        for (EOperation op : operations) {
            if (!this.getTypeChecker().matchArgs((Object)owner, (List)op.getEParameters(), args)) continue;
            return op;
        }
        return null;
    }

    private List<EOperation> lookupConstructorOperations(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
        if (owner == null && (owner = this.getModuleContextType()) == null) {
            return Collections.emptyList();
        }
        UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml = this.getUMLReflection();
        TypeChecker typeChecker = this.getTypeChecker();
        List operations = typeChecker.getOperations(owner);
        ArrayList<EOperation> result = new ArrayList<EOperation>(2);
        for (EOperation operation : operations) {
            EClassifier nextOwner;
            if (!uml.getName((Object)operation).equals(name) || !QvtOperationalUtil.isConstructorOperation(operation) || !typeChecker.matchArgs(owner, uml.getParameters((Object)operation), args) || owner != (nextOwner = (EClassifier)uml.getOwningClassifier((Object)operation))) continue;
            result.add(operation);
        }
        return result;
    }

    public void reportError(String message, int startOffset, int endOffset) {
        if (this.myCompilerOptions != null && !this.myCompilerOptions.isReportErrors()) {
            return;
        }
        QvtOperationalEnv parent = this;
        while (parent.getInternalParent() != null) {
            parent = (QvtOperationalEnv)parent.getInternalParent();
        }
        if (parent instanceof QvtOperationalModuleEnv && ((QvtOperationalModuleEnv)parent).getFileParent() != null) {
            parent = ((QvtOperationalModuleEnv)parent).getFileParent();
        }
        boolean foundSameLocation = false;
        int msgLength = endOffset - startOffset + 1;
        if (this.myCheckForDuplicateErrors) {
            for (QvtMessage msg : parent.myErrorSet) {
                if (msg.getOffset() != startOffset || msg.getLength() != msgLength) continue;
                foundSameLocation = true;
                break;
            }
        }
        if (!foundSameLocation) {
            parent.myErrorSet.add(new QvtMessage(message, 2, startOffset, msgLength, QvtOperationalEnv.getLineNum(parent, startOffset)));
        }
    }

    public void reportWarning(String message, int startOffset, int endOffset) {
        if (this.myCompilerOptions != null && !this.myCompilerOptions.isReportErrors()) {
            return;
        }
        QvtOperationalEnv parent = this;
        while (parent.getInternalParent() != null) {
            parent = (QvtOperationalEnv)parent.getInternalParent();
        }
        if (parent instanceof QvtOperationalModuleEnv && ((QvtOperationalModuleEnv)parent).getFileParent() != null) {
            parent = ((QvtOperationalModuleEnv)parent).getFileParent();
        }
        parent.myWarningSet.add(new QvtMessage(message, 1, startOffset, endOffset - startOffset + 1, QvtOperationalEnv.getLineNum(parent, startOffset)));
    }

    public void reportError(String message, CSTNode node) {
        int startOffset = node != null ? node.getStartOffset() : 0;
        int endOffset = node != null ? node.getEndOffset() : 0;
        this.reportError(message, startOffset, endOffset);
    }

    public void reportWarning(String message, CSTNode node) {
        int startOffset = node != null ? node.getStartOffset() : 0;
        int endOffset = node != null ? node.getEndOffset() : 0;
        this.reportWarning(message, startOffset, endOffset);
    }

    public boolean hasErrors() {
        return this.myErrorSet != null && !this.myErrorSet.isEmpty();
    }

    public boolean hasWarnings() {
        return this.myWarningSet != null && !this.myWarningSet.isEmpty();
    }

    public List<QvtMessage> getErrorsList() {
        return new ArrayList<QvtMessage>(this.myErrorSet);
    }

    public List<QvtMessage> getWarningsList() {
        return new ArrayList<QvtMessage>(this.myWarningSet);
    }

    public List<QvtMessage> getAllProblemMessages() {
        if (this.hasErrors() || this.hasWarnings()) {
            ArrayList<QvtMessage> result = new ArrayList<QvtMessage>();
            result.addAll(this.getErrorsList());
            result.addAll(this.getWarningsList());
            return result;
        }
        return Collections.emptyList();
    }

    public void clearProblems() {
        if (this.myErrorSet != null) {
            this.myErrorSet.clear();
        }
        if (this.myWarningSet != null) {
            this.myWarningSet.clear();
        }
    }

    public ModelType registerModelType(ModelType modelType) {
        return this.myModelTypeRegistry.put(modelType.getName(), modelType);
    }

    public ModelType getModelType(String name) {
        return this.myModelTypeRegistry.get(name);
    }

    @Override
    public Variable<EClassifier, EParameter> lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> args) {
        Variable result;
        Variable tentativeResult = result = super.lookupImplicitSourceForOperation(name, args);
        if ((result == null || "self".equals(result.getName())) && this.getInternalParent() != null) {
            result = this.getInternalParent().lookupImplicitSourceForOperation(name, args);
            if (tentativeResult != null && result == null) {
                result = tentativeResult;
            }
        }
        return result;
    }

    @Override
    public Variable<EClassifier, EParameter> lookupImplicitSourceForProperty(String name) {
        Variable implicitSource;
        Variable tentativeResult = implicitSource = super.lookupImplicitSourceForProperty(name);
        if ((implicitSource == null || "self".equals(implicitSource.getName())) && this.getInternalParent() != null) {
            implicitSource = this.getInternalParent().lookupImplicitSourceForProperty(name);
            if (tentativeResult != null && implicitSource == null) {
                implicitSource = tentativeResult;
            }
        }
        return implicitSource;
    }

    public EClassifier lookupClassifier(List<String> names) {
        if (names.isEmpty()) {
            return null;
        }
        if (this.fRegisteredClassifiers.containsKey(names)) {
            return this.fRegisteredClassifiers.get(names);
        }
        EClassifier eClassifier = this.lookupClassifierImpl(names);
        this.fRegisteredClassifiers.put(names, eClassifier);
        return eClassifier;
    }

    private EClassifier lookupClassifierImpl(List<String> names) {
        EClassifier result;
        String firstName = names.get(0);
        if (names.size() == 1) {
            Module importedModule;
            Module moduleContextType = this.getModuleContextType();
            if (moduleContextType != null && firstName.equals(moduleContextType.getName())) {
                return moduleContextType;
            }
            for (QvtEnvironmentBase nextImported : this.getRootEnv().getImportsByExtends()) {
                importedModule = nextImported.getModuleContextType();
                if (importedModule == null || !firstName.equals(importedModule.getName())) continue;
                return importedModule;
            }
            for (QvtEnvironmentBase nextImported : this.getRootEnv().getImportsByAccess()) {
                importedModule = nextImported.getModuleContextType();
                if (importedModule == null || !firstName.equals(importedModule.getName())) continue;
                return importedModule;
            }
            if (this.myModelTypeRegistry.containsKey(firstName)) {
                return (EClassifier)this.myModelTypeRegistry.get(firstName);
            }
            for (ModelType modelType : this.myModelTypeRegistry.values()) {
                EClassifier lookupClassifier = this.doLookupModeltypeClassifier(modelType, names);
                if (lookupClassifier == null) continue;
                return lookupClassifier;
            }
        }
        if (names.size() > 1) {
            EClassifier lookupClassifier;
            EClassifier stdType;
            if (names.size() == 2 && (stdType = QvtOperationalStdLibrary.INSTANCE.lookupClassifier(names)) != null) {
                return stdType;
            }
            if (this.myModelTypeRegistry.containsKey(firstName) && (lookupClassifier = this.doLookupModeltypeClassifier(this.myModelTypeRegistry.get(firstName), names.subList(1, names.size()))) != null) {
                return lookupClassifier;
            }
        }
        return (result = super.lookupClassifier(names)) != null ? result : QvtOperationalStdLibrary.INSTANCE.lookupClassifier(names);
    }

    public EPackage lookupPackage(List<String> path) {
        Library stdPackage;
        if (path.size() > 1) {
            EPackage lookupPackage;
            if (this.myModelTypeRegistry.containsKey(path.get(0)) && (lookupPackage = this.doLookupModeltypePackage(this.myModelTypeRegistry.get(path.get(0)), path.subList(1, path.size()))) != null) {
                return lookupPackage;
            }
        } else if (path.size() == 1 && (stdPackage = QvtOperationalStdLibrary.INSTANCE.getStdLibModule()).getName().equals(path.get(0))) {
            return stdPackage;
        }
        return super.lookupPackage(path);
    }

    private EPackage doLookupModeltypePackage(ModelType modelType, List<String> path) {
        return this.lookupPackageableElement(modelType, path, this.LOOKUP_PACKAGE_DELEGATE);
    }

    private EClassifier doLookupModeltypeClassifier(ModelType modelType, List<String> path) {
        return this.lookupPackageableElement(modelType, path, this.LOOKUP_CLASSIFIER_DELEGATE);
    }

    private <T extends EObject> T lookupPackageableElement(ModelType modelType, List<String> path, LookupPackageableElementDelegate<T> lookupPackageableElementDelegate) {
        EPackage oldContext = (EPackage)super.getContextPackage();
        EObject result = null;
        EList<EPackage> metamodels = modelType.getMetamodel();
        for (EPackage pkg : metamodels) {
            super.setContextPackage((Object)pkg);
            EObject eContainer = result = (EObject)lookupPackageableElementDelegate.lookupPackageableElement(path);
            int i = 0;
            int n = path.size();
            while (i < n) {
                if (eContainer == null) break;
                eContainer = eContainer.eContainer();
                ++i;
            }
            if (eContainer != pkg) {
                result = null;
            }
            if (result != null) break;
        }
        super.setContextPackage((Object)oldContext);
        return (T)result;
    }

    public EOperation defineOperation(EClassifier owner, String name, EClassifier type, List<Variable<EClassifier, EParameter>> params, Constraint constraint) {
        EOperation result = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEOperation();
        result.setName(name);
        result.setEType(type == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : type);
        for (Variable<EClassifier, EParameter> next : params) {
            EParameter param = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEParameter();
            param.setName(next.getName());
            param.setEType(next.getType() == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : (EClassifier)next.getType());
            result.getEParameters().add((Object)param);
        }
        if (owner == this.getModuleContextType()) {
            this.getModuleContextType().getEOperations().add((Object)result);
        } else {
            this.addHelperOperation(owner, result);
        }
        return result;
    }

    public ImperativeOperation defineImperativeOperation(ImperativeOperation operation, boolean isMappingOperation, boolean isCheckDuplicates) {
        Object ownerType = QvtOperationalParserUtil.getContextualType(operation);
        boolean isContextual = true;
        if (ownerType == null) {
            isContextual = false;
            ownerType = this.getModuleContextType();
        }
        boolean isError = false;
        ImperativeOperation newOperation = operation;
        QvtEnvironmentBase.CollisionStatus collidingOperStatus = this.findCollidingOperation((EClassifier)ownerType, newOperation);
        if (collidingOperStatus != null) {
            EOperation collidingOper = collidingOperStatus.getOperation();
            if (collidingOperStatus.getCollisionKind() == QvtEnvironmentBase.CollisionStatus.CollisionKind.ALREADY_DEFINED) {
                isError = true;
                HiddenElementAdapter.markAsHidden((EObject)operation);
                this.reportError(NLS.bind(ValidationMessages.SemanticUtil_0, new Object[]{operation.getName(), ownerType.getName()}), operation.getStartPosition(), operation.getEndPosition());
            } else if (collidingOperStatus.getCollisionKind() == QvtEnvironmentBase.CollisionStatus.CollisionKind.OVERRIDES) {
                Module owningModule;
                if (collidingOper instanceof ImperativeOperation) {
                    EClassifier overriddenReturnType = collidingOper.getEType();
                    EClassifier newReturnType = newOperation.getEType();
                    if (newReturnType != null && overriddenReturnType != null) {
                        if (TypeUtil.compatibleTypeMatch((Environment)this, (Object)newReturnType, (Object)overriddenReturnType)) {
                            newOperation.setOverridden((ImperativeOperation)collidingOper);
                        } else {
                            isError = true;
                            this.reportError(NLS.bind(ValidationMessages.OperationOverrideWithInvalidReturnType, new Object[]{this.getUMLReflection().getName((Object)operation), this.getUMLReflection().getName((Object)collidingOper.getEContainingClass())}), operation.getStartPosition(), operation.getEndPosition());
                        }
                    }
                }
                if (!(isError || (owningModule = QvtOperationalParserUtil.getOwningModule(collidingOper)) != null && owningModule != this.getQVTStandardLibrary().getStdLibModule())) {
                    this.reportWarning(NLS.bind(ValidationMessages.HidingStdlibOperationDiscouraged, operation.getName()), operation.getStartPosition(), operation.getEndPosition());
                }
            } else if (collidingOperStatus.getCollisionKind() == QvtEnvironmentBase.CollisionStatus.CollisionKind.VIRTUAL_METHOD_SUBTYPE) {
                isError = true;
                HiddenElementAdapter.markAsHidden((EObject)operation);
                this.reportError(NLS.bind(ValidationMessages.ReturnSubtypeMismatch, operation.getName(), QvtOperationalTypesUtil.getTypeFullName(collidingOperStatus.getOperation().getEType())), operation.getStartPosition(), operation.getEndPosition());
            } else if (collidingOperStatus.getCollisionKind() == QvtEnvironmentBase.CollisionStatus.CollisionKind.VIRTUAL_METHOD_SUPERTYPE) {
                isError = true;
                HiddenElementAdapter.markAsHidden((EObject)operation);
                this.reportError(NLS.bind(ValidationMessages.ReturnSupertypeMismatch, operation.getName(), QvtOperationalTypesUtil.getTypeFullName(collidingOperStatus.getOperation().getEType())), operation.getStartPosition(), operation.getEndPosition());
            } else assert (false);
        }
        if (isContextual && !isError) {
            this.getTypeResolver().resolveAdditionalOperation(ownerType, newOperation);
        }
        this.getModuleContextType().getEOperations().add((Object)newOperation);
        return newOperation;
    }

    @Override
    public Module getModuleContextType() {
        return this.getInternalParent() instanceof QvtOperationalEnv ? ((QvtOperationalEnv)this.getInternalParent()).getModuleContextType() : null;
    }

    private void defineParameterVar(EParameter parameter) {
        VarParameter var;
        if (parameter instanceof VarParameter) {
            var = (VarParameter)parameter;
        } else {
            var = EcoreFactory.eINSTANCE.createVariable();
            var.setName(parameter.getName());
            var.setType(parameter.getEType());
            var.setRepresentedParameter(parameter);
        }
        this.addElement(parameter.getName(), (Variable)var, true);
    }

    private void defineOperationParameters(EOperation operation) {
        boolean hasMultipleResultParams;
        ImperativeOperation imperativeOperation = operation instanceof ImperativeOperation ? (ImperativeOperation)operation : null;
        boolean isMapping = operation instanceof MappingOperation;
        boolean bl = imperativeOperation != null ? imperativeOperation.getResult().size() > 1 : (hasMultipleResultParams = false);
        if (imperativeOperation != null && QvtOperationalParserUtil.isContextual(imperativeOperation)) {
            VarParameter context = imperativeOperation.getContext();
            assert (context != null);
            this.addElement(context.getName(), (Variable)context, false);
        }
        for (EParameter parameter : operation.getEParameters()) {
            this.defineParameterVar(parameter);
        }
        if (isMapping || hasMultipleResultParams) {
            assert (imperativeOperation != null);
            for (EParameter parameter : imperativeOperation.getResult()) {
                this.defineParameterVar(parameter);
            }
        }
    }

    public void setQvtCompilerOptions(QvtCompilerOptions options) {
        this.myCompilerOptions = options;
    }

    public void setCheckForDuplicateErrors(boolean checkForDuplicateErrors) {
        this.myCheckForDuplicateErrors = checkForDuplicateErrors;
    }

    public void registerMappingOperation(MappingOperation operation) {
        if (this.getInternalParent() != null) {
            ((QvtOperationalEnv)this.getInternalParent()).registerMappingOperation(operation);
        } else {
            EClassifier ownerType = QvtOperationalParserUtil.getContextualType(operation);
            if (ownerType == null && (ownerType = (EClassifier)this.getUMLReflection().getOwningClassifier((Object)operation)) == null) {
                return;
            }
            MappingsMapKey key = new MappingsMapKey(ownerType, operation.getName());
            List<MappingOperation> sameNameAndContextOperations = this.myMappingsMap.get(key);
            if (sameNameAndContextOperations == null) {
                sameNameAndContextOperations = new ArrayList<MappingOperation>();
                this.myMappingsMap.put(key, sameNameAndContextOperations);
            }
            sameNameAndContextOperations.add(operation);
        }
    }

    public void registerResolveInExp(ResolveInExp resolveInExp, EClassifier referredMappingContextType, String mappingName) {
        if (this.getInternalParent() != null) {
            ((QvtOperationalEnv)this.getInternalParent()).registerResolveInExp(resolveInExp, referredMappingContextType, mappingName);
        } else {
            this.myResolveInExps.put(resolveInExp, new MappingsMapKey(referredMappingContextType, mappingName));
        }
    }

    public void resolveResolveInExpInMappings() {
        if (this.getInternalParent() == null) {
            for (Map.Entry<ResolveInExp, MappingsMapKey> entry : this.myResolveInExps.entrySet()) {
                MappingsMapKey mappingsMapKey = entry.getValue();
                List<MappingOperation> sameNameAndContextOperations = this.myMappingsMap.get(mappingsMapKey);
                ResolveInExp resolveInExp = entry.getKey();
                if (sameNameAndContextOperations != null) {
                    for (MappingOperation mappingOperation : sameNameAndContextOperations) {
                        if (resolveInExp.getInMapping() != null) continue;
                        resolveInExp.setInMapping(mappingOperation);
                    }
                }
                assert (resolveInExp.getInMapping() != null);
            }
        } else {
            ((QvtOperationalEnv)this.getInternalParent()).resolveResolveInExpInMappings();
        }
    }

    protected ProblemHandler createDefaultProblemHandler(AbstractParser parser) {
        return new AbstractProblemHandler(parser){

            public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
                boolean allowCsUnboundValidationProblems = false;
                if (QvtOperationalEnv.isMDTOCLCompatibilityFalseProblem(allowCsUnboundValidationProblems, problemSeverity, processingPhase, problemMessage, processingContext, startOffset, endOffset)) {
                    return;
                }
                if (problemSeverity == ProblemHandler.Severity.INFO || problemSeverity == ProblemHandler.Severity.OK || problemSeverity == ProblemHandler.Severity.WARNING) {
                    QvtOperationalEnv.this.reportWarning(problemMessage, startOffset, endOffset);
                } else {
                    QvtOperationalEnv.this.reportError(problemMessage, startOffset, endOffset);
                }
            }
        };
    }

    public void analyzerError(String problemMessage, String problemContext, Object problemObject) {
        int endOffset;
        CSTNode cstNode = this.getASTMapping(problemObject);
        int startOffset = cstNode != null ? cstNode.getStartOffset() : -1;
        int n = endOffset = cstNode != null ? cstNode.getEndOffset() : -1;
        if (cstNode == null && problemObject instanceof ASTNode) {
            ASTNode astNode = (ASTNode)problemObject;
            startOffset = astNode.getStartPosition();
            endOffset = astNode.getEndPosition();
        }
        this.analyzerError(problemMessage, problemContext, startOffset, endOffset);
    }

    public void initASTMapping(Object astNode, CSTNode cstNode) {
        ASTNode castNode;
        if (astNode instanceof ASTNode && (castNode = (ASTNode)astNode).getEndPosition() < 0) {
            castNode.setStartPosition(cstNode.getStartOffset());
            castNode.setEndPosition(cstNode.getEndOffset());
        }
        super.initASTMapping(astNode, cstNode);
    }

    @Override
    public void close() {
        this.setParser(null);
        this.setProblemHandler(null);
        this.setASTNodeToCSTNodeMap(null);
        super.close();
    }

    private static int getLineNum(QvtOperationalEnv env, int startOffset) {
        AbstractLexer lexer;
        if (startOffset < 0) {
            return -1;
        }
        AbstractParser parser = env.getParser();
        if (parser != null && (lexer = parser.getLexer()) != null && startOffset <= lexer.getILexStream().getStreamLength()) {
            try {
                return lexer.getILexStream().getLineNumberOfCharAt(startOffset);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static EPackage.Registry createDefaultPackageRegistry() {
        return new EPackageRegistryImpl();
    }

    public static boolean isMDTOCLCompatibilityFalseProblem(boolean allowCsUnboundValidationProblems, ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        if (ProblemHandler.Phase.VALIDATOR == processingPhase && startOffset == -1 && endOffset == -1 && !allowCsUnboundValidationProblems) {
            return true;
        }
        return "collectionTypeResultTypeOf".equals(processingContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LookupPackageableElementDelegate<T> {
        public T lookupPackageableElement(List<String> var1);
    }
}

