/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeModelUtils {
    /*
     * Unable to fully structure code
     */
    @Nullable
    public static ILeafNode findLeafNodeAtOffset(@NonNull INode node, int leafNodeOffset) {
        block7: {
            localNode = node;
            while (!(localNode instanceof AbstractNode)) {
                localNode = localNode.getParent();
            }
            offset = localNode.getTotalOffset();
            length = localNode.getTotalLength();
            iterator = ((AbstractNode)localNode).basicIterator();
            if (leafNodeOffset <= (offset + length) / 2) ** GOTO lbl29
            while (iterator.hasPrevious()) {
                previous = iterator.previous();
                previousOffset = previous.getTotalOffset();
                if (!NodeModelUtils.intersects(previousOffset, previousLength = previous.getTotalLength(), leafNodeOffset)) {
                    if (previousOffset + previousLength <= leafNodeOffset) {
                        return null;
                    }
                    iterator.prune();
                    continue;
                }
                if (!(previous instanceof ILeafNode)) continue;
                return (ILeafNode)previous;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                next = iterator.next();
                nextOffset = next.getTotalOffset();
                if (!NodeModelUtils.intersects(nextOffset, nextLength = next.getTotalLength(), leafNodeOffset)) {
                    if (nextOffset > leafNodeOffset) {
                        return null;
                    }
                    iterator.prune();
                    continue;
                }
                if (!(next instanceof ILeafNode)) continue;
                return (ILeafNode)next;
lbl29:
                // 3 sources

                ** while (iterator.hasNext())
            }
        }
        return null;
    }

    private static boolean intersects(int offset, int length, int lookupOffset) {
        return offset <= lookupOffset && offset + length > lookupOffset;
    }

    @Nullable
    public static ICompositeNode getNode(@Nullable EObject object) {
        if (object == null) {
            return null;
        }
        EList adapters = object.eAdapters();
        int i = 0;
        while (i < adapters.size()) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (adapter instanceof ICompositeNode) {
                return (ICompositeNode)adapter;
            }
            ++i;
        }
        return null;
    }

    @NonNull
    public static List<INode> findNodesForFeature(EObject semanticObject, EStructuralFeature structuralFeature) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor(semanticObject);
        if (node != null) {
            return NodeModelUtils.findNodesForFeature(semanticObject, node, structuralFeature);
        }
        return Collections.emptyList();
    }

    private static List<INode> findNodesForFeature(EObject semanticElement, INode node, EStructuralFeature structuralFeature) {
        ArrayList result = Lists.newArrayList();
        String featureName = structuralFeature.getName();
        BidiTreeIterator<INode> iterator = node.getAsTreeIterable().iterator();
        while (iterator.hasNext()) {
            Assignment assignment;
            INode child = iterator.next();
            EObject grammarElement = child.getGrammarElement();
            if (grammarElement == null) continue;
            if (grammarElement instanceof Action) {
                Action action = (Action)grammarElement;
                if (child.getSemanticElement() == semanticElement) {
                    child = iterator.next();
                    if (featureName.equals(action.getFeature())) {
                        result.add(child);
                    }
                } else {
                    INode firstChild = ((ICompositeNode)child).getFirstChild();
                    while (firstChild.getGrammarElement() instanceof Action) {
                        firstChild = ((ICompositeNode)firstChild).getFirstChild();
                    }
                    EObject firstChildGrammarElement = firstChild.getGrammarElement();
                    Assignment assignment2 = GrammarUtil.containingAssignment(firstChildGrammarElement);
                    if (assignment2 != null && featureName.equals(assignment2.getFeature())) {
                        result.add(child);
                    }
                }
                iterator.prune();
                continue;
            }
            if (child == node || (assignment = GrammarUtil.containingAssignment(grammarElement)) == null) continue;
            if (featureName.equals(assignment.getFeature())) {
                result.add(child);
            }
            iterator.prune();
        }
        return result;
    }

    @Nullable
    public static ICompositeNode findActualNodeFor(@Nullable EObject semanticObject) {
        ICompositeNode node = NodeModelUtils.getNode(semanticObject);
        if (node != null) {
            while (GrammarUtil.containingAssignment(node.getGrammarElement()) == null && node.getParent() != null && !node.getParent().hasDirectSemanticElement()) {
                node = node.getParent();
            }
        }
        return node;
    }

    @Nullable
    public static EObject findActualSemanticObjectFor(@Nullable INode node) {
        if (node == null) {
            return null;
        }
        if (node.hasDirectSemanticElement()) {
            return node.getSemanticElement();
        }
        EObject grammarElement = node.getGrammarElement();
        ICompositeNode parent = node.getParent();
        if (grammarElement == null) {
            return NodeModelUtils.findActualSemanticObjectFor(parent);
        }
        Assignment assignment = GrammarUtil.containingAssignment(grammarElement);
        if (assignment != null) {
            if (parent.hasDirectSemanticElement()) {
                return NodeModelUtils.findActualSemanticObjectFor(parent);
            }
            INode sibling = parent.getFirstChild();
            while (sibling != node) {
                EObject siblingGrammarElement = sibling.getGrammarElement();
                if (siblingGrammarElement != null && GrammarUtil.containingAssignment(siblingGrammarElement) == null && GrammarUtil.isEObjectRuleCall(siblingGrammarElement)) {
                    return NodeModelUtils.findActualSemanticObjectFor(sibling);
                }
                sibling = sibling.getNextSibling();
            }
        } else {
            EObject result = NodeModelUtils.findActualSemanticObjectInChildren(node, grammarElement);
            if (result != null) {
                return result;
            }
        }
        return NodeModelUtils.findActualSemanticObjectFor(parent);
    }

    @Nullable
    private static EObject findActualSemanticObjectInChildren(@NonNull INode node, @Nullable EObject grammarElement) {
        if (node.hasDirectSemanticElement()) {
            return node.getSemanticElement();
        }
        AbstractRule rule = null;
        if (grammarElement instanceof RuleCall) {
            rule = ((RuleCall)grammarElement).getRule();
        } else if (grammarElement instanceof AbstractRule) {
            rule = (AbstractRule)grammarElement;
        }
        if (rule instanceof ParserRule && !GrammarUtil.isDatatypeRule(rule) && node instanceof ICompositeNode) {
            for (INode child : ((ICompositeNode)node).getChildren()) {
                EObject result;
                RuleCall childRuleCall;
                if (!(child instanceof ICompositeNode)) continue;
                EObject childGrammarElement = child.getGrammarElement();
                if (childGrammarElement instanceof Action) {
                    EObject result2 = NodeModelUtils.findActualSemanticObjectInChildren(child, childGrammarElement);
                    if (result2 == null) continue;
                    return result2;
                }
                if (!(childGrammarElement instanceof RuleCall) || !((childRuleCall = (RuleCall)childGrammarElement).getRule() instanceof ParserRule) || GrammarUtil.isDatatypeRule(childRuleCall.getRule()) || (result = NodeModelUtils.findActualSemanticObjectInChildren(child, childRuleCall)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static String compactDump(INode node, boolean showHidden) {
        StringBuilder result = new StringBuilder();
        try {
            NodeModelUtils.compactDump(node, showHidden, "", result);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return result.toString();
    }

    private static void compactDump(INode node, boolean showHidden, String prefix, Appendable result) throws IOException {
        if (!showHidden && node instanceof ILeafNode && ((ILeafNode)node).isHidden()) {
            return;
        }
        if (prefix.length() != 0) {
            result.append("\n");
            result.append(prefix);
        }
        if (node instanceof ICompositeNode) {
            if (node.getGrammarElement() != null) {
                result.append(new GrammarElementTitleSwitch().showAssignments().doSwitch(node.getGrammarElement()));
            } else {
                result.append("(unknown)");
            }
            String newPrefix = String.valueOf(prefix) + "  ";
            result.append(" {");
            for (INode child : ((ICompositeNode)node).getChildren()) {
                NodeModelUtils.compactDump(child, showHidden, newPrefix, result);
            }
            result.append("\n");
            result.append(prefix);
            result.append("}");
            SyntaxErrorMessage error = node.getSyntaxErrorMessage();
            if (error != null) {
                result.append(" SyntaxError: [" + error.getIssueCode() + "] " + error.getMessage());
            }
        } else if (node instanceof ILeafNode) {
            if (((ILeafNode)node).isHidden()) {
                result.append("hidden ");
            }
            if (node.getGrammarElement() != null) {
                result.append(new GrammarElementTitleSwitch().showAssignments().doSwitch(node.getGrammarElement()));
            } else {
                result.append("(unknown)");
            }
            result.append(" => '");
            result.append(node.getText());
            result.append("'");
            SyntaxErrorMessage error = node.getSyntaxErrorMessage();
            if (error != null) {
                result.append(" SyntaxError: [" + error.getIssueCode() + "] " + error.getMessage());
            }
        } else if (node == null) {
            result.append("(null)");
        } else {
            result.append("unknown type ");
            result.append(node.getClass().getName());
        }
    }

    public static String getTokenText(INode node) {
        if (node instanceof ILeafNode) {
            return ((ILeafNode)node).getText();
        }
        StringBuilder builder = new StringBuilder(Math.max(node.getTotalLength(), 1));
        boolean hiddenSeen = false;
        for (ILeafNode leaf : node.getLeafNodes()) {
            if (!leaf.isHidden()) {
                if (hiddenSeen && builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(leaf.getText());
                hiddenSeen = false;
                continue;
            }
            hiddenSeen = true;
        }
        return builder.toString();
    }
}

