/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring.participant;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class FilteringCompositeChange
extends CompositeChange {
    private static final Logger LOG = Logger.getLogger(FilteringCompositeChange.class);

    public FilteringCompositeChange(String name) {
        super(name);
    }

    protected Change createUndoChange(Change[] childUndos) {
        ArrayList filteredUndos = Lists.newArrayList();
        Change[] changeArray = childUndos;
        int n = childUndos.length;
        int n2 = 0;
        while (n2 < n) {
            Change childUndo = changeArray[n2];
            try {
                if (!(childUndo.getModifiedElement() instanceof ICompilationUnit) || !((ICompilationUnit)childUndo.getModifiedElement()).getUnderlyingResource().isDerived()) {
                    filteredUndos.add(childUndo);
                }
            }
            catch (JavaModelException e) {
                LOG.error((Object)"Error filtering refactoring undo changes", (Throwable)e);
            }
            ++n2;
        }
        return super.createUndoChange((Change[])Iterables.toArray((Iterable)filteredUndos, Change.class));
    }
}

