/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring.participant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.common.types.ui.refactoring.participant.FilteringCompositeChange;
import org.eclipse.xtext.ui.refactoring.impl.DisplayChangeWrapper;
import org.eclipse.xtext.ui.refactoring.impl.EditorDocumentChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextChangeCombiner {
    private static final Logger LOG = Logger.getLogger(TextChangeCombiner.class);

    public Change combineChanges(Change masterChange) {
        if (!(masterChange instanceof CompositeChange)) {
            return masterChange;
        }
        LinkedHashMap resource2textChange = Maps.newLinkedHashMap();
        ArrayList otherChanges = Lists.newArrayList();
        HashSet editorsToSave = Sets.newHashSet();
        this.visitCompositeChange((CompositeChange)masterChange, resource2textChange, otherChanges, editorsToSave);
        FilteringCompositeChange compositeChange = new FilteringCompositeChange(masterChange.getName());
        for (TextChange combinedTextChange : resource2textChange.values()) {
            if (((MultiTextEdit)combinedTextChange.getEdit()).getChildrenSize() <= 0) continue;
            if (combinedTextChange instanceof EditorDocumentChange) {
                ((EditorDocumentChange)combinedTextChange).setDoSave(editorsToSave.contains(((EditorDocumentChange)combinedTextChange).getEditor()));
                compositeChange.add((Change)combinedTextChange);
                continue;
            }
            compositeChange.add(DisplayChangeWrapper.wrap((Change)combinedTextChange));
        }
        for (Change otherChange : otherChanges) {
            compositeChange.add(DisplayChangeWrapper.wrap((Change)otherChange));
        }
        if (compositeChange.getChildren().length == 0) {
            return null;
        }
        return compositeChange;
    }

    protected void visitCompositeChange(CompositeChange sourceChange, Map<Object, TextChange> resource2textChange, List<Change> otherChanges, Set<IEditorPart> editorsToSave) {
        Change[] changeArray = sourceChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change sourceSubChange = changeArray[n2];
            this.visitChange(sourceSubChange, resource2textChange, otherChanges, editorsToSave);
            ++n2;
        }
    }

    protected void visitChange(Change sourceChange, Map<Object, TextChange> resource2textChange, List<Change> otherChanges, Set<IEditorPart> editorsToSave) {
        if (sourceChange instanceof DisplayChangeWrapper.Wrapper) {
            this.visitChange(((DisplayChangeWrapper.Wrapper)sourceChange).getDelegate(), resource2textChange, otherChanges, editorsToSave);
        } else if (sourceChange instanceof CompositeChange) {
            this.visitCompositeChange((CompositeChange)sourceChange, resource2textChange, otherChanges, editorsToSave);
        } else if (sourceChange instanceof TextChange) {
            Object key;
            if (sourceChange instanceof EditorDocumentChange) {
                editorsToSave.add((IEditorPart)((EditorDocumentChange)sourceChange).getEditor());
            }
            if ((key = this.getKey((TextChange)sourceChange)) != null) {
                TextChange textChange = resource2textChange.get(key);
                if (textChange == null) {
                    textChange = this.createTextChange(key, ((TextChange)sourceChange).getTextType());
                    resource2textChange.put(key, textChange);
                }
                MultiTextEdit combinedEdits = (MultiTextEdit)textChange.getEdit();
                TextEdit newEdit = ((TextChange)sourceChange).getEdit().copy();
                if (newEdit instanceof MultiTextEdit) {
                    TextEdit[] textEditArray = ((MultiTextEdit)newEdit).getChildren();
                    int n = textEditArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TextEdit newTextEdit = textEditArray[n2];
                        this.addIfNotDuplicate(combinedEdits, newTextEdit);
                        ++n2;
                    }
                } else {
                    this.addIfNotDuplicate(combinedEdits, newEdit);
                }
            }
        } else {
            CompositeChange parent = (CompositeChange)sourceChange.getParent();
            if (parent != null) {
                parent.remove(sourceChange);
            }
            otherChanges.add(sourceChange);
        }
    }

    protected void addIfNotDuplicate(MultiTextEdit multiTextEdit, final TextEdit editToBeAdded) {
        final boolean[] overlaps = new boolean[1];
        TextEditVisitor textEditVisitor = new TextEditVisitor(){

            public boolean visitNode(TextEdit edit) {
                overlaps[0] = overlaps[0] | (!(edit instanceof MultiTextEdit) && edit.covers(editToBeAdded));
                return super.visitNode(edit);
            }
        };
        multiTextEdit.accept(textEditVisitor);
        if (!overlaps[0]) {
            multiTextEdit.addChild(editToBeAdded.copy());
        }
    }

    protected Object getKey(TextChange change) {
        if (change instanceof CompilationUnitChange) {
            return ((CompilationUnitChange)change).getCompilationUnit();
        }
        if (change instanceof TextFileChange) {
            return ((TextFileChange)change).getFile();
        }
        if (change instanceof EditorDocumentChange) {
            return ((EditorDocumentChange)change).getEditor();
        }
        LOG.error((Object)("Unhandled TextChange type: " + change.getClass().getName()));
        return null;
    }

    protected TextChange createTextChange(Object key, String textType) {
        CompilationUnitChange change = null;
        if (key instanceof ICompilationUnit) {
            change = new CompilationUnitChange("Combined CompilationUnitChange", (ICompilationUnit)key);
        } else if (key instanceof IFile) {
            change = new TextFileChange("Combined TextFileChange", (IFile)key);
        } else if (key instanceof ITextEditor) {
            change = new EditorDocumentChange("Combined DocumentChange", (ITextEditor)key, false);
        } else {
            LOG.error((Object)("Error creating change for " + key.getClass().getName()));
        }
        if (change != null) {
            MultiTextEdit edits = new MultiTextEdit();
            change.setEdit((TextEdit)edits);
            change.setTextType(textType);
        }
        return change;
    }
}

