/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.impl.DeclaredTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingDeclaredTypeFactory
extends DeclaredTypeFactory {
    private static final Logger log = Logger.getLogger(CachingDeclaredTypeFactory.class);
    private final DeclaredTypeFactory delegate;
    private final Map<Class<?>, JvmDeclaredType> typeCache = new MapMaker().softValues().weakKeys().makeComputingMap(new Function<Class<?>, JvmDeclaredType>(){

        public JvmDeclaredType apply(Class<?> key) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Hit:" + key.getCanonicalName()));
            }
            return CachingDeclaredTypeFactory.this.delegate.createType(key);
        }
    });

    public CachingDeclaredTypeFactory(DeclaredTypeFactory delegate) {
        super(delegate.getUriHelper());
        this.delegate = delegate;
    }

    @Override
    public JvmDeclaredType createType(Class<?> clazz) {
        try {
            JvmDeclaredType cachedResult = this.typeCache.get(clazz);
            return (JvmDeclaredType)EcoreUtil2.cloneWithProxies((EObject)cachedResult);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return this.delegate.createType(clazz);
        }
    }
}

