/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler.batch;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceSetBasedResourceDescriptions;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.JvmModelGenerator;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.file.RuntimeWorkspaceConfigProvider;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendBatchCompiler {
    private static final Logger log = Logger.getLogger((String)XtendBatchCompiler.class.getName());
    protected static final FileFilter ACCEPT_ALL_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };
    protected Provider<ResourceSet> resourceSetProvider;
    @Inject
    protected Provider<JavaIoFileSystemAccess> javaIoFileSystemAccessProvider;
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected Provider<ResourceSetBasedResourceDescriptions> resourceSetDescriptionsProvider;
    @Inject
    private JvmModelGenerator generator;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    @Inject
    private IGeneratorConfigProvider generatorConfigprovider;
    @Inject
    private ProcessorInstanceForJvmTypeProvider annotationProcessorFactory;
    @Inject
    private IEncodingProvider.Runtime encodingProvider;
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private RuntimeWorkspaceConfigProvider workspaceConfigProvider;
    @Inject
    private CompilerPhases compilerPhases;
    protected Writer outputWriter;
    protected Writer errorWriter;
    protected String sourcePath;
    protected String classPath;
    protected boolean useCurrentClassLoaderAsParent;
    protected String outputPath;
    protected String fileEncoding;
    protected String complianceLevel = "1.5";
    protected boolean verbose = false;
    protected String tempDirectory = System.getProperty("java.io.tmpdir");
    protected boolean deleteTempDirectory = true;
    protected List<File> tempFolders = Lists.newArrayList();
    protected boolean writeTraceFiles = true;

    public void setUseCurrentClassLoaderAsParent(boolean useCurrentClassLoaderAsParent) {
        this.useCurrentClassLoaderAsParent = useCurrentClassLoaderAsParent;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public boolean isWriteTraceFiles() {
        return this.writeTraceFiles;
    }

    public void setWriteTraceFiles(boolean writeTraceFiles) {
        this.writeTraceFiles = writeTraceFiles;
    }

    @Inject
    public void setResourceSetProvider(Provider<ResourceSet> resourceSetProvider) {
        this.resourceSetProvider = resourceSetProvider;
    }

    public boolean isDeleteTempDirectory() {
        return this.deleteTempDirectory;
    }

    public void setDeleteTempDirectory(boolean deletetempDirectory) {
        this.deleteTempDirectory = deletetempDirectory;
    }

    public Writer getOutputWriter() {
        if (this.outputWriter == null) {
            this.outputWriter = new Writer(){

                public void write(char[] data, int offset, int count) throws IOException {
                    String message = String.copyValueOf(data, offset, count);
                    if (!Strings.isEmpty((String)message.trim())) {
                        log.debug((Object)message);
                    }
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            };
        }
        return this.outputWriter;
    }

    public void setOutputWriter(Writer ouputWriter) {
        this.outputWriter = ouputWriter;
    }

    public Writer getErrorWriter() {
        if (this.errorWriter == null) {
            this.errorWriter = new Writer(){

                public void write(char[] data, int offset, int count) throws IOException {
                    String message = String.copyValueOf(data, offset, count);
                    if (!Strings.isEmpty((String)message.trim())) {
                        log.debug((Object)message);
                    }
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            };
        }
        return this.errorWriter;
    }

    public void setErrorWriter(Writer errorWriter) {
        this.errorWriter = errorWriter;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    protected String getComplianceLevel() {
        return this.complianceLevel;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void configureWorkspace() {
        Path source = new Path(new File(this.sourcePath).getAbsolutePath());
        Path target = new Path(new File(this.outputPath).getAbsolutePath());
        Path commonRoot = source;
        while (!target.startsWith(commonRoot)) {
            commonRoot = commonRoot.getParent();
        }
        WorkspaceConfig workspaceConfig = new WorkspaceConfig(commonRoot.getParent().toString());
        ProjectConfig projectConfig = new ProjectConfig(commonRoot.getLastSegment());
        projectConfig.addSourceFolderMapping(source.relativize(commonRoot).toString(), target.relativize(commonRoot).toString());
        workspaceConfig.addProjectConfig(projectConfig);
        this.workspaceConfigProvider.setWorkspaceConfig(workspaceConfig);
    }

    public boolean compile() {
        try {
            if (this.workspaceConfigProvider.getWorkspaceConfig() == null) {
                this.configureWorkspace();
            }
            ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
            File classDirectory = this.createTempDir("classes");
            try {
                this.compilerPhases.setIndexing((Notifier)resourceSet, true);
                this.installJvmTypeProvider(resourceSet, classDirectory, true);
                this.loadXtendFiles(resourceSet);
                File sourceDirectory = this.createStubs(resourceSet);
                if (!this.preCompileStubs(sourceDirectory, classDirectory)) {
                    log.debug((Object)"Compilation of stubs and existing Java code had errors. This is expected and usually is not a probblem.");
                }
            }
            finally {
                this.compilerPhases.setIndexing((Notifier)resourceSet, false);
            }
            this.installJvmTypeProvider(resourceSet, classDirectory, false);
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            List<Issue> issues = this.validate(resourceSet);
            Iterable errors = Iterables.filter(issues, (Predicate)SeverityFilter.ERROR);
            Iterable warnings = Iterables.filter(issues, (Predicate)SeverityFilter.WARNING);
            this.reportIssues(Iterables.concat((Iterable)errors, (Iterable)warnings));
            if (!Iterables.isEmpty((Iterable)errors)) {
                return false;
            }
            this.generateJavaFiles(resourceSet);
        }
        finally {
            if (this.isDeleteTempDirectory()) {
                this.deleteTmpFolders();
            }
        }
        return true;
    }

    protected ResourceSet loadXtendFiles(final ResourceSet resourceSet) {
        this.encodingProvider.setDefaultEncoding(this.getFileEncoding());
        final NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setExtension(this.fileExtensionProvider.getPrimaryFileExtension());
        PathTraverser pathTraverser = new PathTraverser();
        pathTraverser.resolvePathes(this.getSourcePathDirectories(), (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean matches = nameBasedFilter.matches(input);
                if (matches) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("load xtend file '" + input + "'"));
                    }
                    resourceSet.getResource(input, true);
                }
                return matches;
            }
        });
        return resourceSet;
    }

    @Deprecated
    protected ResourceSet loadXtendFiles() {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        return this.loadXtendFiles(resourceSet);
    }

    protected File createStubs(ResourceSet resourceSet) {
        File outputDirectory = this.createTempDir("stubs");
        JavaIoFileSystemAccess fileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        fileSystemAccess.setOutputPath(outputDirectory.toString());
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            IResourceDescription description = this.resourceDescriptionManager.getResourceDescription(resource);
            for (IEObjectDescription jvmTypeDescription : description.getExportedObjects()) {
                JvmDeclaredType jvmType = (JvmDeclaredType)jvmTypeDescription.getEObjectOrProxy();
                QualifiedName qualifiedName = jvmTypeDescription.getQualifiedName();
                StringBuilder classSignatureBuilder = new StringBuilder();
                if (qualifiedName.getSegments().size() > 1) {
                    String string = qualifiedName.toString();
                    classSignatureBuilder.append("package " + string.substring(0, string.lastIndexOf(46)) + ";");
                    classSignatureBuilder.append("\n");
                }
                classSignatureBuilder.append("public ");
                if (jvmType instanceof JvmGenericType) {
                    JvmGenericType genericType = (JvmGenericType)jvmType;
                    if (genericType.isInterface()) {
                        classSignatureBuilder.append("interface ");
                    } else {
                        classSignatureBuilder.append("class ");
                    }
                } else if (jvmType instanceof JvmEnumerationType) {
                    classSignatureBuilder.append("enum ");
                } else if (jvmType instanceof JvmAnnotationType) {
                    classSignatureBuilder.append("@interface ");
                }
                classSignatureBuilder.append(String.valueOf(qualifiedName.getLastSegment()) + "{}");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("create java stub '" + qualifiedName + "'"));
                }
                fileSystemAccess.generateFile(this.getJavaFileName(qualifiedName), (CharSequence)classSignatureBuilder.toString());
            }
        }
        return outputDirectory;
    }

    protected boolean preCompileStubs(File tmpSourceDirectory, File classDirectory) {
        ArrayList commandLine = Lists.newArrayList();
        if (this.isVerbose()) {
            commandLine.add("-verbose");
        }
        if (!Strings.isEmpty((String)this.classPath)) {
            commandLine.add("-cp \"" + Strings.concat((String)File.pathSeparator, this.getClassPathEntries()) + "\"");
        }
        commandLine.add("-d \"" + classDirectory.toString() + "\"");
        commandLine.add("-" + this.getComplianceLevel());
        commandLine.add("-proceedOnError");
        ArrayList sourceDirectories = Lists.newArrayList(this.getSourcePathDirectories());
        sourceDirectories.add(tmpSourceDirectory.toString());
        commandLine.add(Strings.concat((String)" ", (List)Lists.transform((List)sourceDirectories, (Function)new Function<String, String>(){

            public String apply(String path) {
                return "\"" + path + "\"";
            }
        })));
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke batch compiler with '" + Strings.concat((String)" ", (List)commandLine) + "'"));
        }
        return BatchCompiler.compile((String)Strings.concat((String)" ", (List)commandLine), (PrintWriter)new PrintWriter(this.getOutputWriter()), (PrintWriter)new PrintWriter(this.getErrorWriter()), null);
    }

    protected List<Issue> validate(ResourceSet resourceSet) {
        ArrayList issues = Lists.newArrayList();
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(resource.getURI());
            if (resourceServiceProvider == null) continue;
            IResourceValidator resourceValidator = resourceServiceProvider.getResourceValidator();
            List result = resourceValidator.validate(resource, CheckMode.ALL, null);
            Iterables.addAll((Collection)issues, (Iterable)result);
        }
        return issues;
    }

    @Deprecated
    protected void installJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory) {
        this.internalInstallJvmTypeProvider(resourceSet, tmpClassDirectory, false);
    }

    protected void installJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory, boolean skipIndexLookup) {
        if (skipIndexLookup) {
            this.internalInstallJvmTypeProvider(resourceSet, tmpClassDirectory, skipIndexLookup);
        } else {
            this.installJvmTypeProvider(resourceSet, tmpClassDirectory);
        }
    }

    private void internalInstallJvmTypeProvider(ResourceSet resourceSet, File tmpClassDirectory, boolean skipIndexLookup) {
        Iterable classPathEntries = Iterables.concat(this.getClassPathEntries(), this.getSourcePathDirectories(), Arrays.asList(tmpClassDirectory.toString()));
        classPathEntries = Iterables.filter((Iterable)classPathEntries, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isEmpty((String)input.trim());
            }
        });
        Iterable classPathUrls = Iterables.transform((Iterable)classPathEntries, (Function)new Function<String, URL>(){

            public URL apply(String from) {
                try {
                    return new File(from).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (log.isDebugEnabled()) {
            log.debug((Object)("classpath used for Xtend compilation : " + classPathUrls));
        }
        URLClassLoader urlClassLoader = new URLClassLoader((URL[])Iterables.toArray((Iterable)classPathUrls, URL.class), this.useCurrentClassLoaderAsParent ? this.getClass().getClassLoader() : null);
        new ClasspathTypeProvider((ClassLoader)urlClassLoader, resourceSet, skipIndexLookup ? null : this.indexedJvmTypeAccess);
        ((XtextResourceSet)resourceSet).setClasspathURIContext((Object)urlClassLoader);
        URLClassLoader urlClassLoaderForAnnotationProcessing = new URLClassLoader((URL[])Iterables.toArray((Iterable)classPathUrls, URL.class), this.getClass().getClassLoader());
        this.annotationProcessorFactory.setClassLoader(urlClassLoaderForAnnotationProcessing);
    }

    protected void reportIssues(Iterable<Issue> issues) {
        for (Issue issue : issues) {
            StringBuilder issueBuilder = this.createIssueMessage(issue);
            if (Severity.ERROR == issue.getSeverity()) {
                log.error((Object)issueBuilder.toString());
                continue;
            }
            if (Severity.WARNING != issue.getSeverity()) continue;
            log.warn((Object)issueBuilder.toString());
        }
    }

    private StringBuilder createIssueMessage(Issue issue) {
        StringBuilder issueBuilder = new StringBuilder("\n");
        issueBuilder.append(issue.getSeverity()).append(": \t");
        URI uriToProblem = issue.getUriToProblem();
        if (uriToProblem != null) {
            URI resourceUri = uriToProblem.trimFragment();
            issueBuilder.append(resourceUri.lastSegment()).append(" - ");
            if (resourceUri.isFile()) {
                issueBuilder.append(resourceUri.toFileString());
            }
        }
        issueBuilder.append("\n").append(issue.getLineNumber()).append(": ").append(issue.getMessage());
        return issueBuilder;
    }

    protected void generateJavaFiles(ResourceSet resourceSet) {
        JavaIoFileSystemAccess javaIoFileSystemAccess = (JavaIoFileSystemAccess)this.javaIoFileSystemAccessProvider.get();
        javaIoFileSystemAccess.setOutputPath(this.outputPath);
        javaIoFileSystemAccess.setWriteTrace(this.writeTraceFiles);
        ResourceSetBasedResourceDescriptions resourceDescriptions = this.getResourceDescriptions(resourceSet);
        Iterable exportedObjectsByType = resourceDescriptions.getExportedObjectsByType(TypesPackage.Literals.JVM_DECLARED_TYPE);
        if (log.isInfoEnabled()) {
            int size = Iterables.size((Iterable)exportedObjectsByType);
            if (size == 0) {
                log.info((Object)("No sources to compile in '" + this.sourcePath + "'"));
            } else {
                log.info((Object)("Compiling " + size + " source " + (size == 1 ? "file" : "files") + " to " + this.outputPath));
            }
        }
        for (IEObjectDescription eObjectDescription : exportedObjectsByType) {
            JvmDeclaredType jvmGenericType = (JvmDeclaredType)eObjectDescription.getEObjectOrProxy();
            CharSequence generatedType = this.generator.generateType(jvmGenericType, this.generatorConfigprovider.get((EObject)jvmGenericType));
            QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)jvmGenericType);
            if (log.isDebugEnabled()) {
                log.debug((Object)("write '" + this.outputPath + File.separator + this.getJavaFileName(qualifiedName) + "'"));
            }
            javaIoFileSystemAccess.generateFile(this.getJavaFileName(qualifiedName), generatedType);
        }
    }

    protected ResourceSetBasedResourceDescriptions getResourceDescriptions(ResourceSet resourceSet) {
        ResourceSetBasedResourceDescriptions resourceDescriptions = (ResourceSetBasedResourceDescriptions)this.resourceSetDescriptionsProvider.get();
        resourceDescriptions.setContext((Notifier)resourceSet);
        resourceDescriptions.setRegistry(IResourceServiceProvider.Registry.INSTANCE);
        return resourceDescriptions;
    }

    private String getJavaFileName(QualifiedName typeName) {
        return String.valueOf(Strings.concat((String)"/", (List)typeName.getSegments())) + ".java";
    }

    @Nullable
    protected XtendFile getXtendFile(Resource resource) {
        EObject model;
        XtextResource xtextResource = (XtextResource)resource;
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (model = parseResult.getRootASTElement()) instanceof XtendFile) {
            XtendFile xtendFile = (XtendFile)model;
            return xtendFile;
        }
        return null;
    }

    protected List<String> getClassPathEntries() {
        return this.getDirectories(this.classPath);
    }

    protected List<String> getSourcePathDirectories() {
        return this.getDirectories(this.sourcePath);
    }

    protected List<String> getDirectories(String path) {
        if (Strings.isEmpty((String)path)) {
            return Lists.newArrayList();
        }
        List split = Strings.split((String)Strings.emptyIfNull((String)path), (String)File.pathSeparator);
        return Lists.transform((List)split, (Function)new Function<String, String>(){

            public String apply(String from) {
                try {
                    return new File(from).getCanonicalPath();
                }
                catch (IOException e) {
                    throw new WrappedException((Exception)e);
                }
            }
        });
    }

    protected File createTempDir(String prefix) {
        File tempDir = new File(this.getTempDirectory(), String.valueOf(prefix) + System.nanoTime());
        XtendBatchCompiler.cleanFolder(tempDir, ACCEPT_ALL_FILTER, true, true);
        if (!tempDir.mkdirs()) {
            throw new RuntimeException("Error creating temp directory '" + tempDir.getAbsolutePath() + "'");
        }
        this.tempFolders.add(tempDir);
        return tempDir;
    }

    protected void deleteTmpFolders() {
        for (File file : this.tempFolders) {
            XtendBatchCompiler.cleanFolder(file, ACCEPT_ALL_FILTER, true, true);
        }
    }

    protected static boolean cleanFolder(File parentFolder, FileFilter filter, boolean continueOnError, boolean deleteParentFolder) {
        if (!parentFolder.exists()) {
            return true;
        }
        if (filter == null) {
            filter = ACCEPT_ALL_FILTER;
        }
        log.debug((Object)("Cleaning folder " + parentFolder.toString()));
        File[] contents = parentFolder.listFiles(filter);
        int j = 0;
        while (j < contents.length) {
            File file = contents[j];
            if (file.isDirectory()) {
                if (!XtendBatchCompiler.cleanFolder(file, filter, continueOnError, true) && !continueOnError) {
                    return false;
                }
            } else if (!file.delete()) {
                log.error((Object)("Couldn't delete " + file.getAbsolutePath()));
                if (!continueOnError) {
                    return false;
                }
            }
            ++j;
        }
        if (deleteParentFolder && parentFolder.list().length == 0 && !parentFolder.delete()) {
            log.error((Object)("Couldn't delete " + parentFolder.getAbsolutePath()));
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SeverityFilter
    implements Predicate<Issue> {
        private static final SeverityFilter WARNING = new SeverityFilter(Severity.WARNING);
        private static final SeverityFilter ERROR = new SeverityFilter(Severity.ERROR);
        private Severity severity;

        private SeverityFilter(Severity severity) {
            this.severity = severity;
        }

        public boolean apply(Issue issue) {
            return this.severity == issue.getSeverity();
        }
    }
}

