/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameValueConverter;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.imports.ImportSectionRegionUtil;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewritableImportSection {
    private List<XImportDeclaration> originalImportDeclarations = Lists.newArrayList();
    private List<XImportDeclaration> addedImportDeclarations = Lists.newArrayList();
    private Set<XImportDeclaration> removedImportDeclarations = Sets.newLinkedHashSet();
    private Map<String, JvmDeclaredType> plainImports = Maps.newHashMap();
    private Set<JvmDeclaredType> staticImports = Sets.newHashSet();
    private Set<JvmDeclaredType> staticExtensionImports = Sets.newHashSet();
    private String lineSeparator;
    private XtextResource resource;
    private ImportSectionRegionUtil regionUtil;
    private boolean isSort;
    private Set<String> implicitlyImportedPackages;
    private IValueConverter<String> nameValueConverter;
    private ITextRegion importRegion;

    public RewritableImportSection(XtextResource resource, IImportsConfiguration importsConfiguration, XImportSection originalImportSection, String lineSeparator, ImportSectionRegionUtil regionUtil, IValueConverter<String> nameConverter) {
        this.resource = resource;
        this.lineSeparator = lineSeparator;
        this.regionUtil = regionUtil;
        this.nameValueConverter = nameConverter;
        this.implicitlyImportedPackages = importsConfiguration.getImplicitlyImportedPackages(resource);
        this.importRegion = regionUtil.computeRegion(resource);
        if (originalImportSection != null) {
            for (XImportDeclaration originalImportDeclaration : originalImportSection.getImportDeclarations()) {
                this.originalImportDeclarations.add(originalImportDeclaration);
                if (originalImportDeclaration.isStatic()) {
                    if (originalImportDeclaration.isExtension()) {
                        this.staticExtensionImports.add(originalImportDeclaration.getImportedType());
                        continue;
                    }
                    this.staticImports.add(originalImportDeclaration.getImportedType());
                    continue;
                }
                if (originalImportDeclaration.getImportedType() == null) continue;
                this.plainImports.put(originalImportDeclaration.getImportedType().getSimpleName(), originalImportDeclaration.getImportedType());
            }
        }
    }

    public void setSort(boolean isSort) {
        this.isSort = isSort;
    }

    public boolean isSort() {
        return this.isSort;
    }

    public boolean addImport(JvmDeclaredType type) {
        if (this.plainImports.containsKey(type.getSimpleName()) || !this.needsImport(type)) {
            return false;
        }
        this.plainImports.put(type.getSimpleName(), type);
        XImportDeclaration importDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        importDeclaration.setImportedType(type);
        this.addedImportDeclarations.add(importDeclaration);
        return true;
    }

    protected boolean needsImport(JvmDeclaredType type) {
        if (type.getDeclaringType() != null) {
            return true;
        }
        String packageName = type.getPackageName();
        return packageName != null && !this.implicitlyImportedPackages.contains(packageName);
    }

    public boolean removeImport(JvmDeclaredType type) {
        XImportDeclaration importDeclaration = this.findOriginalImport(type, this.addedImportDeclarations, false, false);
        if (importDeclaration != null) {
            this.addedImportDeclarations.remove(importDeclaration);
        } else {
            importDeclaration = this.findOriginalImport(type, this.originalImportDeclarations, false, false);
            if (importDeclaration != null) {
                this.removedImportDeclarations.add(importDeclaration);
            }
        }
        if (importDeclaration != null) {
            for (Map.Entry<String, JvmDeclaredType> entry : this.plainImports.entrySet()) {
                if (entry.getValue() != type) continue;
                this.plainImports.remove(entry.getKey());
                return true;
            }
        }
        return false;
    }

    protected XImportDeclaration findOriginalImport(JvmDeclaredType type, Collection<XImportDeclaration> list, boolean isStatic, boolean isExtension) {
        for (XImportDeclaration importDeclaration : list) {
            if (isStatic ^ importDeclaration.isStatic() || isExtension ^ importDeclaration.isExtension() || importDeclaration.getImportedType() != type) continue;
            return importDeclaration;
        }
        return null;
    }

    public JvmDeclaredType getImportedType(String simpleName) {
        return this.plainImports.get(simpleName);
    }

    public boolean addStaticImport(JvmDeclaredType type) {
        if (this.staticImports.contains(type)) {
            return false;
        }
        this.staticImports.add(type);
        XImportDeclaration importDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        importDeclaration.setImportedType(type);
        importDeclaration.setStatic(true);
        this.addedImportDeclarations.add(importDeclaration);
        return true;
    }

    public boolean removeStaticImport(JvmDeclaredType type) {
        XImportDeclaration importDeclaration = this.findOriginalImport(type, this.originalImportDeclarations, true, false);
        if (importDeclaration != null) {
            this.removedImportDeclarations.add(importDeclaration);
        } else {
            importDeclaration = this.findOriginalImport(type, this.addedImportDeclarations, true, false);
            if (importDeclaration != null) {
                this.addedImportDeclarations.remove(importDeclaration);
            }
        }
        this.staticImports.remove(type);
        return importDeclaration != null;
    }

    public boolean addStaticExtensionImport(JvmDeclaredType type) {
        if (this.staticExtensionImports.contains(type)) {
            return false;
        }
        this.staticExtensionImports.add(type);
        XImportDeclaration importDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        importDeclaration.setImportedType(type);
        importDeclaration.setStatic(true);
        importDeclaration.setExtension(true);
        this.addedImportDeclarations.add(importDeclaration);
        return true;
    }

    public boolean removeStaticExtensionImport(JvmDeclaredType type) {
        XImportDeclaration importDeclaration = this.findOriginalImport(type, this.originalImportDeclarations, true, true);
        if (importDeclaration != null) {
            this.removedImportDeclarations.add(importDeclaration);
        } else {
            importDeclaration = this.findOriginalImport(type, this.addedImportDeclarations, true, true);
            if (importDeclaration != null) {
                this.addedImportDeclarations.remove(importDeclaration);
            }
        }
        this.staticExtensionImports.remove(type);
        return importDeclaration != null;
    }

    public List<ReplaceRegion> rewrite() {
        this.removeObsoleteStaticImports();
        final ArrayList replaceRegions = Lists.newArrayList();
        if (this.isSort) {
            ArrayList allImportDeclarations = Lists.newArrayList();
            allImportDeclarations.addAll(this.originalImportDeclarations);
            allImportDeclarations.addAll(this.addedImportDeclarations);
            allImportDeclarations.removeAll(this.removedImportDeclarations);
            String newImportSection = this.serializeImports(allImportDeclarations);
            this.importRegion = this.regionUtil.addLeadingWhitespace(this.importRegion, this.resource);
            this.importRegion = this.regionUtil.addTrailingWhitespace(this.importRegion, this.resource);
            return Collections.singletonList(new ReplaceRegion(this.importRegion, newImportSection));
        }
        for (XImportDeclaration removedImportDeclaration : this.removedImportDeclarations) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)removedImportDeclaration);
            if (node == null) continue;
            TextRegion textRegion = new TextRegion(node.getOffset(), node.getLength());
            textRegion = this.regionUtil.addTrailingSingleWhitespace((ITextRegion)textRegion, this.lineSeparator, this.resource);
            replaceRegions.add(new ReplaceRegion((ITextRegion)textRegion, ""));
        }
        this.addSectionToAppend(new IAcceptor<ReplaceRegion>(){

            public void accept(ReplaceRegion t) {
                replaceRegions.add(t);
            }
        });
        return replaceRegions;
    }

    private void removeObsoleteStaticImports() {
        for (JvmDeclaredType staticExtensionImport : this.staticExtensionImports) {
            if (!this.staticImports.contains(staticExtensionImport)) continue;
            this.removeStaticImport(staticExtensionImport);
        }
    }

    protected void addSectionToAppend(IAcceptor<ReplaceRegion> acceptor) {
        StringBuilder importDeclarationsToAppend = this.getImportDeclarationsToAppend();
        if (importDeclarationsToAppend.length() == 0) {
            return;
        }
        this.importRegion = this.regionUtil.addLeadingWhitespace(this.importRegion, this.resource);
        this.importRegion = this.regionUtil.addTrailingSingleWhitespace(this.importRegion, this.lineSeparator, this.resource);
        int insertOffset = this.importRegion.getOffset() + this.importRegion.getLength();
        if (insertOffset != 0 && this.originalImportDeclarations.isEmpty()) {
            importDeclarationsToAppend.insert(0, this.lineSeparator);
        }
        importDeclarationsToAppend.append(this.lineSeparator);
        int insertLength = -this.importRegion.getLength();
        ReplaceRegion appendDeclarations = new ReplaceRegion((ITextRegion)new TextRegion(insertOffset, insertLength += this.regionUtil.addTrailingWhitespace(this.importRegion, this.resource).getLength()), importDeclarationsToAppend.toString());
        acceptor.accept((Object)appendDeclarations);
    }

    protected StringBuilder getImportDeclarationsToAppend() {
        StringBuilder builder = new StringBuilder();
        for (XImportDeclaration newImportDeclaration : this.addedImportDeclarations) {
            this.appendImport(builder, newImportDeclaration);
        }
        return builder;
    }

    protected void appendImport(StringBuilder builder, XImportDeclaration newImportDeclaration) {
        builder.append("import ");
        if (newImportDeclaration.isStatic()) {
            builder.append("static ");
            if (newImportDeclaration.isExtension()) {
                builder.append("extension ");
            }
        }
        String escapedTypeName = this.nameValueConverter.toString((Object)this.serializeType(newImportDeclaration.getImportedType()));
        builder.append(escapedTypeName);
        if (newImportDeclaration.isStatic()) {
            builder.append(".*");
        }
        builder.append(this.lineSeparator);
    }

    protected String serializeType(JvmDeclaredType type) {
        return type.getQualifiedName('.');
    }

    protected String serializeImports(List<XImportDeclaration> allDeclarations) {
        StringBuilder builder = new StringBuilder();
        if (this.needsPreceedingBlankLine()) {
            builder.append(this.lineSeparator).append(this.lineSeparator);
        }
        boolean needNewline = this.appendSubsection(builder, Iterables.filter(allDeclarations, (Predicate)new Predicate<XImportDeclaration>(){

            public boolean apply(XImportDeclaration input) {
                return !input.isStatic();
            }
        }), false);
        needNewline = this.appendSubsection(builder, Iterables.filter(allDeclarations, (Predicate)new Predicate<XImportDeclaration>(){

            public boolean apply(XImportDeclaration input) {
                return input.isStatic() && !input.isExtension();
            }
        }), needNewline);
        this.appendSubsection(builder, Iterables.filter(allDeclarations, (Predicate)new Predicate<XImportDeclaration>(){

            public boolean apply(XImportDeclaration input) {
                return input.isStatic() && input.isExtension();
            }
        }), needNewline);
        if (!Iterables.isEmpty(allDeclarations)) {
            builder.append(this.lineSeparator);
        }
        return builder.toString();
    }

    protected boolean needsPreceedingBlankLine() {
        return this.regionUtil.addLeadingWhitespace(this.importRegion, this.resource).getOffset() != 0;
    }

    protected boolean appendSubsection(StringBuilder builder, Iterable<XImportDeclaration> subSection, boolean needsNewline) {
        if (!Iterables.isEmpty(subSection)) {
            if (needsNewline) {
                builder.append(this.lineSeparator);
            }
            for (XImportDeclaration declaration : this.isSort() ? this.sort(subSection) : subSection) {
                this.appendImport(builder, declaration);
            }
            return true;
        }
        return needsNewline;
    }

    protected List<XImportDeclaration> sort(Iterable<XImportDeclaration> declarations) {
        ArrayList sortMe = Lists.newArrayList((Iterable)Iterables.filter(declarations, (Predicate)new Predicate<XImportDeclaration>(){

            public boolean apply(XImportDeclaration in) {
                return !Strings.isEmpty((String)in.getImportedTypeName());
            }
        }));
        Collections.sort(sortMe, new Comparator<XImportDeclaration>(){

            @Override
            public int compare(XImportDeclaration o1, XImportDeclaration o2) {
                return o1.getImportedTypeName().compareTo(o2.getImportedTypeName());
            }
        });
        return sortMe;
    }

    public static class Factory {
        @Inject
        private IImportsConfiguration importsConfiguration;
        @Inject
        private IWhitespaceInformationProvider whitespaceInformationProvider;
        @Inject
        private ImportSectionRegionUtil regionUtil;
        @Inject
        private XbaseQualifiedNameValueConverter nameValueConverter;

        public RewritableImportSection parse(XtextResource resource) {
            RewritableImportSection rewritableImportSection = new RewritableImportSection(resource, this.importsConfiguration, this.importsConfiguration.getImportSection(resource), this.whitespaceInformationProvider.getLineSeparatorInformation(resource.getURI()).getLineSeparator(), this.regionUtil, (IValueConverter<String>)this.nameValueConverter);
            return rewritableImportSection;
        }

        public RewritableImportSection createNewEmpty(XtextResource resource) {
            RewritableImportSection rewritableImportSection = new RewritableImportSection(resource, this.importsConfiguration, null, this.whitespaceInformationProvider.getLineSeparatorInformation(resource.getURI()).getLineSeparator(), this.regionUtil, (IValueConverter<String>)this.nameValueConverter);
            rewritableImportSection.setSort(true);
            return rewritableImportSection;
        }
    }
}

