/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.contentassist;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplate;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplates;
import org.eclipse.xtext.ui.codetemplates.templates.Variable;
import org.eclipse.xtext.ui.codetemplates.ui.contentassist.AbstractCodetemplatesProposalProvider;
import org.eclipse.xtext.ui.codetemplates.ui.contentassist.DummyDocument;
import org.eclipse.xtext.ui.codetemplates.ui.contentassist.DummyTextViewer;
import org.eclipse.xtext.ui.codetemplates.ui.evaluator.EvaluatedTemplate;
import org.eclipse.xtext.ui.codetemplates.ui.partialEditing.PartialContentAssistContextFactory;
import org.eclipse.xtext.ui.codetemplates.ui.projectedEditing.ProjectionAwareProposalAcceptor;
import org.eclipse.xtext.ui.codetemplates.ui.projectedEditing.TemporaryResourceProvider;
import org.eclipse.xtext.ui.codetemplates.ui.registry.LanguageRegistry;
import org.eclipse.xtext.ui.codetemplates.ui.resolvers.IInspectableTemplateVariableResolver;
import org.eclipse.xtext.ui.codetemplates.ui.resolvers.InspectableTemplateVariableResolverRegistry;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IFollowElementAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.RepeatedContentAssistProcessor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class CodetemplatesProposalProvider
extends AbstractCodetemplatesProposalProvider
implements RepeatedContentAssistProcessor.ModeAware {
    @Inject
    private LanguageRegistry languageRegistry;
    @Inject
    private InspectableTemplateVariableResolverRegistry templateVariableResolverRegistry;
    @Inject
    private TemporaryResourceProvider temporaryResourceProvider;
    private int mode;
    private static final int NESTED = 2;
    private static final int NORMAL = 1;

    public void reset() {
        this.mode = 2;
    }

    public void nextMode() {
        this.mode = this.mode % 3 + 1;
    }

    public String getNextCategory() {
        switch (this.mode) {
            case 1: {
                return "target language proposals";
            }
            case 2: {
                return "all proposals";
            }
        }
        return "template infrastructure proposals";
    }

    public boolean isLastMode() {
        return this.mode == 2;
    }

    private String getAssignedFeature(RuleCall call) {
        Assignment ass = GrammarUtil.containingAssignment((EObject)call);
        if (ass != null) {
            String result = ass.getFeature();
            if (result.equals(result.toLowerCase())) {
                result = Strings.toFirstUpper((String)result);
            }
            return result;
        }
        return null;
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if ((this.mode & 1) != 0) {
            String feature = this.getAssignedFeature(ruleCall);
            this.createStringProposal(context, acceptor, feature, ruleCall);
        }
    }

    private void createStringProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor, String feature, RuleCall ruleCall) {
        ICompletionProposal proposal;
        String proposalText = feature != null ? feature : Strings.toFirstUpper((String)ruleCall.getRule().getName().toLowerCase());
        String displayText = proposalText = this.getValueConverter().toString((Object)proposalText, ruleCall.getRule().getName());
        if (feature != null) {
            displayText = String.valueOf(displayText) + " - " + ruleCall.getRule().getName();
        }
        if ((proposal = this.createCompletionProposal(proposalText, displayText, null, context)) instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
            configurable.setSelectionStart(configurable.getReplacementOffset() + 1);
            configurable.setSelectionLength(proposalText.length() - 2);
            configurable.setAutoInsertable(false);
            configurable.setSimpleLinkedMode(context.getViewer(), new char[]{proposalText.charAt(0), '\t'});
        }
        acceptor.accept(proposal);
    }

    public void completeVariable_Name(EObject model, Assignment assignment, final ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if ((this.mode & 1) != 0) {
            String proposalText = "variable";
            StyledString displayText = new StyledString(proposalText).append(" - Create a new template variable", StyledString.QUALIFIER_STYLER);
            ICompletionProposal proposal = this.createCompletionProposal(proposalText, displayText, null, context);
            if (proposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
                configurable.setSelectionStart(configurable.getReplacementOffset());
                configurable.setSelectionLength(proposalText.length());
                configurable.setAutoInsertable(false);
                configurable.setSimpleLinkedMode(context.getViewer(), new char[]{'\t', ' '});
            }
            acceptor.accept(proposal);
            TemplateData data = new TemplateData(model);
            if (data.doCreateProposals()) {
                ContextTypeIdHelper helper = this.languageRegistry.getContextTypeIdHelper(data.language);
                if (helper != null) {
                    String contextTypeId = helper.getId(data.rule);
                    ContextTypeRegistry contextTypeRegistry = this.languageRegistry.getContextTypeRegistry(data.language);
                    TemplateContextType contextType = contextTypeRegistry.getContextType(contextTypeId);
                    if (contextType != null) {
                        UnmodifiableIterator resolvers = Iterators.filter((Iterator)contextType.resolvers(), TemplateVariableResolver.class);
                        while (resolvers.hasNext()) {
                            StyledString displayString;
                            String type;
                            final TemplateVariableResolver resolver = (TemplateVariableResolver)resolvers.next();
                            IInspectableTemplateVariableResolver inspectableResolver = this.templateVariableResolverRegistry.toInspectableResolver(resolver);
                            if (inspectableResolver != null) {
                                if (!inspectableResolver.hasMandatoryParameters()) {
                                    type = resolver.getType();
                                    displayString = new StyledString(type, StyledString.DECORATIONS_STYLER).append(" - " + resolver.getDescription(), StyledString.QUALIFIER_STYLER);
                                    acceptor.accept(this.createCompletionProposal(type, displayString, null, context));
                                }
                                String proposalText2 = "variable:" + resolver.getType();
                                StyledString displayText2 = new StyledString("variable").append(":" + resolver.getType(), StyledString.DECORATIONS_STYLER).append(" - " + resolver.getDescription(), StyledString.QUALIFIER_STYLER);
                                if (inspectableResolver.hasMandatoryParameters()) {
                                    proposalText2 = String.valueOf(proposalText2) + "()";
                                }
                                ContentAssistContext.Builder builder = context.copy();
                                PrefixMatcher newMatcher = new PrefixMatcher(){

                                    public boolean isCandidateMatchingPrefix(String name, String prefix) {
                                        return context.getMatcher().isCandidateMatchingPrefix(name, prefix) || context.getMatcher().isCandidateMatchingPrefix("variable:" + resolver.getType(), prefix) || context.getMatcher().isCandidateMatchingPrefix(resolver.getType(), prefix);
                                    }
                                };
                                builder.setMatcher(newMatcher);
                                ContentAssistContext myContext = builder.toContext();
                                ICompletionProposal proposal2 = this.createCompletionProposal(proposalText2, displayText2, null, myContext);
                                if (proposal2 instanceof ConfigurableCompletionProposal) {
                                    ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal2;
                                    configurable.setSelectionStart(configurable.getReplacementOffset());
                                    configurable.setSelectionLength("variable".length());
                                    configurable.setAutoInsertable(false);
                                    if (inspectableResolver.hasMandatoryParameters()) {
                                        configurable.setCursorPosition(proposalText2.length() - 1);
                                    }
                                    configurable.setSimpleLinkedMode(myContext.getViewer(), new char[]{'\t'});
                                }
                                acceptor.accept(proposal2);
                                continue;
                            }
                            type = resolver.getType();
                            displayString = new StyledString(type, StyledString.DECORATIONS_STYLER).append(" - " + resolver.getDescription(), StyledString.QUALIFIER_STYLER);
                            acceptor.accept(this.createCompletionProposal(type, displayString, null, context));
                        }
                    }
                }
                if (data.template.getBody() != null) {
                    for (Variable variable : Iterables.filter((Iterable)data.template.getBody().getParts(), Variable.class)) {
                        if (variable == model || variable.getName() == null) continue;
                        String proposalText3 = variable.getName();
                        StyledString displayText3 = new StyledString(proposalText3).append(" - existing variable", StyledString.QUALIFIER_STYLER);
                        if (variable.getType() != null) {
                            displayText3 = displayText3.append(" of type " + variable.getType(), StyledString.QUALIFIER_STYLER);
                        }
                        ICompletionProposal proposal3 = this.createCompletionProposal(proposalText3, displayText3, null, context);
                        acceptor.accept(proposal3);
                    }
                }
            }
        }
    }

    public void complete_Variable(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if ((this.mode & 1) != 0) {
            String proposalText = "${}";
            StyledString displayText = new StyledString(proposalText, StyledString.DECORATIONS_STYLER).append(" - Create a new template variable", StyledString.QUALIFIER_STYLER);
            ICompletionProposal proposal = this.createCompletionProposal(proposalText, displayText, null, context);
            if (proposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
                configurable.setSelectionStart(configurable.getReplacementOffset() + 2);
                configurable.setSelectionLength(0);
                configurable.setAutoInsertable(false);
                configurable.setSimpleLinkedMode(context.getViewer(), new char[]{'\t', ' '});
            }
            acceptor.accept(proposal);
        }
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if ((this.mode & 1) != 0) {
            if ("$".equals(keyword.getValue()) || "${".equals(keyword.getValue())) {
                return;
            }
            super.completeKeyword(keyword, contentAssistContext, acceptor);
        }
    }

    public void completeVariable_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if ((this.mode & 1) != 0) {
            ContextTypeIdHelper helper;
            super.completeVariable_Name(model, assignment, context, acceptor);
            TemplateData data = new TemplateData(model);
            if (data.doCreateProposals() && (helper = this.languageRegistry.getContextTypeIdHelper(data.language)) != null) {
                String contextTypeId = helper.getId(data.rule);
                ContextTypeRegistry contextTypeRegistry = this.languageRegistry.getContextTypeRegistry(data.language);
                TemplateContextType contextType = contextTypeRegistry.getContextType(contextTypeId);
                if (contextType != null) {
                    UnmodifiableIterator resolvers = Iterators.filter((Iterator)contextType.resolvers(), TemplateVariableResolver.class);
                    while (resolvers.hasNext()) {
                        TemplateVariableResolver resolver = (TemplateVariableResolver)resolvers.next();
                        String type = resolver.getType();
                        StyledString displayString = new StyledString(type).append(" - " + resolver.getDescription(), StyledString.QUALIFIER_STYLER);
                        acceptor.accept(this.createCompletionProposal(type, displayString, null, context));
                    }
                }
            }
        }
    }

    public void completeVariable_Parameters(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        VariableData data;
        if ((this.mode & 1) != 0 && (data = new VariableData(model)).doCreateProposals()) {
            String variableType = data.variable.getType();
            if ("CrossReference".equals(variableType)) {
                List crossReferences = GrammarUtil.containedCrossReferences((EObject)data.rule);
                for (CrossReference crossReference : crossReferences) {
                    EReference reference = GrammarUtil.getReference((CrossReference)crossReference);
                    String fqn = String.valueOf(reference.getEContainingClass().getName()) + "." + reference.getName();
                    acceptor.accept(this.createCompletionProposal(fqn, context));
                    acceptor.accept(this.createCompletionProposal("'" + fqn + "'", context));
                }
            } else {
                "Enum".equals(variableType);
            }
            super.completeVariable_Parameters(model, assignment, context, acceptor);
        }
    }

    public void complete_Literal(EObject model, RuleCall ruleCall, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        TemplateData data;
        if ((this.mode & 2) != 0 && (data = new TemplateData(model)).doCreateProposals()) {
            final EvaluatedTemplate evaluatedTemplate = new EvaluatedTemplate(data.template);
            this.temporaryResourceProvider.useTemporaryResource(data.template.eResource().getResourceSet(), data.language, data.rule, evaluatedTemplate.getMappedString(), new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource resource) throws Exception {
                    PartialContentAssistContextFactory delegateFactory = CodetemplatesProposalProvider.this.languageRegistry.getPartialContentAssistContextFactory(data.language);
                    delegateFactory.initializeFor(data.rule);
                    String mappedInput = evaluatedTemplate.getMappedString();
                    int mappedOffset = Math.min(mappedInput.length(), evaluatedTemplate.getMappedOffset(context.getOffset()));
                    DummyDocument document = new DummyDocument(mappedInput);
                    DummyTextViewer dummyViewer = new DummyTextViewer((ISelection)TextSelection.emptySelection(), document);
                    ContentAssistContext[] contexts = delegateFactory.create(dummyViewer, mappedOffset, resource);
                    ProjectionAwareProposalAcceptor mappingAcceptor = new ProjectionAwareProposalAcceptor(acceptor, evaluatedTemplate);
                    CodetemplatesProposalProvider.this.createNestedProposals(contexts, context.getViewer(), mappingAcceptor);
                }
            });
        }
    }

    public void completeCodetemplate_KeywordContext(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Grammar language;
        Codetemplates templates;
        Codetemplate template = (Codetemplate)EcoreUtil2.getContainerOfType((EObject)model, Codetemplate.class);
        if (template != null && (templates = (Codetemplates)EcoreUtil2.getContainerOfType((EObject)template, Codetemplates.class)) != null && (language = templates.getLanguage()) != null && !language.eIsProxy()) {
            Set keywords = GrammarUtil.getAllKeywords((Grammar)language);
            Iterator iterator = keywords.iterator();
            while (iterator.hasNext()) {
                String keyword;
                String proposalText = keyword = (String)iterator.next();
                proposalText = this.getValueConverter().toString((Object)proposalText, ((RuleCall)assignment.getTerminal()).getRule().getName());
                StyledString displayText = new StyledString(proposalText).append(" - Keyword", StyledString.QUALIFIER_STYLER);
                ICompletionProposal proposal = this.createCompletionProposal(proposalText, displayText, null, context);
                this.getPriorityHelper().adjustCrossReferencePriority(proposal, context.getPrefix());
                if (proposal instanceof ConfigurableCompletionProposal) {
                    ((ConfigurableCompletionProposal)proposal).setPriority(((ConfigurableCompletionProposal)proposal).getPriority() - 1);
                }
                acceptor.accept(proposal);
            }
        }
    }

    public void createNestedProposals(ContentAssistContext[] contexts, ITextViewer originalViewer, ICompletionProposalAcceptor acceptor) {
        ContentAssistContext[] contentAssistContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            ContentAssistContext context = contentAssistContextArray[n2];
            ContentAssistContext.Builder builder = context.copy();
            builder.setViewer(originalViewer);
            ContentAssistContext myContext = builder.toContext();
            IFollowElementAcceptor selector = this.createNestedSelector(myContext, acceptor);
            for (AbstractElement element : myContext.getFirstSetGrammarElements()) {
                selector.accept(element);
            }
            ++n2;
        }
    }

    protected IFollowElementAcceptor createNestedSelector(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        return new NestedContentAssistProcessorSwitch(context, acceptor);
    }

    public void completeNestedKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        String keywordValue = keyword.getValue();
        String escapedKeywordValue = keywordValue.replace("$", "$$");
        StyledString displayString = new StyledString(keywordValue);
        displayString = !keywordValue.equals(escapedKeywordValue) ? new StyledString(escapedKeywordValue).append(" - ", StyledString.QUALIFIER_STYLER).append(keywordValue, StyledString.COUNTER_STYLER).append(" - Keyword", StyledString.QUALIFIER_STYLER) : displayString.append(" - Keyword", StyledString.QUALIFIER_STYLER);
        ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)this.createCompletionProposal(escapedKeywordValue, displayString, this.getImage((EObject)keyword), contentAssistContext);
        this.getPriorityHelper().adjustKeywordPriority((ICompletionProposal)proposal, contentAssistContext.getPrefix());
        if (proposal != null) {
            proposal.setPriority(proposal.getPriority() * 2);
        }
        acceptor.accept((ICompletionProposal)proposal);
    }

    public void completeNestedAssignment(Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StyledString displayText;
        String proposalText = "${" + assignment.getFeature() + "}";
        if (assignment.getTerminal() instanceof RuleCall) {
            RuleCall ruleCall = (RuleCall)assignment.getTerminal();
            AbstractRule calledRule = ruleCall.getRule();
            displayText = new StyledString("${", StyledString.DECORATIONS_STYLER).append(assignment.getFeature(), null).append("}", StyledString.DECORATIONS_STYLER).append(" - ", StyledString.QUALIFIER_STYLER).append(calledRule.getName(), StyledString.COUNTER_STYLER).append(" - Create a new template variable", StyledString.QUALIFIER_STYLER);
        } else {
            displayText = new StyledString("${", StyledString.DECORATIONS_STYLER).append(assignment.getFeature(), null).append("}", StyledString.DECORATIONS_STYLER).append(" - Create a new template variable", StyledString.QUALIFIER_STYLER);
        }
        ICompletionProposal proposal = this.createCompletionProposal(proposalText, displayText, null, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
            configurable.setSelectionStart(configurable.getReplacementOffset() + 2);
            configurable.setSelectionLength(proposalText.length() - 3);
            configurable.setAutoInsertable(false);
            configurable.setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
            configurable.setPriority(configurable.getPriority() * 2);
        }
        acceptor.accept(proposal);
    }

    public void completeNestedCrossReference(CrossReference crossReference, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Assignment assignment = (Assignment)crossReference.eContainer();
        EReference reference = GrammarUtil.getReference((CrossReference)crossReference);
        if (reference != null) {
            StyledString displayText;
            String proposalText = "${" + assignment.getFeature() + ":CrossReference(" + reference.getEContainingClass().getName() + "." + reference.getName() + ")}";
            ICompletionProposal proposal = this.createCompletionProposal(proposalText, displayText = new StyledString("${", StyledString.DECORATIONS_STYLER).append(assignment.getFeature()).append(":CrossReference(", StyledString.DECORATIONS_STYLER).append(String.valueOf(reference.getEContainingClass().getName()) + "." + reference.getName(), StyledString.COUNTER_STYLER).append(")}", StyledString.DECORATIONS_STYLER).append(" - Create a new template variable", StyledString.QUALIFIER_STYLER), null, context);
            if (proposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
                configurable.setSelectionStart(configurable.getReplacementOffset() + 2);
                configurable.setSelectionLength(assignment.getFeature().length());
                configurable.setAutoInsertable(false);
                configurable.setSimpleLinkedMode(context.getViewer(), new char[]{'\t'});
                configurable.setPriority(configurable.getPriority() * 2);
            }
            acceptor.accept(proposal);
        }
    }

    public void setMode(int cycle) {
        this.mode = cycle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NestedContentAssistProcessorSwitch
    extends XtextSwitch<Boolean>
    implements IFollowElementAcceptor {
        private final ContentAssistContext context;
        private final ICompletionProposalAcceptor acceptor;

        public NestedContentAssistProcessorSwitch(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
            this.context = context;
            this.acceptor = acceptor;
        }

        public Boolean defaultCase(EObject object) {
            return Boolean.TRUE;
        }

        public Boolean caseKeyword(Keyword object) {
            CodetemplatesProposalProvider.this.completeNestedKeyword(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        public Boolean caseAssignment(Assignment object) {
            this.doSwitch((EObject)object.getTerminal());
            return Boolean.TRUE;
        }

        public Boolean caseCrossReference(CrossReference object) {
            CodetemplatesProposalProvider.this.completeNestedCrossReference(object, this.context, this.acceptor);
            return Boolean.TRUE;
        }

        public Boolean caseRuleCall(RuleCall object) {
            if (!(object.getRule() instanceof EnumRule) && (object.getRule() instanceof TerminalRule || GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)object.getRule()))) && object.eContainer() instanceof Assignment) {
                CodetemplatesProposalProvider.this.completeNestedAssignment((Assignment)object.eContainer(), this.context, this.acceptor);
            }
            return Boolean.TRUE;
        }

        public void accept(AbstractElement element) {
            this.doSwitch((EObject)element);
        }
    }

    protected static class TemplateData {
        protected Codetemplate template;
        protected Codetemplates templates;
        protected Grammar language;
        protected AbstractRule rule;

        protected TemplateData(EObject model) {
            this.template = (Codetemplate)EcoreUtil2.getContainerOfType((EObject)model, Codetemplate.class);
            if (this.template != null) {
                this.templates = (Codetemplates)EcoreUtil2.getContainerOfType((EObject)this.template, Codetemplates.class);
                this.language = this.templates.getLanguage();
                this.rule = this.template.getContext();
            }
        }

        protected boolean doCreateProposals() {
            return this.rule != null && !this.rule.eIsProxy() && this.rule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)this.rule));
        }
    }

    protected static class VariableData
    extends TemplateData {
        protected Variable variable;

        protected VariableData(EObject model) {
            super(model);
            if (this.template != null) {
                this.variable = (Variable)EcoreUtil2.getContainerOfType((EObject)model, Variable.class);
            }
        }

        protected boolean doCreateProposals() {
            return this.variable != null && super.doCreateProposals();
        }
    }
}

