/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.handler;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.editor.validation.MarkerIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ValidateActionHandler
extends AbstractHandler {
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private MarkerTypeProvider markerTypeProvider;
    @Inject
    private IssueResolutionProvider issueResolutionProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor xtextEditor = EditorUtils.getActiveXtextEditor(event);
        if (xtextEditor != null) {
            IXtextDocument xtextDocument = xtextEditor.getDocument();
            IResource resource = xtextEditor.getResource();
            if (resource != null) {
                final MarkerIssueProcessor issueProcessor = new MarkerIssueProcessor(resource, xtextEditor.getInternalSourceViewer().getAnnotationModel(), this.markerCreator, this.markerTypeProvider);
                final AnnotationIssueProcessor issueProcessorFastIssues = new AnnotationIssueProcessor(xtextDocument, xtextEditor.getInternalSourceViewer().getAnnotationModel(), this.issueResolutionProvider);
                ValidationJob validationJob = new ValidationJob(this.resourceValidator, xtextDocument, new IValidationIssueProcessor(){

                    @Override
                    public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
                        ArrayList<Issue> fast = new ArrayList<Issue>();
                        for (Issue i : issues) {
                            if (CheckType.FAST != i.getType()) continue;
                            fast.add(i);
                        }
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                        issueProcessor.processIssues(issues, (IProgressMonitor)subMonitor.split(1));
                        issueProcessorFastIssues.processIssues(fast, (IProgressMonitor)subMonitor.split(1));
                    }
                }, CheckMode.ALL);
                validationJob.schedule();
            } else {
                AnnotationIssueProcessor issueProcessor = new AnnotationIssueProcessor(xtextDocument, xtextEditor.getInternalSourceViewer().getAnnotationModel(), this.issueResolutionProvider);
                ValidationJob validationJob = new ValidationJob(this.resourceValidator, xtextDocument, issueProcessor, CheckMode.ALL);
                validationJob.schedule();
            }
        }
        return this;
    }
}

