/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.Issue;

public class IssuesProvider {
    private static final Logger log = Logger.getLogger(IssuesProvider.class);
    @Inject
    private IStorage2UriMapper mapper;
    @Inject
    private IssueUtil issueUtil;

    public List<Issue> getPersistedIssues(URI uri) {
        ArrayList result = Lists.newArrayList();
        Iterable storages = this.mapper.getStorages(uri);
        for (Pair storageToProject : storages) {
            IStorage iStorage = (IStorage)storageToProject.getFirst();
            if (!(iStorage instanceof IFile)) continue;
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = ((IFile)iStorage).findMarkers("org.eclipse.emf.ecore.diagnostic", true, 1);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker iMarker = iMarkerArray[n2];
                    result.add(this.issueUtil.createIssue(iMarker));
                    ++n2;
                }
            }
            catch (CoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

