/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class PredicateUsesUnorderedGroupInspector
extends XtextSwitch<Boolean>
implements ValidationMessageAcceptor {
    private final ValidationMessageAcceptor validationMessageAcceptor;
    private Set<AbstractRule> validatedRules;
    private final Set<RuleCall> callHierarchy;
    private Grammar inspectedGrammar;
    private final Set<EObject> erroneousElements;
    private Set<AbstractElement> alreadyChecked;
    private Stack<AbstractElement> elementStack;

    public PredicateUsesUnorderedGroupInspector(ValidationMessageAcceptor validationMessageAcceptor) {
        this.validationMessageAcceptor = validationMessageAcceptor;
        this.validatedRules = Sets.newHashSet();
        this.callHierarchy = Sets.newHashSet();
        this.erroneousElements = Sets.newHashSet();
        this.alreadyChecked = Sets.newHashSet();
        this.elementStack = new Stack();
    }

    public void inspect(Grammar grammar) {
        this.inspectedGrammar = grammar;
        for (AbstractRule rule : grammar.getRules()) {
            if (this.validatedRules.contains(rule)) continue;
            Set<AbstractRule> storedRules = this.validatedRules;
            this.validatedRules = Sets.newHashSet();
            this.doSwitch(rule);
            storedRules.addAll(this.validatedRules);
            storedRules = this.validatedRules;
        }
    }

    @Override
    public Boolean caseAbstractElement(AbstractElement object) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseAssignment(Assignment object) {
        if (this.shouldTraverse(object)) {
            this.pushChecked(object);
            if (object.getTerminal() != null) {
                this.doSwitch(object.getTerminal());
            }
            this.popChecked(object);
        }
        return Boolean.FALSE;
    }

    protected boolean shouldTraverse(AbstractElement object) {
        return !object.isPredicated() || this.alreadyChecked.add(object);
    }

    private void pushChecked(AbstractElement element) {
        if (element.isPredicated()) {
            this.elementStack.push(element);
        }
    }

    private void popChecked(AbstractElement element) {
        if (element.isPredicated()) {
            this.elementStack.pop();
        }
    }

    @Override
    public Boolean caseCrossReference(CrossReference object) {
        if (this.shouldTraverse(object)) {
            this.pushChecked(object);
            if (object.getTerminal() != null) {
                this.doSwitch(object.getTerminal());
            }
            this.popChecked(object);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseCompoundElement(CompoundElement object) {
        if (this.shouldTraverse(object)) {
            this.pushChecked(object);
            for (AbstractElement child : object.getElements()) {
                this.doSwitch(child);
            }
            this.popChecked(object);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseUnorderedGroup(UnorderedGroup object) {
        if (!this.elementStack.isEmpty()) {
            this.createErrorMessages(object);
        }
        return (Boolean)super.caseUnorderedGroup(object);
    }

    @Override
    public Boolean caseRuleCall(RuleCall object) {
        if (this.shouldTraverse(object)) {
            this.pushChecked(object);
            this.callHierarchy.add(object);
            if (object.getRule() != null) {
                this.doSwitch(object.getRule());
            }
            this.callHierarchy.remove(object);
            this.popChecked(object);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseParserRule(ParserRule object) {
        if (!this.validatedRules.add(object)) {
            return Boolean.FALSE;
        }
        AbstractElement alternatives = object.getAlternatives();
        if (alternatives == null) {
            return Boolean.FALSE;
        }
        return (Boolean)this.doSwitch(alternatives);
    }

    public void createErrorMessages(UnorderedGroup object) {
        this.acceptError("Cannot use unordered groups in syntactic predicates.", (EObject)object, null, -1, null, new String[0]);
        for (AbstractElement element : this.elementStack) {
            this.acceptError("A predicate may not use an unordered group.", (EObject)element, (EStructuralFeature)XtextPackage.Literals.ABSTRACT_ELEMENT__PREDICATED, -1, null, new String[0]);
        }
        for (RuleCall ruleCall : this.callHierarchy) {
            if (ruleCall.isPredicated()) continue;
            this.acceptError("The rule call is part of a call hierarchy that leads to a predicated unordered group.", (EObject)ruleCall, (EStructuralFeature)XtextPackage.Literals.RULE_CALL__RULE, -1, null, new String[0]);
        }
    }

    @Override
    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (this.erroneousElements.add(object) && EcoreUtil.isAncestor((EObject)this.inspectedGrammar, (EObject)object)) {
            this.validationMessageAcceptor.acceptError(message, object, feature, index, code, issueData);
        }
    }

    @Override
    public void acceptWarning(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptWarning(String message, EObject object, int offset, int length, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptInfo(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptInfo(String message, EObject object, int offset, int length, String code, String ... issueData) {
        throw new UnsupportedOperationException();
    }
}

