/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.formatting2;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.formatting2.Chunk;
import org.eclipse.xtend.core.formatting2.Line;
import org.eclipse.xtend.core.formatting2.LineModel;
import org.eclipse.xtend.core.formatting2.SemanticWhitespace;
import org.eclipse.xtend.core.formatting2.TemplateWhitespace;
import org.eclipse.xtend.core.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class RichStringToLineModel
extends AbstractRichStringPartAcceptor.ForLoopOnce {
    private final RichString string;
    private final String document;
    private final ITextRegionAccess nodeModelAccess;
    @Accessors
    private final LineModel model = new LineModel();
    private int offset = -1;
    private int contentStartOffset = -1;
    private int contentStartColumn = -1;
    private Stack<Chunk> indentationStack = new Stack();
    private boolean content = false;
    private boolean indentNextLine = false;
    private boolean _outdentThisLine = false;
    private int lastLiteralEndOffset;

    public RichStringToLineModel(ITextRegionAccess nodeModelAccess, RichString string) {
        String _text;
        this.nodeModelAccess = nodeModelAccess;
        this.string = string;
        ITextSegment _regionForDocument = nodeModelAccess.regionForDocument();
        this.document = _text = _regionForDocument.getText();
    }

    public boolean outdentThisLine() {
        boolean _xifexpression = false;
        if (this.indentNextLine) {
            this.indentNextLine = false;
            _xifexpression = false;
        } else {
            this._outdentThisLine = true;
            _xifexpression = true;
        }
        return _xifexpression;
    }

    public void finish() {
        this.acceptLineBreak(0, false, false);
    }

    protected int literalPrefixLenght(ITextSegment node) {
        boolean _startsWith_2;
        boolean _startsWith_1;
        boolean _startsWith;
        String _text;
        int _switchResult = 0;
        String t = _text = node.getText();
        boolean _matched = false;
        if (!_matched && (_startsWith = t.startsWith("'''"))) {
            _matched = true;
            _switchResult = 3;
        }
        if (!_matched && (_startsWith_1 = t.startsWith("\u00bb\u00bb"))) {
            _matched = true;
            _switchResult = 2;
        }
        if (!_matched && (_startsWith_2 = t.startsWith("\u00bb"))) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 1;
        }
        return _switchResult;
    }

    protected int literalPostfixLenght(ITextSegment node) {
        boolean _endsWith_2;
        boolean _endsWith_1;
        boolean _endsWith;
        String _text;
        int _switchResult = 0;
        String t = _text = node.getText();
        boolean _matched = false;
        if (!_matched && (_endsWith = t.endsWith("'''"))) {
            _matched = true;
            _switchResult = 3;
        }
        if (!_matched && (_endsWith_1 = t.endsWith("\u00ab\u00ab"))) {
            _matched = true;
            _switchResult = 2;
        }
        if (!_matched && (_endsWith_2 = t.endsWith("\u00ab"))) {
            _matched = true;
            _switchResult = 1;
        }
        if (!_matched) {
            _switchResult = 1;
        }
        return _switchResult;
    }

    @Override
    public void announceNextLiteral(RichStringLiteral object) {
        ISemanticRegion node;
        boolean _notEquals;
        super.announceNextLiteral(object);
        if (this.lastLiteralEndOffset > 0 && this.contentStartOffset < 0) {
            this.contentStartOffset = this.lastLiteralEndOffset;
        }
        IEObjectRegion _regionForEObject = this.nodeModelAccess.regionForEObject((EObject)object);
        ISemanticRegionsFinder _regionFor = null;
        if (_regionForEObject != null) {
            _regionFor = _regionForEObject.getRegionFor();
        }
        ISemanticRegion _feature = null;
        if (_regionFor != null) {
            _feature = _regionFor.feature((EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE);
        }
        boolean bl = _notEquals = !Objects.equal((Object)(node = _feature), null);
        if (_notEquals) {
            int _minus;
            int _plus;
            int _offset = node.getOffset();
            int _literalPrefixLenght = this.literalPrefixLenght((ITextSegment)node);
            this.offset = _plus = _offset + _literalPrefixLenght;
            int _endOffset = node.getEndOffset();
            int _literalPostfixLenght = this.literalPostfixLenght((ITextSegment)node);
            this.lastLiteralEndOffset = _minus = _endOffset - _literalPostfixLenght;
        }
        this.content = true;
    }

    @Override
    public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
        super.acceptSemanticLineBreak(charCount, origin, controlStructureSeen);
        this.acceptLineBreak(charCount, true, true);
        this.offset += charCount;
    }

    @Override
    public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
        super.acceptTemplateLineBreak(charCount, origin);
        this.acceptLineBreak(charCount, false, true);
        this.offset += charCount;
    }

    public void acceptLineBreak(int charCount, boolean semantic, boolean startNewLine) {
        this.startContent();
        if (this.contentStartOffset > 0) {
            String lastLinesContent = this.document.substring(this.contentStartOffset, this.offset);
            List<Line> _lines = this.model.getLines();
            boolean _isEmpty = _lines.isEmpty();
            if (_isEmpty) {
                this.model.setLeadingText(lastLinesContent);
                this.contentStartColumn = 0;
            } else {
                List<Line> _lines_1 = this.model.getLines();
                Line lastLine = (Line)IterableExtensions.last(_lines_1);
                lastLine.setContent(lastLinesContent);
                int _offset = lastLine.getOffset();
                int _newLineCharCount = lastLine.getNewLineCharCount();
                int _plus = _offset + _newLineCharCount;
                int newContentStartColumn = this.contentStartOffset - _plus;
                boolean _isLeadingSemanticNewLine = lastLine.isLeadingSemanticNewLine();
                if (_isLeadingSemanticNewLine && newContentStartColumn > this.contentStartColumn) {
                    int length = newContentStartColumn - this.contentStartColumn;
                    String text = this.document.substring(this.contentStartOffset - length, this.contentStartOffset);
                    SemanticWhitespace _semanticWhitespace = new SemanticWhitespace(text, newContentStartColumn);
                    this.indentationStack.push(_semanticWhitespace);
                }
                if (newContentStartColumn < this.contentStartColumn) {
                    Iterable _filter = Iterables.filter(this.indentationStack, SemanticWhitespace.class);
                    List _list = IterableExtensions.toList((Iterable)_filter);
                    for (SemanticWhitespace ws : _list) {
                        boolean _greaterThan;
                        int _column = ws.getColumn();
                        boolean bl = _greaterThan = _column > newContentStartColumn;
                        if (!_greaterThan) continue;
                        this.indentationStack.remove(ws);
                    }
                    Chunk lastWs = (Chunk)IterableExtensions.last(this.indentationStack);
                    int _xifexpression = 0;
                    if (lastWs == null) {
                        int _rootIndentLenght = this.model.getRootIndentLenght();
                        _xifexpression = newContentStartColumn - _rootIndentLenght;
                    } else {
                        int _xifexpression_1 = 0;
                        if (lastWs instanceof SemanticWhitespace) {
                            int _column_1 = ((SemanticWhitespace)lastWs).getColumn();
                            _xifexpression_1 = newContentStartColumn - _column_1;
                        } else {
                            _xifexpression_1 = 0;
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    int length_1 = _xifexpression;
                    if (length_1 > 0) {
                        String text_1 = this.document.substring(this.contentStartOffset - length_1, this.contentStartOffset);
                        SemanticWhitespace _semanticWhitespace_1 = new SemanticWhitespace(text_1, newContentStartColumn);
                        this.indentationStack.push(_semanticWhitespace_1);
                    }
                }
                if (this._outdentThisLine) {
                    boolean _not;
                    boolean _empty = this.indentationStack.empty();
                    boolean bl = _not = !_empty;
                    if (_not) {
                        this.indentationStack.pop();
                    }
                    this._outdentThisLine = false;
                }
                lastLine.setIndentLength(newContentStartColumn);
                if (newContentStartColumn != 0) {
                    this.contentStartColumn = newContentStartColumn;
                }
                List<Line> _lines_2 = this.model.getLines();
                Line _last = (Line)IterableExtensions.last(_lines_2);
                List<Chunk> _chunks = _last.getChunks();
                Iterables.addAll(_chunks, this.indentationStack);
            }
        }
        if (this.indentNextLine) {
            TemplateWhitespace _templateWhitespace = new TemplateWhitespace("");
            this.indentationStack.push(_templateWhitespace);
            this.indentNextLine = false;
        }
        this.contentStartOffset = -1;
        this.content = false;
        if (startNewLine) {
            List<Line> _lines_3 = this.model.getLines();
            Line _line = new Line(this.offset, semantic, charCount);
            _lines_3.add(_line);
        }
    }

    public void startContent() {
        if (!this.content) {
            this.contentStartOffset = this.offset;
            this.content = true;
        }
    }

    @Override
    public void acceptSemanticText(final CharSequence text, RichStringLiteral origin) {
        int _plus;
        super.acceptSemanticText(text, origin);
        if (!this.content) {
            boolean _greaterThan;
            boolean _and = false;
            int _length = text.length();
            boolean bl = _greaterThan = _length > 0;
            if (!_greaterThan) {
                _and = false;
            } else {
                int _length_1 = text.length();
                int _minus = _length_1 - 1;
                IntegerRange _upTo = new IntegerRange(0, _minus);
                Functions.Function2<Boolean, Integer, Boolean> _function = new Functions.Function2<Boolean, Integer, Boolean>(){

                    public Boolean apply(Boolean v, Integer i) {
                        char _charAt;
                        boolean _isWhitespace;
                        boolean _not;
                        boolean _or = false;
                        _or = v != false ? true : (_not = !(_isWhitespace = Character.isWhitespace(_charAt = text.charAt(i))));
                        return _or;
                    }
                };
                Boolean _fold = (Boolean)IterableExtensions.fold((Iterable)_upTo, (Object)false, (Functions.Function2)_function);
                _and = _fold;
            }
            if (_and) {
                this.startContent();
            }
        }
        int _length_2 = text.length();
        this.offset = _plus = this.offset + _length_2;
    }

    @Override
    public void acceptTemplateText(CharSequence text, RichStringLiteral origin) {
        int _plus;
        super.acceptTemplateText(text, origin);
        if (!this.content) {
            boolean _lessThan;
            int _rootIndentLenght = this.model.getRootIndentLenght();
            boolean bl = _lessThan = _rootIndentLenght < 0;
            if (_lessThan) {
                int _length_1;
                int _length = text.length();
                this.model.setRootIndentLenght(_length);
                this.contentStartColumn = _length_1 = text.length();
            }
        }
        int _length_2 = text.length();
        this.offset = _plus = this.offset + _length_2;
    }

    @Override
    public void acceptExpression(XExpression expression, CharSequence indentation) {
        super.acceptExpression(expression, indentation);
        this.startContent();
    }

    @Override
    public void acceptIfCondition(XExpression condition) {
        super.acceptIfCondition(condition);
        this.startContent();
        this.indentNextLine = true;
    }

    @Override
    public void acceptElseIfCondition(XExpression condition) {
        super.acceptElseIfCondition(condition);
        this.outdentThisLine();
        this.startContent();
        this.indentNextLine = true;
    }

    @Override
    public void acceptElse() {
        super.acceptElse();
        this.outdentThisLine();
        this.startContent();
        this.indentNextLine = true;
    }

    @Override
    public void acceptEndIf() {
        super.acceptEndIf();
        this.outdentThisLine();
        this.startContent();
    }

    @Override
    public void acceptForLoop(JvmFormalParameter parameter, XExpression expression) {
        super.acceptForLoop(parameter, expression);
        this.startContent();
        this.indentNextLine = true;
    }

    @Override
    public void acceptEndFor(XExpression after, CharSequence indentation) {
        super.acceptEndFor(after, indentation);
        this.outdentThisLine();
        this.startContent();
    }

    @Pure
    public LineModel getModel() {
        return this.model;
    }
}

