/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceToBytecodeInstaller;
import org.eclipse.xtext.generator.trace.LineMappingProvider;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.smap.SDEInstaller;
import org.eclipse.xtext.smap.SmapGenerator;
import org.eclipse.xtext.smap.SmapStratum;

public class TraceAsSmapInstaller
implements ITraceToBytecodeInstaller {
    private static final Logger log = Logger.getLogger(TraceAsSmapInstaller.class);
    @Inject
    private LineMappingProvider lineMappingProvider;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    protected String smap;

    protected String generateSmap(AbstractTraceRegion rootTraceRegion, String outputFileName) {
        List<LineMappingProvider.LineMapping> lineInfo = this.lineMappingProvider.getLineMapping(rootTraceRegion);
        if (lineInfo == null || lineInfo.isEmpty()) {
            return null;
        }
        return this.toSmap(outputFileName, lineInfo);
    }

    protected String getStratumName(SourceRelativeURI path) {
        IResourceServiceProvider provider = this.serviceProviderRegistry.getResourceServiceProvider(path.getURI());
        if (provider == null) {
            String result = path.getURI().fileExtension();
            if (result != null) {
                return result;
            }
            return "unknown";
        }
        LanguageInfo languageInfo = provider.get(LanguageInfo.class);
        String name = languageInfo.getShortName();
        return name;
    }

    @Override
    public byte[] installTrace(byte[] javaClassBytecode) throws IOException {
        if (this.smap == null) {
            return null;
        }
        byte[] updatedByteCode = new SDEInstaller(javaClassBytecode, this.smap.getBytes()).getUpdatedByteCode();
        return updatedByteCode;
    }

    @Override
    public void setTrace(String javaFileName, AbstractTraceRegion trace) {
        this.smap = this.generateSmap(trace, javaFileName);
    }

    protected String toSmap(String outputFileName, List<LineMappingProvider.LineMapping> lineInfo) {
        SmapGenerator generator = new SmapGenerator();
        generator.setOutputFileName(outputFileName);
        HashMap strata = Maps.newHashMap();
        for (LineMappingProvider.LineMapping lm : lineInfo) {
            String path;
            String stratumName = this.getStratumName(lm.source);
            if ("Java".equals(stratumName) || (path = lm.source.getURI().path()) == null) continue;
            SmapStratum stratum = (SmapStratum)strata.get(stratumName);
            if (stratum == null) {
                stratum = new SmapStratum(stratumName);
                strata.put(stratumName, stratum);
                generator.addStratum(stratum, true);
            }
            String sourceFileName = lm.source.getURI().lastSegment();
            stratum.addFile(sourceFileName, path);
            stratum.addLineData(lm.sourceStartLine, sourceFileName, 1, lm.targetStartLine + 1, lm.targetEndLine - lm.targetStartLine + 1);
        }
        return generator.getString();
    }
}

