/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclarator;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedConstructor;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
public class FinalFieldsConstructorProcessor
implements TransformationParticipant<MutableTypeParameterDeclarator> {
    public void doTransform(List<? extends MutableTypeParameterDeclarator> elements, final @Extension TransformationContext context) {
        Procedures.Procedure1<MutableTypeParameterDeclarator> _function = new Procedures.Procedure1<MutableTypeParameterDeclarator>(){

            public void apply(MutableTypeParameterDeclarator it) {
                FinalFieldsConstructorProcessor.this.transform(it, context);
            }
        };
        IterableExtensions.forEach(elements, (Procedures.Procedure1)_function);
    }

    protected void _transform(MutableClassDeclaration it, @Extension TransformationContext context) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Type _findTypeGlobally = context.findTypeGlobally(Data.class);
        AnnotationReference _findAnnotation = it.findAnnotation(_findTypeGlobally);
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        Type _findTypeGlobally_1 = context.findTypeGlobally(Accessors.class);
        AnnotationReference _findAnnotation_1 = it.findAnnotation(_findTypeGlobally_1);
        boolean bl2 = _tripleNotEquals_1 = _findAnnotation_1 != null;
        if (_tripleNotEquals_1) {
            return;
        }
        Util util = new Util(context);
        util.addFinalFieldsConstructor(it);
    }

    protected void _transform(MutableConstructorDeclaration it, @Extension TransformationContext context) {
        Util util = new Util(context);
        util.makeFinalFieldsConstructor(it);
    }

    public void transform(MutableTypeParameterDeclarator it, TransformationContext context) {
        if (it instanceof MutableConstructorDeclaration) {
            this._transform((MutableConstructorDeclaration)it, context);
            return;
        }
        if (it instanceof MutableClassDeclaration) {
            this._transform((MutableClassDeclaration)it, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, context).toString());
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;
        private static final Pattern EMPTY_BODY = Pattern.compile("(\\{(\\s*\\})?)?");

        public Util(TransformationContext context) {
            this.context = context;
        }

        public Iterable<? extends MutableFieldDeclaration> getFinalFields(MutableTypeDeclaration it) {
            Iterable _declaredFields = it.getDeclaredFields();
            Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

                public Boolean apply(MutableFieldDeclaration it) {
                    boolean _isThePrimaryGeneratedJavaElement;
                    boolean _isFinal;
                    boolean _equals;
                    boolean _and = false;
                    boolean _and_1 = false;
                    boolean _and_2 = false;
                    boolean _isStatic = it.isStatic();
                    boolean _not = !_isStatic;
                    _and_2 = !_not ? false : (_equals = (_isFinal = it.isFinal()));
                    if (!_and_2) {
                        _and_1 = false;
                    } else {
                        boolean _equals_1;
                        Expression _initializer = it.getInitializer();
                        _and_1 = _equals_1 = Objects.equal((Object)_initializer, null);
                    }
                    _and = !_and_1 ? false : (_isThePrimaryGeneratedJavaElement = Util.this.context.isThePrimaryGeneratedJavaElement((Element)it));
                    return _and;
                }
            };
            return IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function);
        }

        public boolean needsFinalFieldConstructor(MutableClassDeclaration it) {
            boolean _not;
            boolean _and = false;
            boolean _hasFinalFieldsConstructor = this.hasFinalFieldsConstructor((MutableTypeDeclaration)it);
            boolean bl = _not = !_hasFinalFieldsConstructor;
            if (!_not) {
                _and = false;
            } else {
                boolean _isEmpty;
                Element _primarySourceElement = this.context.getPrimarySourceElement((Element)it);
                Iterable _declaredConstructors = ((ClassDeclaration)_primarySourceElement).getDeclaredConstructors();
                _and = _isEmpty = IterableExtensions.isEmpty((Iterable)_declaredConstructors);
            }
            return _and;
        }

        public boolean hasFinalFieldsConstructor(MutableTypeDeclaration cls) {
            boolean _xblockexpression = false;
            final ArrayList<TypeReference> expectedTypes = this.getFinalFieldsConstructorArgumentTypes(cls);
            Iterable _declaredConstructors = cls.getDeclaredConstructors();
            Functions.Function1<MutableConstructorDeclaration, Boolean> _function = new Functions.Function1<MutableConstructorDeclaration, Boolean>(){

                public Boolean apply(MutableConstructorDeclaration it) {
                    Iterable _parameters = it.getParameters();
                    Functions.Function1<MutableParameterDeclaration, TypeReference> _function = new Functions.Function1<MutableParameterDeclaration, TypeReference>(){

                        public TypeReference apply(MutableParameterDeclaration it) {
                            return it.getType();
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
                    List _list = IterableExtensions.toList((Iterable)_map);
                    return Objects.equal((Object)_list, (Object)expectedTypes);
                }
            };
            _xblockexpression = IterableExtensions.exists((Iterable)_declaredConstructors, (Functions.Function1)_function);
            return _xblockexpression;
        }

        public ArrayList<TypeReference> getFinalFieldsConstructorArgumentTypes(MutableTypeDeclaration cls) {
            boolean _tripleNotEquals;
            ArrayList _xblockexpression = null;
            ArrayList types = CollectionLiterals.newArrayList((Object[])new TypeReference[0]);
            ResolvedConstructor _superConstructor = this.getSuperConstructor((TypeDeclaration)cls);
            boolean bl = _tripleNotEquals = _superConstructor != null;
            if (_tripleNotEquals) {
                ResolvedConstructor _superConstructor_1 = this.getSuperConstructor((TypeDeclaration)cls);
                Iterable _resolvedParameters = _superConstructor_1.getResolvedParameters();
                Functions.Function1<ResolvedParameter, TypeReference> _function = new Functions.Function1<ResolvedParameter, TypeReference>(){

                    public TypeReference apply(ResolvedParameter it) {
                        return it.getResolvedType();
                    }
                };
                Iterable _map = IterableExtensions.map((Iterable)_resolvedParameters, (Functions.Function1)_function);
                Iterables.addAll((Collection)types, (Iterable)_map);
            }
            Iterable<? extends MutableFieldDeclaration> _finalFields = this.getFinalFields(cls);
            Functions.Function1<MutableFieldDeclaration, TypeReference> _function_1 = new Functions.Function1<MutableFieldDeclaration, TypeReference>(){

                public TypeReference apply(MutableFieldDeclaration it) {
                    return it.getType();
                }
            };
            Iterable _map_1 = IterableExtensions.map(_finalFields, (Functions.Function1)_function_1);
            Iterables.addAll((Collection)types, (Iterable)_map_1);
            _xblockexpression = types;
            return _xblockexpression;
        }

        public String getConstructorAlreadyExistsMessage(MutableTypeDeclaration it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Cannot create FinalFieldsConstructor as a constructor with the signature \"new(");
            ArrayList<TypeReference> _finalFieldsConstructorArgumentTypes = this.getFinalFieldsConstructorArgumentTypes(it);
            String _join = IterableExtensions.join(_finalFieldsConstructorArgumentTypes, (CharSequence)",");
            _builder.append((Object)_join, "");
            _builder.append((Object)")\" already exists.");
            return _builder.toString();
        }

        public void addFinalFieldsConstructor(MutableClassDeclaration it) {
            ArrayList<TypeReference> _finalFieldsConstructorArgumentTypes = this.getFinalFieldsConstructorArgumentTypes((MutableTypeDeclaration)it);
            boolean _isEmpty = _finalFieldsConstructorArgumentTypes.isEmpty();
            if (_isEmpty) {
                Type _findTypeGlobally = this.context.findTypeGlobally(FinalFieldsConstructor.class);
                AnnotationReference anno = it.findAnnotation(_findTypeGlobally);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"There are no final fields, this annotation has no effect");
                this.context.addWarning((Element)anno, _builder.toString());
                return;
            }
            boolean _hasFinalFieldsConstructor = this.hasFinalFieldsConstructor((MutableTypeDeclaration)it);
            if (_hasFinalFieldsConstructor) {
                String _constructorAlreadyExistsMessage = this.getConstructorAlreadyExistsMessage((MutableTypeDeclaration)it);
                this.context.addError((Element)it, _constructorAlreadyExistsMessage);
                return;
            }
            Procedures.Procedure1<MutableConstructorDeclaration> _function = new Procedures.Procedure1<MutableConstructorDeclaration>(){

                public void apply(MutableConstructorDeclaration it) {
                    MutableTypeDeclaration _declaringType = it.getDeclaringType();
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)_declaringType);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    Util.this.makeFinalFieldsConstructor(it);
                }
            };
            it.addConstructor((Procedures.Procedure1)_function);
        }

        public void makeFinalFieldsConstructor(final MutableConstructorDeclaration it) {
            Expression _body_1;
            String _string;
            Matcher _matcher;
            boolean _matches;
            boolean _not_1;
            boolean _tripleNotEquals;
            boolean _not;
            MutableTypeDeclaration _declaringType = it.getDeclaringType();
            ArrayList<TypeReference> _finalFieldsConstructorArgumentTypes = this.getFinalFieldsConstructorArgumentTypes(_declaringType);
            boolean _isEmpty = _finalFieldsConstructorArgumentTypes.isEmpty();
            if (_isEmpty) {
                Type _findTypeGlobally = this.context.findTypeGlobally(FinalFieldsConstructor.class);
                AnnotationReference anno = it.findAnnotation(_findTypeGlobally);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"There are no final fields, this annotation has no effect");
                this.context.addWarning((Element)anno, _builder.toString());
                return;
            }
            MutableTypeDeclaration _declaringType_1 = it.getDeclaringType();
            boolean _hasFinalFieldsConstructor = this.hasFinalFieldsConstructor(_declaringType_1);
            if (_hasFinalFieldsConstructor) {
                MutableTypeDeclaration _declaringType_2 = it.getDeclaringType();
                String _constructorAlreadyExistsMessage = this.getConstructorAlreadyExistsMessage(_declaringType_2);
                this.context.addError((Element)it, _constructorAlreadyExistsMessage);
                return;
            }
            Iterable _parameters = it.getParameters();
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)_parameters);
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                this.context.addError((Element)it, "Parameter list must be empty");
            }
            boolean _and = false;
            Expression _body = it.getBody();
            boolean bl2 = _tripleNotEquals = _body != null;
            _and = !_tripleNotEquals ? false : (_not_1 = !(_matches = (_matcher = EMPTY_BODY.matcher(_string = (_body_1 = it.getBody()).toString())).matches()));
            if (_and) {
                this.context.addError((Element)it, "Body must be empty");
            }
            List _elvis = null;
            MutableTypeDeclaration _declaringType_3 = it.getDeclaringType();
            ResolvedConstructor _superConstructor = this.getSuperConstructor((TypeDeclaration)_declaringType_3);
            List _resolvedParameters = null;
            if (_superConstructor != null) {
                _resolvedParameters = _superConstructor.getResolvedParameters();
            }
            _elvis = _resolvedParameters != null ? _resolvedParameters : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ResolvedParameter[0]));
            final List superParameters = _elvis;
            Procedures.Procedure1<ResolvedParameter> _function = new Procedures.Procedure1<ResolvedParameter>(){

                public void apply(ResolvedParameter p) {
                    ParameterDeclaration _declaration = p.getDeclaration();
                    String _simpleName = _declaration.getSimpleName();
                    TypeReference _resolvedType = p.getResolvedType();
                    it.addParameter(_simpleName, _resolvedType);
                }
            };
            IterableExtensions.forEach(superParameters, (Procedures.Procedure1)_function);
            final HashMap fieldToParameter = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            MutableTypeDeclaration _declaringType_4 = it.getDeclaringType();
            Iterable<? extends MutableFieldDeclaration> _finalFields = this.getFinalFields(_declaringType_4);
            Procedures.Procedure1<MutableFieldDeclaration> _function_1 = new Procedures.Procedure1<MutableFieldDeclaration>(){

                public void apply(MutableFieldDeclaration p) {
                    p.markAsInitializedBy((ConstructorDeclaration)it);
                    String _simpleName = p.getSimpleName();
                    TypeReference _type = p.getType();
                    TypeReference _orObject = Util.this.orObject(_type);
                    MutableParameterDeclaration param = it.addParameter(_simpleName, _orObject);
                    fieldToParameter.put(p, param);
                }
            };
            IterableExtensions.forEach(_finalFields, (Procedures.Procedure1)_function_1);
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"super(");
                    Functions.Function1<ResolvedParameter, CharSequence> _function = new Functions.Function1<ResolvedParameter, CharSequence>(){

                        public CharSequence apply(ResolvedParameter it) {
                            ParameterDeclaration _declaration = it.getDeclaration();
                            return _declaration.getSimpleName();
                        }
                    };
                    String _join = IterableExtensions.join((Iterable)superParameters, (CharSequence)", ", (Functions.Function1)_function);
                    _builder.append((Object)_join, "");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    MutableTypeDeclaration _declaringType = it.getDeclaringType();
                    Iterable<? extends MutableFieldDeclaration> _finalFields = Util.this.getFinalFields(_declaringType);
                    for (MutableFieldDeclaration mutableFieldDeclaration : _finalFields) {
                        _builder.append((Object)"this.");
                        String _simpleName = mutableFieldDeclaration.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)" = ");
                        MutableParameterDeclaration _get = (MutableParameterDeclaration)fieldToParameter.get(mutableFieldDeclaration);
                        String _simpleName_1 = _get.getSimpleName();
                        _builder.append((Object)_simpleName_1, "");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                }
            };
            it.setBody(_client);
        }

        public ResolvedConstructor getSuperConstructor(TypeDeclaration it) {
            if (it instanceof ClassDeclaration) {
                TypeReference _object;
                boolean _or = false;
                TypeReference _extendedClass = ((ClassDeclaration)it).getExtendedClass();
                boolean _equals = Objects.equal((Object)_extendedClass, (Object)(_object = this.context.getObject()));
                if (_equals) {
                    _or = true;
                } else {
                    boolean _equals_1;
                    TypeReference _extendedClass_1 = ((ClassDeclaration)it).getExtendedClass();
                    _or = _equals_1 = Objects.equal((Object)_extendedClass_1, null);
                }
                if (_or) {
                    return null;
                }
                TypeReference _extendedClass_2 = ((ClassDeclaration)it).getExtendedClass();
                Iterable _declaredResolvedConstructors = _extendedClass_2.getDeclaredResolvedConstructors();
                return (ResolvedConstructor)IterableExtensions.head((Iterable)_declaredResolvedConstructors);
            }
            return null;
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _xifexpression = null;
            _xifexpression = ref == null ? this.context.getObject() : ref;
            return _xifexpression;
        }
    }
}

