/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.javaconverter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtend.ide.javaconverter.ConvertJavaCode;

public class ConvertJavaCodeHandler
extends AbstractHandler {
    @Inject
    private Provider<ConvertJavaCode> javaConverterProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Set<ICompilationUnit> compilationUnits;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection && (compilationUnits = this.getCompilationUnits(structuredSelection = (IStructuredSelection)currentSelection)).size() > 0) {
            Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            ((ConvertJavaCode)this.javaConverterProvider.get()).runJavaConverter(compilationUnits, activeShell);
        }
        return null;
    }

    private Set<ICompilationUnit> getCompilationUnits(IStructuredSelection structuredSelection) {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        for (Object element : structuredSelection.toList()) {
            IJavaElement elem;
            if (!(element instanceof IJavaElement) || !(elem = (IJavaElement)element).exists()) continue;
            this.collectCompilationUnits(elem, result);
        }
        return result;
    }

    private void collectCompilationUnits(IJavaElement elem, Set<ICompilationUnit> result) {
        try {
            switch (elem.getElementType()) {
                case 7: {
                    if (elem.getParent().getElementType() == 5) {
                        result.add((ICompilationUnit)elem.getParent());
                    }
                    break;
                }
                case 5: {
                    result.add((ICompilationUnit)elem);
                    break;
                }
                case 4: {
                    Collections.addAll(result, ((IPackageFragment)elem).getCompilationUnits());
                    break;
                }
                case 3: {
                    IJavaElement[] iJavaElementArray = ((IPackageFragmentRoot)elem).getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement child = iJavaElementArray[n2];
                        this.collectCompilationUnits(child, result);
                        ++n2;
                    }
                    break block1;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }
}

