/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing.util;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

public class AnnotatedTextToString {
    @Accessors
    private String contents;
    @Accessors
    private IFile file;
    @Accessors
    private final List<CommentedRegion> regions = CollectionLiterals.newArrayList();
    @Accessors
    private final List<String> emptyMessage = CollectionLiterals.newArrayList();

    public String getContents() {
        try {
            if (this.contents != null) {
                return this.contents;
            }
            if (this.file != null) {
                return IResourcesSetupUtil.fileToString(this.file);
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public AnnotatedTextToString withFile(IFile file) {
        this.file = file;
        return this;
    }

    public AnnotatedTextToString withMarkers(IMarker[] markers) {
        return this.withMarkers(markers, "message");
    }

    public AnnotatedTextToString withMarkers(IMarker[] markers, String ... attributes) {
        try {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                Functions.Function1 _function = it -> {
                    try {
                        Object _attribute = marker.getAttribute(it);
                        return String.valueOf(it) + "=" + _attribute;
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                String comment = IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)attributes)), (Functions.Function1)_function), (CharSequence)", ");
                Object _attribute = marker.getAttribute("charStart");
                Integer offset = (Integer)_attribute;
                Object _attribute_1 = marker.getAttribute("charEnd");
                Integer length = (Integer)_attribute_1;
                CommentedRegion _commentedRegion = new CommentedRegion(offset, length, comment);
                this.regions.add(_commentedRegion);
                ++n2;
            }
            this.emptyMessage.add("(no markers found)");
            return this;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public AnnotatedTextToString withMarkersFromFile(String type, String ... attributes) {
        try {
            return this.withMarkers(this.file.findMarkers(type, true, 2), attributes);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public AnnotatedTextToString withMarkersFromFile() {
        return this.withMarkersFromFile("org.eclipse.xtext.ui.check.fast", "message");
    }

    public String toString() {
        boolean _notEquals;
        String cnt = this.getContents();
        Functions.Function1 _function = it -> ((CommentedRegion)it).start;
        Iterable sorted = IterableExtensions.indexed((Iterable)IterableExtensions.sortBy(this.regions, (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> {
            Integer _key = (Integer)it.getKey();
            String _plus = "<" + _key;
            String _plus_1 = String.valueOf(_plus) + "<";
            Pair _mappedTo = Pair.of((Object)((CommentedRegion)it.getValue()).start, (Object)_plus_1);
            Integer _key_1 = (Integer)it.getKey();
            String _plus_2 = ">" + _key_1;
            String _plus_3 = String.valueOf(_plus_2) + ">";
            Pair _mappedTo_1 = Pair.of((Object)((CommentedRegion)it.getValue()).end, (Object)_plus_3);
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo, _mappedTo_1}));
        };
        Functions.Function1 _function_2 = it -> (Integer)it.getKey();
        List locations = IterableExtensions.sortBy((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)sorted, (Functions.Function1)_function_1)), (Functions.Function1)_function_2);
        StringBuilder result = new StringBuilder();
        int lastOffset = 0;
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray((Object)locations, Object.class)).length) {
            Pair l = (Pair)locations.get(i);
            Integer offset = (Integer)l.getKey();
            String comment = (String)l.getValue();
            result.append(cnt.substring(lastOffset, offset));
            result.append(comment);
            lastOffset = offset;
            ++i;
        }
        result.append(cnt.substring(lastOffset, cnt.length()));
        Functions.Function1 _function_3 = it -> it.length();
        Integer maxLineLenght = (Integer)IterableExtensions.max((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)result.toString().replace("\t", "    ").split("\n"))), (Functions.Function1)_function_3));
        int _length = result.length();
        int _minus = _length - 1;
        String _substring = result.substring(_minus, result.length());
        boolean bl = _notEquals = !Objects.equal((Object)_substring, (Object)"\n");
        if (_notEquals) {
            result.append("\n");
        }
        result.append(Strings.repeat((String)"-", (int)maxLineLenght));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)sorted);
        if (_isEmpty) {
            for (String c : this.emptyMessage) {
                result.append("\n");
                result.append(c);
            }
        } else {
            for (Pair c_1 : sorted) {
                result.append("\n");
                result.append(c_1.getKey());
                result.append(": ");
                result.append(((CommentedRegion)c_1.getValue()).text);
            }
        }
        return result.toString();
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    @Pure
    public IFile getFile() {
        return this.file;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    @Pure
    public List<CommentedRegion> getRegions() {
        return this.regions;
    }

    @Pure
    public List<String> getEmptyMessage() {
        return this.emptyMessage;
    }

    @FinalFieldsConstructor
    protected static class CommentedRegion {
        private final int start;
        private final int end;
        private final String text;

        public CommentedRegion(int start, int end, String text) {
            this.start = start;
            this.end = end;
            this.text = text;
        }
    }
}

