/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.List;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;

public class ExpressionAwareStackedResolvedTypes
extends StackedResolvedTypes {
    private final XExpression expression;

    protected ExpressionAwareStackedResolvedTypes(ResolvedTypes parent, XExpression expression) {
        super(parent);
        this.expression = expression;
    }

    @Override
    protected void prepareMergeIntoParent() {
        this.tryResolveUnboundReferences();
        this.mergeLocalTypes();
    }

    protected void mergeLocalTypes() {
        List<TypeData> result = this.basicGetExpressionTypes().get(this.expression);
        if (result != null && !result.isEmpty()) {
            TypeData returnTypeData = this.mergeTypeData(this.expression, result, true, true);
            TypeData actualTypeData = this.mergeTypeData(this.expression, result, false, true);
            result.clear();
            if (returnTypeData != null) {
                result.add(returnTypeData);
            }
            if (actualTypeData != null) {
                result.add(actualTypeData);
            }
        }
    }

    protected void tryResolveUnboundReferences() {
        for (UnboundTypeReference unbound : this.basicGetTypeParameters().values()) {
            if (unbound.getExpression() != this.expression) continue;
            unbound.tryResolve(false);
        }
    }
}

