/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.documentation.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.regex.Pattern;

public class AbstractMultiLineCommentProvider {
    public static final String RULE = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.ruleName";
    public static final String WS_RULE = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.ruleName";
    public static final String START_TAG = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.startTag";
    public static final String END_TAG = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.endTag";
    public static final String LINE_PREFIX = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.linePrefix";
    public static final String LINE_POSTFIX = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.linePostfix";
    public static final String WHITESPACE = "org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.whitespace";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.ruleName")
    protected String ruleName = "ML_COMMENT";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.ruleName")
    protected String wsRuleName = "WS";
    protected String startTag = "/\\*\\*?";
    protected String endTag = "\\*/";
    protected String linePrefix = "\\** ?";
    protected String linePostfix = "\\**";
    protected String whitespace = "( |\\t)*";
    protected Pattern startTagRegex;
    protected Pattern endTagRegex;
    protected Pattern linePrefixRegex;
    protected Pattern linePostfixRegex;
    protected Pattern tagsAndPrefixRegex;

    protected String getTextFromMultilineComment(String returnValue) {
        if (returnValue != null) {
            returnValue = this.startTagRegex.matcher(returnValue).replaceAll("");
            returnValue = this.endTagRegex.matcher(returnValue).replaceAll("");
            returnValue = this.linePrefixRegex.matcher(returnValue).replaceAll("");
            returnValue = this.linePostfixRegex.matcher(returnValue).replaceAll("");
            return returnValue.trim();
        }
        return null;
    }

    @Inject
    public void injectProperties(MultiLineCommentProviderProperties properties) {
        this.startTag = properties.startTag != null ? properties.startTag : this.startTag;
        this.endTag = properties.endTag != null ? properties.endTag : this.endTag;
        this.linePrefix = properties.linePrefix != null ? properties.linePrefix : this.linePrefix;
        this.linePostfix = properties.linePostfix != null ? properties.linePostfix : this.linePostfix;
        this.whitespace = properties.whitespace != null ? properties.whitespace : this.whitespace;
        this.startTagRegex = Pattern.compile("\\A" + this.startTag);
        this.endTagRegex = Pattern.compile(this.endTag + "\\z");
        this.linePrefixRegex = Pattern.compile("(?m)^" + this.whitespace + this.linePrefix);
        this.linePostfixRegex = Pattern.compile("(?m)" + this.whitespace + this.linePostfix + this.whitespace + "$");
    }

    protected static class MultiLineCommentProviderProperties {
        @Inject(optional=true)
        @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.startTag")
        protected String startTag;
        @Inject(optional=true)
        @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.endTag")
        protected String endTag;
        @Inject(optional=true)
        @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.linePrefix")
        protected String linePrefix;
        @Inject(optional=true)
        @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.linePostfix")
        protected String linePostfix;
        @Inject(optional=true)
        @Named(value="org.eclipse.xtext.ui.editor.hover.MultiLineDocumentationProvider.whitespace")
        protected String whitespace;

        protected MultiLineCommentProviderProperties() {
        }
    }
}

