/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.internal;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class AlternateJdkLoader
extends URLClassLoader {
    private final ConcurrentMap<String, Object> locks = Maps.newConcurrentMap();

    public AlternateJdkLoader(Iterable<File> files) {
        super((URL[])Conversions.unwrapArray((Object)IterableExtensions.map(files, (Functions.Function1)new Functions.Function1<File, URL>(){

            public URL apply(File it) {
                try {
                    URI _uRI = it.toURI();
                    return _uRI.toURL();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        }), URL.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> _xsynchronizedexpression = null;
        Object object = this.getClassLoadingLockJdk5(name);
        synchronized (object) {
            Class<?> _xblockexpression = null;
            Class<?> _elvis = null;
            Class<?> _findLoadedClass = this.findLoadedClass(name);
            if (_findLoadedClass != null) {
                _elvis = _findLoadedClass;
            } else {
                Class<?> _findClass = this.findClass(name);
                _elvis = _findClass;
            }
            Class<?> c = _elvis;
            if (resolve) {
                this.resolveClass(c);
            }
            _xsynchronizedexpression = _xblockexpression = c;
        }
        return _xsynchronizedexpression;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    private Object getClassLoadingLockJdk5(String className) {
        Object newLock = new Object();
        Object existingLock = this.locks.putIfAbsent(className, newLock);
        Object _elvis = null;
        _elvis = existingLock != null ? existingLock : newLock;
        return _elvis;
    }
}

