/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.quickfix;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.codebuilder.AbstractAnnotationBuilder;
import org.eclipse.xtend.ide.codebuilder.AbstractClassBuilder;
import org.eclipse.xtend.ide.codebuilder.AbstractInterfaceBuilder;
import org.eclipse.xtend.ide.codebuilder.CodeBuilderFactory;
import org.eclipse.xtend.ide.quickfix.CodeBuilderQuickfix;
import org.eclipse.xtend.ide.wizards.NewXtendAnnotationWizard;
import org.eclipse.xtend.ide.wizards.NewXtendAnnotationWizardPage;
import org.eclipse.xtend.ide.wizards.NewXtendClassWizard;
import org.eclipse.xtend.ide.wizards.NewXtendClassWizardPage;
import org.eclipse.xtend.ide.wizards.NewXtendInterfaceWizard;
import org.eclipse.xtend.ide.wizards.NewXtendInterfaceWizardPage;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.util.DisplayRunHelper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.ui.quickfix.CreateJavaTypeQuickfixes;
import org.eclipse.xtext.xbase.ui.quickfix.TypeNameGuesser;

public class CreateXtendTypeQuickfixes
extends CreateJavaTypeQuickfixes {
    @Inject
    private Provider<NewXtendClassWizard> newXtendClassWizardProvider;
    @Inject
    private Provider<NewXtendInterfaceWizard> newXtendInterfaceWizardProvider;
    @Inject
    private Provider<NewXtendAnnotationWizard> newXtendAnnotationWizardProvider;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private CodeBuilderFactory codeBuilderFactory;
    @Inject
    private CodeBuilderQuickfix codeBuilderQuickfix;
    @Inject
    private TypeNameGuesser typeNameGuesser;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter converter;

    public void addQuickfixes(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor, IXtextDocument xtextDocument, XtextResource resource, EObject referenceOwner, EReference unresolvedReference) throws Exception {
        boolean isLocal;
        String typeString = issue.getData() != null && issue.getData().length > 0 ? issue.getData()[0] : xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
        Pair packageAndType = this.typeNameGuesser.guessPackageAndTypeName(referenceOwner, typeString);
        String typeName = (String)packageAndType.getSecond();
        if (Strings.isEmpty((String)typeName)) {
            return;
        }
        String explicitPackage = (String)packageAndType.getFirst();
        boolean bl = isLocal = Strings.isEmpty((String)explicitPackage) || explicitPackage.equals(this.getPackage(resource));
        if (isLocal) {
            explicitPackage = "";
        }
        if (Strings.isEmpty((String)((String)packageAndType.getSecond()))) {
            return;
        }
        if (unresolvedReference == XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR) {
            if (((XConstructorCall)referenceOwner).getConstructor().eIsProxy() && this.isTypeMissing(referenceOwner, typeName, explicitPackage)) {
                this.newJavaClassQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                this.newXtendClassQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                if (isLocal) {
                    this.newLocalXtendClassQuickfix(typeName, resource, issue, issueResolutionAcceptor);
                }
            }
        } else if (unresolvedReference == XbasePackage.Literals.XTYPE_LITERAL__TYPE || unresolvedReference == TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE) {
            EStructuralFeature eContainingFeature = referenceOwner.eContainingFeature();
            if (eContainingFeature == XtendPackage.Literals.XTEND_CLASS__EXTENDS) {
                this.newJavaClassQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                this.newXtendClassQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                if (isLocal) {
                    this.newLocalXtendClassQuickfix(typeName, resource, issue, issueResolutionAcceptor);
                }
            } else if (eContainingFeature == XtendPackage.Literals.XTEND_CLASS__IMPLEMENTS || eContainingFeature == XtendPackage.Literals.XTEND_INTERFACE__EXTENDS) {
                this.newJavaInterfaceQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                this.newXtendInterfaceQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                if (isLocal) {
                    this.newLocalXtendInterfaceQuickfix(typeName, resource, issue, issueResolutionAcceptor);
                }
            } else {
                this.newJavaClassQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                this.newJavaInterfaceQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                this.newXtendClassQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                this.newXtendInterfaceQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
                if (isLocal) {
                    this.newLocalXtendClassQuickfix(typeName, resource, issue, issueResolutionAcceptor);
                    this.newLocalXtendInterfaceQuickfix(typeName, resource, issue, issueResolutionAcceptor);
                }
            }
        } else if (unresolvedReference == XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE) {
            this.newJavaAnnotationQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
            this.newXtendAnnotationQuickfix(typeName, explicitPackage, resource, issue, issueResolutionAcceptor);
            if (isLocal) {
                this.newLocalXtendAnnotationQuickfix(typeName, resource, issue, issueResolutionAcceptor);
            }
        }
    }

    protected boolean isTypeMissing(EObject referenceOwner, String typeName, String explicitPackage) {
        QualifiedName typeQName = !Strings.isEmpty((String)explicitPackage) ? this.converter.toQualifiedName(explicitPackage).append(typeName) : this.converter.toQualifiedName(typeName);
        IScope typeScope = this.scopeProvider.getScope(referenceOwner, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        return typeScope.getSingleElement(typeQName) == null;
    }

    protected void newLocalXtendClassQuickfix(String typeName, XtextResource resource, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        JvmDeclaredType inferredType;
        EObject eObject = resource.getEObject(issue.getUriToProblem().fragment());
        XtendTypeDeclaration xtendType = this.getAnnotationTarget(eObject);
        if (xtendType != null && (inferredType = this.associations.getInferredType(xtendType)) != null) {
            AbstractClassBuilder classBuilder = this.codeBuilderFactory.createClassBuilder(inferredType);
            classBuilder.setClassName(typeName);
            classBuilder.setVisibility(JvmVisibility.PUBLIC);
            classBuilder.setContext((EObject)xtendType);
            this.codeBuilderQuickfix.addQuickfix(classBuilder, "Create local Xtend class '" + typeName + "'", issue, issueResolutionAcceptor);
        }
    }

    protected void newLocalXtendInterfaceQuickfix(String typeName, XtextResource resource, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        JvmDeclaredType inferredType;
        EObject eObject = resource.getEObject(issue.getUriToProblem().fragment());
        XtendTypeDeclaration xtendType = this.getAnnotationTarget(eObject);
        if (xtendType != null && (inferredType = this.associations.getInferredType(xtendType)) != null) {
            AbstractInterfaceBuilder interfaceBuilder = this.codeBuilderFactory.createInterfaceBuilder(inferredType);
            interfaceBuilder.setInterfaceName(typeName);
            interfaceBuilder.setVisibility(JvmVisibility.PUBLIC);
            interfaceBuilder.setContext((EObject)xtendType);
            this.codeBuilderQuickfix.addQuickfix(interfaceBuilder, "Create local Xtend interface '" + typeName + "'", issue, issueResolutionAcceptor);
        }
    }

    protected void newLocalXtendAnnotationQuickfix(String typeName, XtextResource resource, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        JvmDeclaredType inferredType;
        EObject eObject = resource.getEObject(issue.getUriToProblem().fragment());
        XtendTypeDeclaration xtendType = this.getAnnotationTarget(eObject);
        if (xtendType != null && (inferredType = this.associations.getInferredType(xtendType)) != null) {
            AbstractAnnotationBuilder annotationBuilder = this.codeBuilderFactory.createAnnotationBuilder(inferredType);
            annotationBuilder.setAnnotationName(typeName);
            annotationBuilder.setVisibility(JvmVisibility.PUBLIC);
            annotationBuilder.setContext((EObject)xtendType);
            this.codeBuilderQuickfix.addQuickfix(annotationBuilder, "Create local Xtend annotation '@" + typeName + "'", issue, issueResolutionAcceptor);
        }
    }

    protected XtendTypeDeclaration getAnnotationTarget(EObject eObject) {
        XtendTypeDeclaration containerType = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)eObject, XtendTypeDeclaration.class);
        if (containerType != null && containerType.eContainingFeature() == XtendPackage.Literals.XTEND_MEMBER__ANNOTATION_INFO) {
            return this.getAnnotationTarget(containerType.eContainer());
        }
        return containerType;
    }

    protected void newXtendClassQuickfix(final String typeName, final String explicitPackage, final XtextResource resource, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        String packageDescription = this.getPackageDescription(explicitPackage);
        issueResolutionAcceptor.accept(issue, "Create Xtend class '" + typeName + "'" + packageDescription, "Opens the new Xtend class wizard to create the type '" + typeName + "'" + packageDescription, "xtend_file.png", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                DisplayRunHelper.runAsyncInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NewElementWizard newXtendClassWizard = (NewElementWizard)CreateXtendTypeQuickfixes.this.newXtendClassWizardProvider.get();
                        WizardDialog dialog = CreateXtendTypeQuickfixes.this.createWizardDialog(newXtendClassWizard);
                        NewXtendClassWizardPage page = (NewXtendClassWizardPage)newXtendClassWizard.getStartingPage();
                        CreateXtendTypeQuickfixes.this.configureWizardPage(page, resource.getURI(), typeName, explicitPackage);
                        dialog.open();
                    }
                });
            }
        });
    }

    protected void newXtendInterfaceQuickfix(final String typeName, final String explicitPackage, final XtextResource resource, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        String packageDescription = this.getPackageDescription(explicitPackage);
        issueResolutionAcceptor.accept(issue, "Create Xtend interface '" + typeName + "'" + packageDescription, "Opens the new Xtend interface wizard to create the type '" + typeName + "'" + packageDescription, "xtend_file.png", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                DisplayRunHelper.runAsyncInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NewElementWizard newXtendInterfaceWizard = (NewElementWizard)CreateXtendTypeQuickfixes.this.newXtendInterfaceWizardProvider.get();
                        WizardDialog dialog = CreateXtendTypeQuickfixes.this.createWizardDialog(newXtendInterfaceWizard);
                        NewXtendInterfaceWizardPage page = (NewXtendInterfaceWizardPage)newXtendInterfaceWizard.getStartingPage();
                        CreateXtendTypeQuickfixes.this.configureWizardPage(page, resource.getURI(), typeName, explicitPackage);
                        dialog.open();
                    }
                });
            }
        });
    }

    protected void newXtendAnnotationQuickfix(final String typeName, final String explicitPackage, final XtextResource resource, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        String packageDescription = this.getPackageDescription(explicitPackage);
        issueResolutionAcceptor.accept(issue, "Create Xtend annotation '" + typeName + "'" + packageDescription, "Opens the new Xtend annotation wizard to create the type '" + typeName + "'" + packageDescription, "xtend_file.png", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                DisplayRunHelper.runAsyncInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NewElementWizard newXtendAnnotationWizard = (NewElementWizard)CreateXtendTypeQuickfixes.this.newXtendAnnotationWizardProvider.get();
                        WizardDialog dialog = CreateXtendTypeQuickfixes.this.createWizardDialog(newXtendAnnotationWizard);
                        NewXtendAnnotationWizardPage page = (NewXtendAnnotationWizardPage)newXtendAnnotationWizard.getStartingPage();
                        CreateXtendTypeQuickfixes.this.configureWizardPage(page, resource.getURI(), typeName, explicitPackage);
                        dialog.open();
                    }
                });
            }
        });
    }

    protected String getPackage(XtextResource resource) {
        EObject root;
        if (!resource.getContents().isEmpty() && (root = (EObject)resource.getContents().get(0)) instanceof XtendFile) {
            return ((XtendFile)root).getPackage();
        }
        return null;
    }
}

