/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class HtmlType7Block
extends SourceBlock {
    private static final String ATTRIBUTE_VALUE_QUOTED = "\"[^\"]*\"";
    private static final String ATTRIBUTE_VALUE_SINGLEQUOTED = "'[^']*'";
    private static final String ATTRIBUTE_VALUE_UNQUOTED = "[^ \"'=<>`]+";
    private static final String ATTRIBUTE_VALUE = "(?:\"[^\"]*\"|'[^']*'|[^ \"'=<>`]+)";
    private static final String ATTRIBUTE_NAME = "[a-z_:][a-z0-9_.:-]*";
    private static final String ATTRIBUTE = "(?:[a-z_:][a-z0-9_.:-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^ \"'=<>`]+))?)";
    private static final String REPEATING_ATTRIBUTE = "(?:\\s+(?:[a-z_:][a-z0-9_.:-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^ \"'=<>`]+))?))*";
    private static final String HTML_TAG_NAME = "([a-z][a-z0-9-]*)";
    private final Pattern startPattern = Pattern.compile("\\s{0,3}<([a-z][a-z0-9-]*)(?:\\s+(?:[a-z_:][a-z0-9_.:-]*(?:\\s*=\\s*(?:\"[^\"]*\"|'[^']*'|[^ \"'=<>`]+))?))*\\s*/?>\\s*", 10);
    private final Pattern closePattern = Pattern.compile("\\s{0,3}</([a-z][a-z0-9-]*)\\s*>\\s*", 10);

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        while (line != null && !line.isEmpty()) {
            builder.charactersUnescaped(line.getText());
            builder.charactersUnescaped("\n");
            lineSequence.advance();
            line = lineSequence.getCurrentLine();
        }
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        if (line != null) {
            return this.startPattern.matcher(line.getText()).matches() || this.closePattern.matcher(line.getText()).matches();
        }
        return false;
    }
}

