/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.navigator;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.MoveResourcesDescriptor;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.edit.Q7CopyFilesAndFoldersOperation;
import org.eclipse.rcptt.ui.navigator.Q7ResourceDropAdapterAssistant;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.CopyResourcesOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.navigator.CommonDropAdapter;

public class Q7DropAdapterAssistant
extends Q7ResourceDropAdapterAssistant {
    private static final IResource[] NO_RESOURCES = new IResource[0];
    private static final String MOVE_CONTRIBUTION_ID = "org.eclipse.ltk.core.refactoring.move.resources";

    @Override
    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        return super.handleDrop(aDropAdapter, aDropTargetEvent, aTarget);
    }

    @Override
    protected Q7CopyFilesAndFoldersOperation createOperation(Shell shell) {
        return new Q7CopyFilesAndFoldersOperation(shell){

            @Override
            protected AbstractWorkspaceOperation getUndoableCopyOrMoveOperation(IResource[] resources, boolean renamed, IPath ... destinationPath) {
                if (renamed) {
                    return new CopyQ7ResourcesOperation(resources, destinationPath, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle);
                }
                return new CopyQ7ResourcesOperation(resources, destinationPath[0], IDEWorkbenchMessages.CopyFilesAndFoldersOperation_copyTitle);
            }
        };
    }

    private Refactoring createMoveRefactoring(IResource[] resources, IContainer target) throws CoreException {
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)MOVE_CONTRIBUTION_ID);
        MoveResourcesDescriptor moveDescriptor = (MoveResourcesDescriptor)contribution.createDescriptor();
        moveDescriptor.setDestination(target);
        moveDescriptor.setResourcesToMove(resources);
        return moveDescriptor.createRefactoring(new RefactoringStatus());
    }

    private boolean isMoveRefactoringRequired(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && RcpttCore.isQ7Context((IPath)resource.getFullPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class CopyQ7ResourcesOperation
    extends CopyResourcesOperation {
        private IResource[] targets;

        public CopyQ7ResourcesOperation(IResource[] resources, IPath destinationPath, String label) {
            super(resources, destinationPath, label);
        }

        public CopyQ7ResourcesOperation(IResource[] resources, IPath[] destinationPaths, String label) {
            super(resources, destinationPaths, label);
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable uiInfo) throws ExecutionException {
            IStatus result = super.execute(monitor, uiInfo);
            if (this.targets != null) {
                IResource[] iResourceArray = this.targets;
                int n = this.targets.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement file;
                    IResource target = iResourceArray[n2];
                    if (target instanceof IFile && (file = (IQ7NamedElement)RcpttCore.create((IResource)((IFile)target))) != null) {
                        try {
                            IQ7NamedElement copy = file.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                            try {
                                IQ7Folder folder = (IQ7Folder)copy.getParent();
                                do {
                                    copy.setID(EcoreUtil.generateUUID());
                                } while (folder.haveIDConflict(copy.getID()));
                                copy.setElementName(target.getFullPath().removeFileExtension().lastSegment());
                                copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                            }
                            finally {
                                copy.discardWorkingCopy();
                            }
                        }
                        catch (ModelException e) {
                            Q7UIPlugin.log(e);
                        }
                    }
                    ++n2;
                }
            }
            return result;
        }

        protected void setTargetResources(IResource[] targetResources) {
            super.setTargetResources(targetResources);
            this.targets = targetResources;
        }
    }
}

