/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.tesla.internal.ui.player.DetailUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTRecordingHelper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class WidgetDetailsProvider {
    private static final int SWTTouch = 47;
    private static final int SWTGesture = 48;
    private Map<Integer, String> eventTypes = new HashMap<Integer, String>();
    private Map<Class, List<Style>> widgetStyles = new HashMap<Class, List<Style>>();

    public WidgetDetailsProvider() {
        this.eventTypes.put(1, "KeyDown");
        this.eventTypes.put(2, "KeyUp");
        this.eventTypes.put(3, "MouseDown");
        this.eventTypes.put(4, "MouseUp");
        this.eventTypes.put(5, "MouseMove");
        this.eventTypes.put(6, "MouseEnter");
        this.eventTypes.put(7, "MouseExit");
        this.eventTypes.put(8, "MouseDoubleClick");
        this.eventTypes.put(9, "Paint");
        this.eventTypes.put(10, "Move");
        this.eventTypes.put(11, "Resize");
        this.eventTypes.put(12, "Dispose");
        this.eventTypes.put(13, "Selection");
        this.eventTypes.put(14, "DefaultSelection");
        this.eventTypes.put(15, "FocusIn");
        this.eventTypes.put(16, "FocusOut");
        this.eventTypes.put(17, "Expand");
        this.eventTypes.put(18, "Collapse");
        this.eventTypes.put(19, "Iconify");
        this.eventTypes.put(20, "Deiconify");
        this.eventTypes.put(21, "Close");
        this.eventTypes.put(22, "Show");
        this.eventTypes.put(23, "Hide");
        this.eventTypes.put(24, "Modify");
        this.eventTypes.put(25, "Verify");
        this.eventTypes.put(26, "Activate");
        this.eventTypes.put(27, "Deactivate");
        this.eventTypes.put(28, "Help");
        this.eventTypes.put(29, "DragDetect");
        this.eventTypes.put(30, "Arm");
        this.eventTypes.put(31, "Traverse");
        this.eventTypes.put(32, "MouseHover");
        this.eventTypes.put(33, "HardKeyDown");
        this.eventTypes.put(34, "HardKeyUp");
        this.eventTypes.put(35, "MenuDetect");
        this.eventTypes.put(36, "SetData");
        this.eventTypes.put(37, "MouseVerticalWheel");
        this.eventTypes.put(38, "MouseHorizontalWheel");
        this.eventTypes.put(37, "MouseWheel");
        this.eventTypes.put(39, "Settings");
        this.eventTypes.put(40, "EraseItem");
        this.eventTypes.put(41, "MeasureItem");
        this.eventTypes.put(42, "PaintItem");
        this.eventTypes.put(43, "ImeComposition");
        this.eventTypes.put(44, "OrientationChange");
        this.eventTypes.put(45, "Skin");
        this.eventTypes.put(46, "OpenDocument");
        this.eventTypes.put(47, "Touch");
        this.eventTypes.put(48, "Gesture");
        this.widgetStyles.put(Decorations.class, WidgetDetailsProvider.styles(this.style(8, "NoTrim"), this.style(64, "Close"), this.style(32, "Title"), this.style(128, "Min"), this.style(8, "NoTrim"), this.style(16384, "OnTop"), this.style(4, "Tool"), this.style(1264, "ShellTrim"), this.style(1024, "Max"), this.style(16, "Resize"), this.style(64, "Menu"), this.style(64, "Close"), this.style(0x40000000, "Transparent"), this.style(131072, "SystemModal"), this.style(65536, "ApplicationModal"), this.style(32768, "PrimaryModal")));
        this.widgetStyles.put(Shell.class, WidgetDetailsProvider.styles(this.style(0x40000000, "Transparent"), this.style(131072, "SystemModal"), this.style(65536, "ApplicationModal"), this.style(32768, "PrimaryModal")));
        this.widgetStyles.put(Button.class, WidgetDetailsProvider.styles(this.style(8, "Push"), this.style(4, "Arrow"), this.style(32, "Check"), this.style(16, "Radio"), this.style(2, "Toggle"), this.style(0x1000000, "Center"), this.style(16384, "Left"), this.style(131072, "Right"), this.style(128, "Up"), this.style(1024, "Down")));
        this.widgetStyles.put(Label.class, WidgetDetailsProvider.styles(this.style(2, "Separator"), this.style(256, "Horizontal"), this.style(512, "Vertical"), this.style(4, "ShadowIn"), this.style(8, "ShadowOut"), this.style(32, "ShadowNone"), this.style(16384, "Left"), this.style(131072, "Right"), this.style(0x1000000, "Centre"), this.style(64, "Wrap")));
        this.widgetStyles.put(CLabel.class, WidgetDetailsProvider.styles(this.style(4, "ShadowIn"), this.style(8, "ShadowOut"), this.style(32, "ShadowNone"), this.style(16384, "Left"), this.style(131072, "Right"), this.style(0x1000000, "Centre")));
        this.widgetStyles.put(Scrollable.class, WidgetDetailsProvider.styles(this.style(256, "HScroll"), this.style(512, "VScroll")));
        this.widgetStyles.put(Composite.class, WidgetDetailsProvider.styles(this.style(262144, "NoBackground"), this.style(524288, "NoFocus"), this.style(0x200000, "NoMergePaints"), this.style(0x100000, "NoRedrawResize"), this.style(0x400000, "NoRadioGroup"), this.style(0x1000000, "Embedded"), this.style(0x20000000, "DoubleBuffered")));
        this.widgetStyles.put(Control.class, WidgetDetailsProvider.styles(this.style(2048, "Border"), this.style(0x4000000, "RightToLeft")));
        this.widgetStyles.put(Table.class, WidgetDetailsProvider.styles(this.style(4, "Single"), this.style(2, "Multi"), this.style(32, "Check"), this.style(65536, "FullSelection"), this.style(32768, "HideSelection"), this.style(0x10000000, "Virtual"), this.style(16, "NoScroll")));
        this.widgetStyles.put(Tree.class, WidgetDetailsProvider.styles(this.style(4, "Single"), this.style(2, "Multi"), this.style(32, "Check"), this.style(65536, "FullSelection"), this.style(0x10000000, "Virtual"), this.style(16, "NoScroll")));
        this.widgetStyles.put(Combo.class, WidgetDetailsProvider.styles(this.style(4, "DropDown"), this.style(8, "ReadOnly"), this.style(64, "Simple")));
        this.widgetStyles.put(CCombo.class, WidgetDetailsProvider.styles(this.style(4, "DropDown"), this.style(8, "ReadOnly"), this.style(0x800000, "Flat"), this.style(64, "Simple")));
        this.widgetStyles.put(TabFolder.class, WidgetDetailsProvider.styles(this.style(128, "Top"), this.style(1024, "Bottom")));
        this.widgetStyles.put(TabFolder.class, WidgetDetailsProvider.styles(this.style(128, "Top"), this.style(64, "Close"), this.style(0x800000, "Flat"), this.style(4, "Single"), this.style(2, "Multi"), this.style(1024, "Bottom")));
        this.widgetStyles.put(Group.class, WidgetDetailsProvider.styles(this.style(16, "ShadowEtchIn"), this.style(64, "ShadowEtchOut"), this.style(4, "ShadowIn"), this.style(8, "ShadowOut"), this.style(32, "ShadowNone")));
        this.widgetStyles.put(MenuItem.class, WidgetDetailsProvider.styles(this.style(32, "Check"), this.style(64, "Cascade"), this.style(8, "Push"), this.style(16, "Radio"), this.style(2, "Separator")));
    }

    private static List<Style> styles(Style ... style) {
        return Arrays.asList(style);
    }

    private Style style(int value, String name) {
        return new Style(value, name);
    }

    public String getDetails(Widget widget, SWTUIPlayer player) {
        StringBuilder result = new StringBuilder();
        result.append("Widget information\n\n");
        this.processWidget(widget, result, player);
        if (widget instanceof TreeItem) {
            result.append("Parent tree:\n");
            this.processWidget((Widget)((TreeItem)widget).getParent(), result, player);
        }
        if (widget instanceof TableItem) {
            result.append("Parent table:\n");
            this.processWidget((Widget)((TableItem)widget).getParent(), result, player);
        }
        return result.toString();
    }

    private void processWidget(Widget widget, StringBuilder result, SWTUIPlayer player) {
        Viewer viewer;
        String textValue;
        Control ctrl;
        result.append("Class: ");
        result.append(widget.getClass().getName()).append("\n");
        result.append("\t\t\t").append(DetailUtils.extractSupers(widget.getClass())).append("\n\n");
        result.append("WidgetID: ").append(SWTRecordingHelper.getHelper().getLocator().getWidgetID(widget)).append("\n");
        int style = widget.getStyle();
        result.append("Style flags: ").append(style).append(this.tryExtractFlags(widget, style)).append("\n");
        if (widget instanceof Control) {
            ctrl = (Control)widget;
            result.append("Enabled: ").append(ctrl.isEnabled()).append("\n");
            result.append("Focused: ").append(ctrl.isFocusControl()).append("\n");
            result.append("Visible: ").append(ctrl.isVisible()).append("\n");
            result.append("Reparentable: ").append(ctrl.isReparentable()).append("\n");
        }
        if (widget instanceof ToolItem) {
            ctrl = (ToolItem)widget;
            result.append("Enabled: ").append(ctrl.isEnabled()).append("\n");
        }
        if (widget instanceof TreeItem) {
            ctrl = (TreeItem)widget;
            result.append("Grayed: ").append(ctrl.getGrayed()).append("\n");
            result.append("Checked: ").append(ctrl.getChecked()).append("\n");
            result.append("Expanded: ").append(ctrl.getExpanded()).append("\n");
        }
        if (widget instanceof TableItem) {
            ctrl = (TableItem)widget;
            result.append("Grayed: ").append(ctrl.getGrayed()).append("\n");
            result.append("Checked: ").append(ctrl.getChecked()).append("\n");
        }
        if ((textValue = PlayerTextUtils.getText((SWTUIElement)player.wrap((Object)widget))) != null) {
            result.append("Text value: ").append(textValue).append("\n");
        }
        result.append("\n");
        HashMap<Listener, HashSet<String>> listenerToTypes = new HashMap<Listener, HashSet<String>>();
        for (Integer n : this.eventTypes.keySet()) {
            Listener[] listeners = widget.getListeners(n.intValue());
            if (listeners == null || listeners.length <= 0) continue;
            Listener[] listenerArray = listeners;
            int n2 = listeners.length;
            int n3 = 0;
            while (n3 < n2) {
                Listener listener;
                Listener key = listener = listenerArray[n3];
                if (listener instanceof TypedListener) {
                    key = ((TypedListener)listener).getEventListener();
                }
                if (key != null) {
                    HashSet<String> list = (HashSet<String>)listenerToTypes.get(key);
                    if (list == null) {
                        list = new HashSet<String>();
                        listenerToTypes.put(key, list);
                    }
                    list.add("SWT." + this.eventTypes.get(n));
                }
                ++n3;
            }
        }
        if (listenerToTypes.size() > 0) {
            result.append("Registered event listeners:\n");
            for (Map.Entry entry : listenerToTypes.entrySet()) {
                Class<?> cl = entry.getKey().getClass();
                result.append("\t\tlistener class: ").append(cl.getName());
                result.append("\n\t\t\t").append(DetailUtils.extractSupers(cl));
                result.append("\n\t\t\tevents: ");
                for (String type : (Set)entry.getValue()) {
                    result.append("\n\t\t\t\t").append(type);
                }
                result.append("\n");
            }
        }
        if (widget instanceof Control && (viewer = TeslaSWTAccess.getViewer((Control)((Control)widget))) != null) {
            result.append("\nWidget has associated viewer: ").append(viewer.getClass().getName()).append("\n\t\t\t").append(DetailUtils.extractSupers(viewer.getClass())).append("\n");
            if (viewer instanceof ContentViewer) {
                IBaseLabelProvider labelProvider = ((ContentViewer)viewer).getLabelProvider();
                IContentProvider contentProvider = ((ContentViewer)viewer).getContentProvider();
                if (labelProvider != null) {
                    result.append("\tViewer Label Provider:").append("\n\t\t").append(labelProvider.getClass().getName()).append("\n\t\t\t").append(DetailUtils.extractSupers(labelProvider.getClass())).append("\n");
                }
                if (contentProvider != null) {
                    result.append("\tViewer Content Provider:").append("\n\t\t").append(contentProvider.getClass().getName()).append("\n\t\t\t").append(DetailUtils.extractSupers(contentProvider.getClass())).append("\n");
                }
            }
        }
    }

    private Object tryExtractFlags(Widget widget, int style) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Class, List<Style>> s : this.widgetStyles.entrySet()) {
            if (!s.getKey().isAssignableFrom(widget.getClass())) continue;
            List<Style> value = s.getValue();
            for (Style ss : value) {
                if ((style & ss.getValue()) == 0) continue;
                if (builder.length() > 0) {
                    builder.append("|");
                }
                builder.append(ss.getCaption());
            }
        }
        if (builder.length() > 0) {
            builder.insert(0, " (");
            builder.append(")");
        }
        return builder.toString();
    }

    private class Style {
        int value;
        String caption;

        public Style(int value, String caption) {
            this.value = value;
            this.caption = caption;
        }

        public String getCaption() {
            return this.caption;
        }

        public int getValue() {
            return this.value;
        }
    }
}

