/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.handles;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Widget;

public class HandleStore {
    private static HandleStore store = null;
    private Map<Widget, ContextManagement.Context> widgets = new WeakHashMap<Widget, ContextManagement.Context>();
    private Map<Resource, ContextManagement.Context> resources = new WeakHashMap<Resource, ContextManagement.Context>();

    public static HandleStore getStore() {
        if (store == null) {
            store = new HandleStore();
        }
        return store;
    }

    public void registerWidget(Widget widget, ContextManagement.Context context) {
        this.widgets.put(widget, context);
    }

    public void releaseWidget(Widget widget) {
    }

    public void registerResource(Resource res, ContextManagement.Context context) {
        if (context.contains("org.eclipse.jface.resource.AbstractResourceManager", "create") || context.containsClass("org.eclipse.jface.resource.FontRegistry") || context.contains("org.eclipse.swt.widgets.Display", "getSystemColor")) {
            return;
        }
        this.resources.put(res, context);
    }

    public void releaseResource(Resource res) {
        this.resources.remove(res);
    }

    public Map<Widget, ContextManagement.Context> getWidgets() {
        return new HashMap<Widget, ContextManagement.Context>(this.widgets);
    }

    public Map<Resource, ContextManagement.Context> getResources() {
        return new HashMap<Resource, ContextManagement.Context>(this.resources);
    }

    public void printInfo() {
        Integer count;
        String clName;
        Map<Widget, ContextManagement.Context> widgets = HandleStore.getStore().getWidgets();
        Map<Resource, ContextManagement.Context> ress = HandleStore.getStore().getResources();
        HashMap<String, Integer> items = new HashMap<String, Integer>();
        for (Map.Entry<Widget, ContextManagement.Context> entry : widgets.entrySet()) {
            if (entry.getKey().isDisposed()) continue;
            clName = entry.getKey().getClass().getName();
            count = (Integer)items.get(clName);
            if (count == null) {
                items.put(clName, 1);
                continue;
            }
            items.put(clName, 1 + count);
        }
        for (Map.Entry<Widget, ContextManagement.Context> entry : ress.entrySet()) {
            if (((Resource)entry.getKey()).isDisposed()) continue;
            clName = ((Resource)entry.getKey()).getClass().getName();
            count = (Integer)items.get(clName);
            if (count == null) {
                items.put(clName, 1);
                continue;
            }
            items.put(clName, 1 + count);
        }
        System.out.println("-------------------------------------------------------------------------");
        for (Map.Entry<Object, Object> entry : items.entrySet()) {
            System.out.println("class: " + (String)entry.getKey() + " instance count: " + entry.getValue());
        }
    }
}

