/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.ILog;
import org.eclipse.help.AbstractIndexProvider;
import org.eclipse.help.IIndexContribution;
import org.eclipse.help.internal.base.remote.HttpsUtility;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteIndexParser;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.index.IndexContribution;

public class RemoteIndexProvider
extends AbstractIndexProvider {
    private static final String PATH_INDEX = "/index";
    private static final String PARAM_LANG = "lang";
    private static final String PROTOCOL_HTTP = "http";

    public RemoteIndexProvider() {
        RemoteHelp.addPreferenceChangeListener(event -> this.contentChanged());
    }

    public IIndexContribution[] getIndexContributions(String locale) {
        if (RemoteHelp.isEnabled()) {
            ArrayList contributions = new ArrayList();
            PreferenceFileHandler handler = new PreferenceFileHandler();
            String[] isEnabled = handler.isEnabled();
            String[] protocol = handler.getProtocolEntries();
            String[] host = handler.getHostEntries();
            String[] port = handler.getPortEntries();
            String[] path = handler.getPathEntries();
            int ic = 0;
            while (ic < handler.getTotalRemoteInfocenters()) {
                block22: {
                    if (isEnabled[ic].equalsIgnoreCase("true")) {
                        String msg;
                        InputStream in = null;
                        try {
                            if (protocol[ic].equals(PROTOCOL_HTTP)) {
                                url = RemoteHelp.getURL(ic, "/index?lang=" + locale);
                                in = ProxyUtil.getStream(url);
                            } else {
                                url = HttpsUtility.getHttpsURL(protocol[ic], host[ic], port[ic], path[ic] + "/index?lang=" + locale);
                                in = HttpsUtility.getHttpsStream(url);
                            }
                            RemoteIndexParser parser = new RemoteIndexParser();
                            IndexContribution[] result = parser.parse(in);
                            Collections.addAll(contributions, result);
                        }
                        catch (IOException e) {
                            msg = "I/O error while trying to contact the remote help server";
                            ILog.of(((Object)((Object)this)).getClass()).error(msg, (Throwable)e);
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block22;
                        }
                        catch (Throwable t) {
                            try {
                                msg = "Internal error while reading index contents from remote server";
                                ILog.of(((Object)((Object)this)).getClass()).error(msg, t);
                                break block22;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        if (in == null) break block22;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                ++ic;
            }
            return contributions.toArray(new IIndexContribution[contributions.size()]);
        }
        return new IIndexContribution[0];
    }
}

