/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.repo;

import aQute.bnd.service.Actionable;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.Strategy;
import aQute.bnd.version.Version;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryEntry;
import org.eclipse.pde.bnd.ui.model.repo.VersionFinder;

public class RepositoryBundle
extends RepositoryEntry
implements Actionable {
    public RepositoryBundle(final RepositoryPlugin repo, final String bsn) {
        super(repo, bsn, new VersionFinder("latest", Strategy.HIGHEST){

            @Override
            Version findVersion() throws Exception {
                SortedSet vs = repo.versions(bsn);
                if (vs == null || vs.isEmpty()) {
                    return null;
                }
                return (Version)vs.last();
            }
        });
    }

    public String toString() {
        return "RepositoryBundle [repo=" + String.valueOf(this.getRepo()) + ", bsn=" + this.getBsn() + "]";
    }

    public String title(Object ... target) throws Exception {
        try {
            String s;
            if (this.getRepo() instanceof Actionable && (s = ((Actionable)this.getRepo()).title(new Object[]{this.getBsn()})) != null) {
                return s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getBsn();
    }

    public String tooltip(Object ... target) throws Exception {
        String s;
        if (this.getRepo() instanceof Actionable && (s = ((Actionable)this.getRepo()).tooltip(new Object[]{this.getBsn()})) != null) {
            return s;
        }
        return null;
    }

    public Map<String, Runnable> actions(Object ... target) throws Exception {
        Map map = null;
        try {
            if (this.getRepo() instanceof Actionable) {
                map = ((Actionable)this.getRepo()).actions(new Object[]{this.getBsn()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public String getText() {
        try {
            return this.title(new Object[0]);
        }
        catch (Exception e) {
            return this.getBsn();
        }
    }
}

