/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class PDEEditorLaunchManager {
    private static final String SETTINGS_SECTION = "PDEFormActionManager";
    private static final String SETTINGS_RECENT_LAUNCHES = "RecentLaunches";
    private static final int MAX_LAUNCHES = 3;
    private static PDEEditorLaunchManager fDefault;
    private List<String> recentLaunches;

    public static PDEEditorLaunchManager getDefault() {
        if (fDefault == null) {
            fDefault = new PDEEditorLaunchManager();
        }
        return fDefault;
    }

    public void setRecentLaunch(String id) {
        int currentIndex;
        if (this.recentLaunches == null) {
            this.initialize();
        }
        if ((currentIndex = this.recentLaunches.indexOf(id)) == -1) {
            this.recentLaunches.add(0, id);
        } else if (currentIndex != 0) {
            this.recentLaunches.remove(currentIndex);
            this.recentLaunches.add(0, id);
        }
        if (this.recentLaunches.size() > 3) {
            this.recentLaunches.remove(this.recentLaunches.size() - 1);
        }
        this.persist();
    }

    public List<String> getRecentLaunches() {
        if (this.recentLaunches == null) {
            this.initialize();
        }
        return this.recentLaunches;
    }

    private void initialize() {
        this.recentLaunches = new LinkedList<String>();
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettingsSection(SETTINGS_SECTION);
        String[] result = settings.getArray(SETTINGS_RECENT_LAUNCHES);
        if (result != null) {
            Collections.addAll(this.recentLaunches, result);
        }
    }

    private void persist() {
        if (this.recentLaunches != null) {
            IDialogSettings settings = PDEPlugin.getDefault().getDialogSettingsSection(SETTINGS_SECTION);
            String[] result = this.recentLaunches.toArray(new String[this.recentLaunches.size()]);
            settings.put(SETTINGS_RECENT_LAUNCHES, result);
        }
    }
}

