/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.core.Proc;
import org.eclipse.rcptt.ecl.core.RestoreState;
import org.eclipse.rcptt.ecl.core.SessionState;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.internal.core.DeclarationContainer;
import org.eclipse.rcptt.ecl.internal.core.GlobalService;
import org.eclipse.rcptt.ecl.internal.core.LocalProcManager;
import org.eclipse.rcptt.ecl.internal.core.ProcService;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class RestoreStateService
implements ICommandService {
    @Override
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof RestoreState)) {
            return Status.CANCEL_STATUS;
        }
        SessionState state = ((RestoreState)command).getState();
        LocalProcManager procs = ProcService.getProcs(context);
        DeclarationContainer globals = GlobalService.getGlobals(context);
        for (Proc proc : state.getProcs()) {
            procs.declare(proc);
        }
        for (Declaration decl : state.getDecls()) {
            if (!(decl instanceof Val)) continue;
            globals.declare(((Val)decl).getName(), decl);
        }
        return Status.OK_STATUS;
    }
}

