/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.protocol.ApplyCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.CheckItem;
import org.eclipse.rcptt.tesla.core.protocol.Children;
import org.eclipse.rcptt.tesla.core.protocol.Click;
import org.eclipse.rcptt.tesla.core.protocol.ClickText;
import org.eclipse.rcptt.tesla.core.protocol.Close;
import org.eclipse.rcptt.tesla.core.protocol.DoubleClick;
import org.eclipse.rcptt.tesla.core.protocol.DragCommand;
import org.eclipse.rcptt.tesla.core.protocol.DragKind;
import org.eclipse.rcptt.tesla.core.protocol.ElementCommand;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetState;
import org.eclipse.rcptt.tesla.core.protocol.GetStateResponse;
import org.eclipse.rcptt.tesla.core.protocol.HoverAtText;
import org.eclipse.rcptt.tesla.core.protocol.HoverAtTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.Parent;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.RapUploadFile;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.SetCaretPosition;
import org.eclipse.rcptt.tesla.core.protocol.SetCursorOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetFocus;
import org.eclipse.rcptt.tesla.core.protocol.SetSWTDialogInfo;
import org.eclipse.rcptt.tesla.core.protocol.SetSelection;
import org.eclipse.rcptt.tesla.core.protocol.SetStatusDialogMode;
import org.eclipse.rcptt.tesla.core.protocol.SetText;
import org.eclipse.rcptt.tesla.core.protocol.SetTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection2;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.core.protocol.TypeText;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UpdateControlCommand;
import org.eclipse.rcptt.tesla.core.protocol.WaitForRestart;
import org.eclipse.rcptt.tesla.core.protocol.WaitForState;
import org.eclipse.rcptt.tesla.core.protocol.diagram.ActivateDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CreateFigure;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureMouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandTransferKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawEvent;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;

public class BaseTeslaRecorder
extends UIPlayer {
    private ElementGenerator generator = new ElementGenerator();
    private final TeslaScenarioContainer container = new TeslaScenarioContainer();
    private List<Widget> controls;
    private final List<RawEvent> rawEvents = new ArrayList<RawEvent>();
    private static boolean rawEventsEnabled;
    private static boolean notNativeEventsIgnored;
    private String[] recordModeShortcuts;
    private String[] assertModeShortcuts;
    private String[] startRecordShortcuts;
    private String[] stopRecordShortcuts;
    private String[] replayShortcuts;
    private int replaceIndex = 0;
    private boolean skipNext = false;

    public synchronized void addRawEvent(RawEvent event) {
        if (rawEventsEnabled) {
            this.rawEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRawEventsEnabled() {
        Class<BaseTeslaRecorder> clazz = BaseTeslaRecorder.class;
        synchronized (BaseTeslaRecorder.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return rawEventsEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawEvents(boolean equals) {
        Class<BaseTeslaRecorder> clazz = BaseTeslaRecorder.class;
        synchronized (BaseTeslaRecorder.class) {
            rawEventsEnabled = equals;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotNativeEventsIgnored() {
        Class<BaseTeslaRecorder> clazz = BaseTeslaRecorder.class;
        synchronized (BaseTeslaRecorder.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return notNativeEventsIgnored;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotNativeEventsIgnored(boolean value) {
        Class<BaseTeslaRecorder> clazz = BaseTeslaRecorder.class;
        synchronized (BaseTeslaRecorder.class) {
            notNativeEventsIgnored = value;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized String[] getRecordModeShortcuts() {
        return this.recordModeShortcuts;
    }

    public synchronized String[] getAssertModeShortcuts() {
        return this.assertModeShortcuts;
    }

    public synchronized String[] getStartRecordShortcuts() {
        return this.startRecordShortcuts;
    }

    public synchronized String[] getStopRecordShortcuts() {
        return this.stopRecordShortcuts;
    }

    public synchronized String[] getReplayShortcuts() {
        return this.replayShortcuts;
    }

    public synchronized void setRecordModeShortcuts(String[] recordModeShortcuts) {
        this.recordModeShortcuts = recordModeShortcuts;
    }

    public synchronized void setAssertModeShortcuts(String[] shortcuts) {
        this.assertModeShortcuts = shortcuts;
    }

    public synchronized void setStartRecordShortcuts(String[] shortcuts) {
        this.startRecordShortcuts = shortcuts;
    }

    public synchronized void setStopRecordShortcuts(String[] shortcuts) {
        this.stopRecordShortcuts = shortcuts;
    }

    public synchronized void setReplayShortcuts(String[] shortcuts) {
        this.replayShortcuts = shortcuts;
    }

    public synchronized Response executeCommand(Command command) {
        Element element;
        ArrayList<Element> elements = new ArrayList<Element>();
        SelectResponse response = null;
        if (command instanceof SelectCommand) {
            element = this.getGenerator().generate(((SelectCommand)command).getData().getKind());
            elements.add(element);
            SelectResponse selectResponse = ProtocolFactory.eINSTANCE.createSelectResponse();
            selectResponse.getElements().add((Object)element);
            response = selectResponse;
        } else if (command instanceof Parent) {
            element = this.getGenerator().generate("parent");
            elements.add(element);
        } else if (command instanceof CreateFigure) {
            element = this.getGenerator().generate(ElementKind.DiagramFigure.name());
            elements.add(element);
        } else if (command instanceof Children) {
            element = this.getGenerator().generate(((Children)command).getElement().getKind());
            elements.add(element);
        } else if (command instanceof ActivateDirectEdit) {
            element = this.getGenerator().generate("control");
            elements.add(element);
        } else if (command instanceof GetState) {
            element = this.getGenerator().generate("State");
            elements.add(element);
            GetStateResponse getStateResponse = ProtocolFactory.eINSTANCE.createGetStateResponse();
            getStateResponse.setState(element);
            response = getStateResponse;
        }
        CommandTransferKind transferKind = this.getTransferKind(command);
        this.container.processTransfer(command, elements, transferKind, this.controls, this.replaceIndex, this.rawEvents);
        this.hookExecuteCommand(command, elements, transferKind, this.controls, this.replaceIndex, this.rawEvents);
        this.controls = null;
        this.rawEvents.clear();
        return response;
    }

    private CommandTransferKind getTransferKind(Command command) {
        CommandTransferKind transferKind = CommandTransferKind.DEFAULT;
        this.replaceIndex = 0;
        if (!this.container.isEmpty() && this.isReplacable(command)) {
            Command last = this.container.getLastCommand();
            this.skipNext = false;
            if (command instanceof FigureMouseCommand) {
                transferKind = this.getKindForFigureMouseCommand((FigureMouseCommand)command, transferKind);
            }
            if (this.isReplacable(last, command) && !this.skipNext) {
                transferKind = CommandTransferKind.REPLACE_PREVIOUS;
            }
        }
        if (command instanceof SetStatusDialogMode && ((SetStatusDialogMode)command).isEnabled() || command instanceof SetSWTDialogInfo || command instanceof RapUploadFile) {
            transferKind = CommandTransferKind.INSERT_BEFORE_ESSENTIAL_COMMAND;
        } else if (command instanceof UpdateControlCommand) {
            transferKind = CommandTransferKind.REMOVE;
        }
        return transferKind;
    }

    private CommandTransferKind getKindForFigureMouseCommand(FigureMouseCommand command, CommandTransferKind transferKind) {
        if (command.getKind().equals((Object)MouseCommandKind.DOWN)) {
            int skip = 0;
            while (this.container.size() - (1 + skip) >= 0) {
                Command ncmd = this.container.getLastCommand(1 + skip);
                if (!(ncmd instanceof FigureMouseCommand) || !((FigureMouseCommand)ncmd).getKind().equals((Object)MouseCommandKind.DRAG)) break;
                ++skip;
            }
            if (skip > 0) {
                this.skipNext = true;
                transferKind = CommandTransferKind.INSERT_BEFORE;
                this.replaceIndex = skip;
            }
        }
        return transferKind;
    }

    public synchronized void setControls(Widget ... controls) {
        this.controls = controls.length > 0 ? new ArrayList<Widget>(Arrays.asList(controls)) : null;
    }

    public synchronized List<Widget> getControls() {
        ArrayList<Widget> result = new ArrayList<Widget>();
        if (this.controls != null) {
            result.addAll(this.controls);
        }
        return result;
    }

    private boolean isReplacable(Command current) {
        return current instanceof SetSelection && !TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.record.all.selections") || current instanceof SetText || current instanceof MouseCommand || current instanceof DragCommand || current instanceof CheckItem || current instanceof Close || current instanceof TypeText || current instanceof FigureMouseCommand || current instanceof ApplyCellEditor || current instanceof SetTextOffset || current instanceof SetCaretPosition || current instanceof SetCursorOffset || current instanceof DragCommand || current instanceof DoubleClick || current instanceof WaitForRestart || current instanceof SetTextSelection || current instanceof SetTextSelection2 || current instanceof HoverAtText || current instanceof HoverAtTextOffset || current instanceof Type || current instanceof ClickText || current instanceof SetFocus || current instanceof SelectCommand;
    }

    private synchronized boolean isReplacable(Command last, Command newCommand) {
        MouseCommand newCmd;
        MouseCommand lastCmd;
        String lastKind;
        Element element;
        Element lastElement;
        boolean equals = last.eClass().equals(newCommand.eClass());
        boolean ecoreEquals = false;
        if (newCommand instanceof WaitForRestart && last instanceof WaitForState) {
            return true;
        }
        if (last instanceof ElementCommand && newCommand instanceof ElementCommand && EcoreUtil.equals((EObject)(lastElement = ((ElementCommand)last).getElement()), (EObject)(element = ((ElementCommand)newCommand).getElement()))) {
            ecoreEquals = true;
        }
        if (last instanceof SetFocus) {
            if (newCommand instanceof SetFocus) {
                return ecoreEquals;
            }
            if (newCommand instanceof ClickText) {
                return ecoreEquals;
            }
        }
        if (last instanceof ClickText && newCommand instanceof SetText && ecoreEquals) {
            return true;
        }
        if (newCommand instanceof Type && last instanceof Type && ecoreEquals) {
            Type newTypeCmd = (Type)newCommand;
            Type lastTypeCmd = (Type)last;
            int tempTimes = newTypeCmd.getTimes();
            newTypeCmd.setTimes(lastTypeCmd.getTimes());
            if (EcoreUtil.equals((EObject)lastTypeCmd, (EObject)newTypeCmd)) {
                newTypeCmd.setTimes(Integer.valueOf(lastTypeCmd.getTimes() + 1));
                return true;
            }
            newTypeCmd.setTimes(Integer.valueOf(tempTimes));
            return false;
        }
        if (newCommand instanceof SetTextSelection && last instanceof SetTextSelection) {
            return ecoreEquals;
        }
        if (newCommand instanceof SetTextSelection2 && last instanceof SetTextSelection2) {
            return ecoreEquals;
        }
        if (last instanceof Click && newCommand instanceof Click && ((lastKind = ((Click)last).getElement().getKind()).equals(ElementKind.View.name()) || lastKind.equals(ElementKind.Editor.name()))) {
            return ecoreEquals;
        }
        if (last instanceof Click && ((Click)last).isDefault() && newCommand instanceof DoubleClick) {
            return ecoreEquals;
        }
        if (newCommand instanceof DoubleClick) {
            return false;
        }
        if (last instanceof ApplyCellEditor && newCommand instanceof ApplyCellEditor) {
            return ecoreEquals;
        }
        if (equals && last instanceof MouseCommand) {
            lastCmd = (MouseCommand)last;
            newCmd = (MouseCommand)newCommand;
            equals = lastCmd.getKind().equals((Object)newCmd.getKind());
            if (lastCmd.getKind().equals((Object)MouseCommandKind.DRAG)) {
                return false;
            }
            if (lastCmd.getKind().equals((Object)MouseCommandKind.MOVE)) {
                return this.isReplacable(last) && this.isReplacable(newCommand) && equals;
            }
        }
        if (equals && last instanceof FigureMouseCommand) {
            lastCmd = (FigureMouseCommand)last;
            newCmd = (FigureMouseCommand)newCommand;
            equals = lastCmd.getKind().equals((Object)newCmd.getKind());
            if (equals && lastCmd.getKind().equals((Object)MouseCommandKind.DRAG)) {
                return true;
            }
            if (lastCmd.getKind().equals((Object)MouseCommandKind.MOVE)) {
                return this.isReplacable(last) && this.isReplacable(newCommand) && equals;
            }
        }
        if (equals && ecoreEquals && last instanceof CheckItem) {
            CheckItem ci1 = (CheckItem)last;
            CheckItem ci2 = (CheckItem)newCommand;
            EList p1 = ci1.getPath();
            EList p2 = ci2.getPath();
            if (p1.size() != p2.size()) {
                return false;
            }
            int i = 0;
            while (i < p1.size()) {
                if (!((String)p1.get(i)).equals(p2.get(i))) {
                    return false;
                }
                ++i;
            }
            return ci1.isState() == ci2.isState();
        }
        if (equals && ecoreEquals && last instanceof TypeText) {
            TypeText t1 = (TypeText)last;
            TypeText t2 = (TypeText)newCommand;
            t2.setText(t1.getText() + t2.getText());
            return true;
        }
        if (last instanceof DragCommand && newCommand instanceof DragCommand) {
            DragCommand lastDrag = (DragCommand)last;
            DragCommand newDrag = (DragCommand)newCommand;
            return lastDrag.getKind().equals((Object)newDrag.getKind()) && newDrag.getKind().equals((Object)DragKind.OVER);
        }
        return this.isReplacable(last) && this.isReplacable(newCommand) && equals && ecoreEquals;
    }

    protected void hookExecuteCommand(Command command, List<Element> elements, CommandTransferKind kind, List<Widget> controls, int index, List<RawEvent> rawEvents) {
    }

    public ElementGenerator getGenerator() {
        return this.generator;
    }

    public synchronized void clear() {
        this.container.clear();
        this.controls = null;
        this.rawEvents.clear();
    }

    public void generatorsClear() {
        this.generator = new ElementGenerator();
    }

    public TeslaScenarioContainer getContainer() {
        return this.container;
    }

    public void removeLast() {
        this.container.removeLast();
        this.hookExecuteCommand(null, null, CommandTransferKind.REPLACE_PREVIOUS, null, 0, null);
    }

    public void remove(int index) {
        this.container.remove(index);
        this.hookExecuteCommand(null, null, CommandTransferKind.REMOVE, null, index, null);
    }
}

