/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        super(cArray, pGPDigestCalculator);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray) {
        this(cArray, new SHA1PGPDigestCalculator());
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        super(cArray, pGPDigestCalculator, n);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray, int n) {
        super(cArray, new SHA1PGPDigestCalculator(), n);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        super(cArray, argon2Params);
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    @Override
    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        super.setSecureRandom(secureRandom);
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            String string = PGPUtil.getSymmetricCipherName(n);
            Cipher cipher = this.helper.createCipher(string + "/CFB/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, PGPUtil.getSymmetricCipherName(n));
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
            return cipher.doFinal(byArray2, 0, byArray2.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PGPException("IV invalid: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
    }

    @Override
    protected byte[] generateV6KEK(int n, byte[] byArray, byte[] byArray2) {
        return JceAEADUtil.generateHKDFBytes(byArray, null, byArray2, SymmetricKeyUtils.getKeyLengthInOctets(n));
    }

    @Override
    protected byte[] getEskAndTag(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws PGPException {
        String string = JcePBEKeyEncryptionMethodGenerator.getBaseAEADAlgorithm(n);
        Cipher cipher = this.createAEADCipher(string, n2);
        try {
            cipher.init(1, (Key)new SecretKeySpec(byArray2, string), (AlgorithmParameterSpec)new AEADParameterSpec(byArray3, 128, byArray4));
            int n3 = cipher.getOutputSize(byArray.length);
            byte[] byArray5 = new byte[n3];
            int n4 = cipher.update(byArray, 0, byArray.length, byArray5, 0);
            n4 += cipher.doFinal(byArray5, n4);
            if (n4 < byArray5.length) {
                byte[] byArray6 = new byte[n4];
                System.arraycopy(byArray5, 0, byArray6, 0, n4);
                return byArray6;
            }
            return byArray5;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot encrypt session info", generalSecurityException);
        }
    }

    private static String getBaseAEADAlgorithm(int n) throws PGPException {
        if (n == 7 || n == 8 || n == 9) {
            return "AES";
        }
        if (n == 11 || n == 12 || n == 13) {
            return "Camellia";
        }
        throw new PGPException("AEAD only supported for AES and Camellia based algorithms");
    }

    private Cipher createAEADCipher(String string, int n) throws PGPException {
        switch (n) {
            case 1: {
                return this.helper.createCipher(string + "/EAX/NoPadding");
            }
            case 2: {
                return this.helper.createCipher(string + "/OCB/NoPadding");
            }
            case 3: {
                return this.helper.createCipher(string + "/GCM/NoPadding");
            }
        }
        throw new PGPException("unrecognised AEAD algorithm: " + n);
    }
}

