/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol.raw;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResponseStatus implements Enumerator
{
    OK(0, "Ok", "Ok"),
    FAILED(1, "Failed", "Failed");

    public static final int OK_VALUE = 0;
    public static final int FAILED_VALUE = 1;
    private static final ResponseStatus[] VALUES_ARRAY;
    public static final List<ResponseStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResponseStatus[]{OK, FAILED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResponseStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResponseStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResponseStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResponseStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResponseStatus get(int value) {
        switch (value) {
            case 0: {
                return OK;
            }
            case 1: {
                return FAILED;
            }
        }
        return null;
    }

    private ResponseStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

