/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.resources.undo.snapshot.ResourceSnapshotFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.ltk.core.refactoring.Change;

public class UndoablePackageDeleteChange
extends DynamicValidationStateChange {
    private final List<IResource> fPackageDeletes;

    public UndoablePackageDeleteChange(String name, List<IResource> packageDeletes) {
        super(name);
        this.fPackageDeletes = packageDeletes;
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        int count = this.fPackageDeletes.size();
        pm.beginTask("", count * 3);
        ArrayList<IResourceSnapshot> snapshots = new ArrayList<IResourceSnapshot>();
        int i = 0;
        while (i < this.fPackageDeletes.size()) {
            IResource resource = this.fPackageDeletes.get(i);
            snapshots.add(ResourceSnapshotFactory.fromResource((IResource)resource));
            pm.worked(1);
            ++i;
        }
        DynamicValidationStateChange result = (DynamicValidationStateChange)super.perform((IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)count));
        int i2 = 0;
        while (i2 < this.fPackageDeletes.size()) {
            IResourceSnapshot resourceDescription = (IResourceSnapshot)snapshots.get(i2);
            resourceDescription.recordStateFromHistory((IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)1));
            result.add(new UndoDeleteResourceChange((IResourceSnapshot<? extends IResource>)resourceDescription));
            ++i2;
        }
        return result;
    }
}

