/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document.ui;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.kitalpha.doc.doc2model.core.Doc2Model;
import org.polarsys.reqcycle.inittypes.inittypes.FileType;
import org.polarsys.reqcycle.inittypes.inittypes.Type;
import org.polarsys.reqcycle.repository.connector.document.DocConnector;
import org.polarsys.reqcycle.repository.connector.document.DocUtils;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractSettingPage;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractStorageBean;

public class DocSettingPage
extends AbstractSettingPage {
    private DocConnector.DOCSettingBean bean;
    private Combo cTypeFile;
    private Text txtSelectedDoc;
    private Button btnBrowseDoc;
    private List<FileType> listFileTypeInWorkspace = null;
    private ComboViewer cvTypeFile;

    public DocSettingPage(DocConnector.DOCSettingBean bean) {
        super("Document Connector settings", (AbstractStorageBean)bean);
        this.setTitle("Connector DOCUMENT: settings page");
        this.bean = bean;
    }

    protected void doSpecificInitDataBindings(DataBindingContext bindingContext) {
        ISWTObservableValue observeTextTxtSelectedDocObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtSelectedDoc);
        IObservableValue uriBeanObserveValue = PojoProperties.value((String)"uri").observe((Object)this.bean);
        bindingContext.bindValue((IObservableValue)observeTextTxtSelectedDocObserveWidget, uriBeanObserveValue, null, null);
        IViewerObservableValue observeSingleSelectionCvTypeFile = ViewerProperties.singleSelection().observe((Viewer)this.cvTypeFile);
        IObservableValue listTypeBeanObserveValue = PojoProperties.value((String)"fileType").observe((Object)this.bean);
        bindingContext.bindValue((IObservableValue)observeSingleSelectionCvTypeFile, listTypeBeanObserveValue, null, null);
    }

    protected Composite doCreateSpecific(Composite parent) {
        Composite compositeContainer = parent;
        compositeContainer.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)compositeContainer);
        Label lblDocFile = new Label(compositeContainer, 0);
        lblDocFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblDocFile.setText("Document :");
        this.txtSelectedDoc = new Text(compositeContainer, 2048);
        this.txtSelectedDoc.setEnabled(false);
        this.txtSelectedDoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnBrowseDoc = new Button(compositeContainer, 0);
        this.btnBrowseDoc.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnBrowseDoc.setText("Browse");
        Label lbltypeFile = new Label(compositeContainer, 0);
        lbltypeFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lbltypeFile.setText(".types file");
        this.cvTypeFile = new ComboViewer(compositeContainer, 8);
        this.cTypeFile = this.cvTypeFile.getCombo();
        this.cTypeFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.cvTypeFile.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvTypeFile.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof FileType) {
                    return ((FileType)element).getName();
                }
                return super.getText(element);
            }
        });
        this.listFileTypeInWorkspace = DocUtils.getAllFilesInProject();
        this.cvTypeFile.setInput(this.listFileTypeInWorkspace);
        return compositeContainer;
    }

    protected void hookListeners() {
        super.hookListeners();
        this.getDestinationFileSelectionListener();
        this.btnBrowseDoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List uris;
                ResourceDialog dialog = new ResourceDialog(DocSettingPage.this.getShell(), "Select a document", 0);
                if (dialog.open() == 0 && !(uris = dialog.getURIs()).isEmpty()) {
                    Doc2Model doc2Model = new Doc2Model();
                    String fileString = CommonPlugin.asLocalURI((URI)((URI)uris.get(0))).toFileString();
                    String fileType = doc2Model.getFileType(fileString);
                    if (fileType != null && fileType.toString() != null) {
                        DocSettingPage.this.txtSelectedDoc.setText(((URI)uris.get(0)).toString());
                    } else {
                        DocSettingPage.this.txtSelectedDoc.setText("");
                        DocSettingPage.this.setErrorMessage("Your document is not supported. Retry and choose document file");
                    }
                }
            }
        });
        this.cvTypeFile.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof FileType) {
                    List<Type> types = DocUtils.getListTypes(((FileType)obj).getName());
                    DocSettingPage.this.bean.setListType(types);
                }
            }
        });
    }

    public boolean isPageComplete() {
        boolean result = super.isPageComplete();
        String msg = this.getErrorMessage();
        if (msg == null) {
            msg = "";
        }
        if (this.txtSelectedDoc.getText() == null || this.txtSelectedDoc.getText() == "") {
            result = false;
            msg = String.valueOf(msg) + "Choose a document Input\n";
        }
        if (!result) {
            this.setErrorMessage(msg);
        }
        return result;
    }
}

