/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export.transform;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.osgi.framework.FrameworkUtil;
import org.polarsys.reqcycle.export.model.ReqCycleExport.Attribute;
import org.polarsys.reqcycle.export.model.ReqCycleExport.AttributeValue;
import org.polarsys.reqcycle.export.model.ReqCycleExport.Export;
import org.polarsys.reqcycle.export.model.ReqCycleExport.Model;
import org.polarsys.reqcycle.export.model.ReqCycleExport.Property;
import org.polarsys.reqcycle.export.model.ReqCycleExport.ReqCycleExportFactory;
import org.polarsys.reqcycle.export.model.ReqCycleExport.Traceability;
import org.polarsys.reqcycle.export.transform.IRequirementProvider;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.Scopes;
import org.polarsys.reqcycle.traceability.types.ITraceabilityAttributesManager;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.engine.ITypedTraceabilityEngine;
import org.polarsys.reqcycle.traceability.utils.EngineUtils;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityExport {
    IReachableManager manager = (IReachableManager)ZigguratInject.make(IReachableManager.class);
    ITraceabilityEngine engine = (ITraceabilityEngine)ZigguratInject.make(ITraceabilityEngine.class);
    ITypedTraceabilityEngine typedEngine = (ITypedTraceabilityEngine)ZigguratInject.make(ITypedTraceabilityEngine.class);
    ReqCycleExportFactory factory = ReqCycleExportFactory.eINSTANCE;
    ITraceabilityAttributesManager attributesManager = (ITraceabilityAttributesManager)ZigguratInject.make(ITraceabilityAttributesManager.class);
    ITypesConfigurationProvider typeProvider = (ITypesConfigurationProvider)ZigguratInject.make(ITypesConfigurationProvider.class);

    public Export transform(Iterable<IRequirementProvider> reqResult, Iterable<IPredicate> predicateResult, List<IProject> projects, boolean exportTraceability, String outputPath, IProgressMonitor monitor) {
        Multimap traceaMap = null;
        if (exportTraceability) {
            Request request = this.getRequest(reqResult, projects);
            try {
                Iterator traca = this.getEngine().getTraceability(new Request[]{request});
                traceaMap = EngineUtils.toFollowingMap((Iterator)traca);
            }
            catch (EngineException e) {
                e.printStackTrace();
            }
        }
        Export export = this.factory.createExport();
        export.setPath(outputPath);
        Date date = new Date();
        DateFormat shortDateFormat = DateFormat.getDateTimeInstance(3, 3);
        export.setDate(shortDateFormat.format(date));
        monitor.beginTask("Extraction", Lists.newArrayList(reqResult).size());
        for (IRequirementProvider iRequirementProvider : reqResult) {
            if (monitor.isCanceled()) {
                return null;
            }
            ArrayList attributes = Lists.newArrayList();
            this.initAttributes(attributes);
            ArrayList predicateAttributes = Lists.newArrayList();
            ArrayList tracea = Lists.newArrayList();
            this.initPredicatesattributes(predicateAttributes, predicateResult);
            Model m = this.initModel();
            m.setName(iRequirementProvider.getLabel());
            for (Map.Entry<String, String> entry : iRequirementProvider.getMetadata().entrySet()) {
                Property uriProperty = this.factory.createProperty();
                uriProperty.setName(entry.getKey());
                uriProperty.setValue(entry.getValue());
                m.getMetadata().add((Object)uriProperty);
            }
            for (Requirement r : iRequirementProvider.getRequirements()) {
                org.polarsys.reqcycle.export.model.ReqCycleExport.Requirement reqCopy = this.factory.createRequirement();
                reqCopy.setID(r.getId());
                this.handleSection(attributes, r, reqCopy);
                this.handleEAttributes(attributes, r, reqCopy);
                this.handlePredicates(predicateResult, predicateAttributes, r, reqCopy);
                if (traceaMap != null) {
                    this.handleTracea((Multimap<Reachable, Link>)traceaMap, r, tracea, reqCopy);
                }
                m.getRequirements().add((Object)reqCopy);
            }
            m.getAttributes().addAll((Collection)attributes);
            m.getAttributes().addAll((Collection)predicateAttributes);
            m.getAttributes().addAll((Collection)tracea);
            export.getModels().add((Object)m);
            monitor.worked(1);
        }
        return export;
    }

    private void handleSection(List<Attribute> attributes, Requirement r, org.polarsys.reqcycle.export.model.ReqCycleExport.Requirement reqCopy) {
        AttributeValue val = this.factory.createAttributeValue();
        val.setValue(this.getSection(r));
        val.setAttribute(this.getAttribute(attributes, "section", String.class.getName()));
        reqCopy.getValues().add((Object)val);
    }

    private String getSection(Requirement r) {
        ArrayList result = Lists.newArrayList();
        EObject parent = r.eContainer();
        while (parent != null && !(parent instanceof RequirementsContainer)) {
            if (!(parent instanceof Section)) continue;
            Section section = (Section)parent;
            result.add(section.getId());
            parent = parent.eContainer();
        }
        return Joiner.on((String)"\\").join((Iterable)result);
    }

    protected void handleTracea(Multimap<Reachable, Link> traceaMap, Requirement r, List<Attribute> tracea, org.polarsys.reqcycle.export.model.ReqCycleExport.Requirement reqCopy) {
        Collection links = traceaMap.get((Object)this.getReachable(r));
        for (Link l : links) {
            Traceability t = this.factory.createTraceability();
            Attribute attribute = this.getAttribute(tracea, l.getLabel(), String.class.getName());
            AttributeValue val = this.factory.createAttributeValue();
            val.setValue(this.getLabel((Reachable)l.getTargets().iterator().next()));
            val.setAttribute(attribute);
            t.getTraceabilityValues().add((Object)val);
            Collection attributeOfLink = this.attributesManager.getAttributes(l.getId());
            for (ITraceabilityAttributesManager.EditableAttribute a : attributeOfLink) {
                Attribute att = this.getAttribute(tracea, a.getName(), a.getType().getName());
                AttributeValue value = this.factory.createAttributeValue();
                value.setValue(this.valueOf(a.getValue()));
                value.setAttribute(att);
                t.getTraceabilityValues().add((Object)value);
            }
            reqCopy.getDownwardTraceability().add((Object)t);
        }
    }

    protected String valueOf(Object object) {
        if (object != null) {
            return String.valueOf(object);
        }
        return "";
    }

    protected void handlePredicates(Iterable<IPredicate> predicateResult, List<Attribute> predicateAttributes, Requirement r, org.polarsys.reqcycle.export.model.ReqCycleExport.Requirement reqCopy) {
        for (IPredicate p : predicateResult) {
            AttributeValue val = this.factory.createAttributeValue();
            val.setAttribute(this.getAttribute(predicateAttributes, p.getDisplayName(), Boolean.class.getName()));
            try {
                val.setValue(this.valueOf(p.match((Object)r)));
            }
            catch (Exception exception) {
                val.setValue("error");
            }
            reqCopy.getValues().add((Object)val);
        }
    }

    protected void handleEAttributes(List<Attribute> attributes, Requirement r, org.polarsys.reqcycle.export.model.ReqCycleExport.Requirement reqCopy) {
        for (EAttribute att : r.eClass().getEAllAttributes()) {
            if ("uri".equals(att.getName()) || "id".equals(att.getName())) continue;
            Attribute attribute = this.getAttribute(attributes, att.getName(), att.getEType().getInstanceClassName());
            AttributeValue attributeValue = this.factory.createAttributeValue();
            attributeValue.setValue(this.valueOf(r.eGet((EStructuralFeature)att)));
            attributeValue.setAttribute(attribute);
            reqCopy.getValues().add((Object)attributeValue);
        }
    }

    private ITraceabilityEngine getEngine() {
        Configuration defaultConfiguration = this.typeProvider.getDefaultConfiguration();
        if (defaultConfiguration != null) {
            return this.typedEngine;
        }
        return this.engine;
    }

    private Attribute getAttribute(List<Attribute> attributes, String name, String type) {
        for (Attribute att : attributes) {
            if (!att.getName().equals(name)) continue;
            return att;
        }
        Attribute newAtt = this.factory.createAttribute();
        newAtt.setName(name);
        newAtt.setType(type);
        attributes.add(newAtt);
        return newAtt;
    }

    private void initPredicatesattributes(List<Attribute> predicateAttributes, Iterable<IPredicate> predicateResult) {
        for (IPredicate p : predicateResult) {
            Attribute Att = this.factory.createAttribute();
            Att.setName(p.getDisplayName());
        }
    }

    private void initAttributes(List<Attribute> attributes) {
        Attribute att = this.factory.createAttribute();
        att.setName("text");
        attributes.add(att);
        Attribute section = this.factory.createAttribute();
        section.setName("section");
        attributes.add(section);
    }

    private Model initModel() {
        Model model = this.factory.createModel();
        model.setVersion(FrameworkUtil.getBundle(this.getClass()).getVersion().toString());
        return model;
    }

    private Request getRequest(Iterable<IRequirementProvider> reqResult, List<IProject> projects) {
        Request r = new Request();
        r.setDirection(ITraceabilityEngine.DIRECTION.DOWNWARD);
        r.setDepth(Request.DEPTH.ONE);
        if (projects.size() == ResourcesPlugin.getWorkspace().getRoot().getProjects().length) {
            r.setScope(Scopes.getWorkspaceScope());
        } else {
            CompositeScope compo = new CompositeScope();
            for (IProject p : projects) {
                compo.add(Scopes.getProjectScope((IResource)p));
            }
            r.setScope((IScope)compo);
        }
        for (IRequirementProvider p : reqResult) {
            for (Requirement req : p.getRequirements()) {
                r.addSource(this.getReachable(req));
            }
        }
        return r;
    }

    private Reachable getReachable(Requirement req) {
        try {
            return this.manager.getHandlerFromObject((Object)req).getFromObject((Object)req).getReachable();
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getLabel(Reachable reachable) {
        try {
            ILabelProvider provider;
            ReachableObject fromReachable = this.manager.getHandlerFromReachable(reachable).getFromReachable(reachable);
            if (fromReachable != null && (provider = (ILabelProvider)fromReachable.getAdapter(ILabelProvider.class)) != null) {
                return provider.getText((Object)reachable);
            }
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
        }
        return "no label";
    }
}

