/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.builder.impl;

import java.util.ArrayDeque;
import javax.inject.Inject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.reqcycle.traceability.builder.IBuildingTraceabilityEngine;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.builder.exceptions.BuilderException;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.utils.ReachableUtils;

public class ResourceDeltaBuilderVisitor
implements IResourceDeltaVisitor,
IResourceVisitor {
    @Inject
    ITraceabilityBuilder builder;
    @Inject
    IReachableManager manager;
    @Inject
    ITraceabilityEngine engine;
    private IProgressMonitor monitor;
    private boolean forceBuild;
    private ArrayDeque<Reachable> toBuild = new ArrayDeque();

    public ResourceDeltaBuilderVisitor(IProgressMonitor monitor, boolean forceBuild) {
        this.monitor = monitor;
        this.forceBuild = forceBuild;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource res = delta.getResource();
        return this.doVisit(res);
    }

    private boolean doVisit(IResource res) {
        if (!(res instanceof IContainer)) {
            if (this.engine instanceof IBuildingTraceabilityEngine) {
                Reachable reachable = ReachableUtils.getReachable((IResource)res);
                if (reachable != null) {
                    this.toBuild.add(reachable);
                }
            } else {
                return false;
            }
        }
        return !this.monitor.isCanceled();
    }

    public void build() throws BuilderException {
        IBuildingTraceabilityEngine callBack = null;
        if (this.engine instanceof IBuildingTraceabilityEngine) {
            this.monitor.beginTask("Traceability Build", this.toBuild.size());
            callBack = (IBuildingTraceabilityEngine)this.engine;
            for (Reachable r : this.toBuild) {
                if (this.monitor.isCanceled()) break;
                this.monitor.subTask(r.toString());
                this.builder.build(r, callBack, this.forceBuild);
                this.monitor.worked(1);
            }
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        return this.doVisit(resource);
    }
}

