/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.yieldadapters;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.polarsys.reqcycle.utils.iterators.collectors.Collector;
import org.polarsys.reqcycle.utils.iterators.exceptions.CannotHandleException;
import org.polarsys.reqcycle.utils.iterators.exceptions.CollectionAbortedException;
import org.polarsys.reqcycle.utils.iterators.exceptions.RedundancyException;
import org.polarsys.reqcycle.utils.iterators.handlers.ResultHandler;
import org.polarsys.reqcycle.utils.iterators.utils.YieldAdapterIterable;
import org.polarsys.reqcycle.utils.iterators.utils.YieldAdapterIterator;
import org.polarsys.reqcycle.utils.iterators.yieldadapters.YieldAdapter;

public class SetYieldAdapter<T>
implements YieldAdapter<T> {
    @Override
    public YieldAdapterIterable<T> adapt(Collector<T> client) {
        final LinkedHashSet results = new LinkedHashSet();
        try {
            client.collect(new ResultHandler<T>(){

                @Override
                public void handleResult(T value) throws CannotHandleException {
                    if (results.contains(value)) {
                        throw new RedundancyException(value);
                    }
                    results.add(value);
                }
            });
        }
        catch (CollectionAbortedException collectionAbortedException) {}
        return new YieldAdapterIterable<T>(){

            @Override
            public YieldAdapterIterator<T> iterator() {
                final Iterator iterator = results.iterator();
                return new YieldAdapterIterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public void dispose() {
                    }
                };
            }
        };
    }
}

