/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.ui.views;

import java.util.Collection;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.reqcycle.impact.Impact.ImpactAnalysis;
import org.polarsys.reqcycle.impact.Impact.ImpactFactory;
import org.polarsys.reqcycle.impact.Impact.RequirementImpacted;
import org.polarsys.reqcycle.impact.ui.Activator;
import org.polarsys.reqcycle.impact.ui.dialogs.ImpactAnalysisComposites;
import org.polarsys.reqcycle.impact.ui.dialogs.ImpactAnalysisInputSelectorDialog;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ImpactView
extends ViewPart {
    public static final String VIEW_ID = "org.polarsys.reqcycle.impact.ui.views.impact";
    private ImpactAnalysis impact;
    private RequirementSource requirementSource;
    private String FileExtension = "xmi";
    protected EList<Requirement> requirementsAdded;
    protected EList<Requirement> requirementsDeleted;
    protected EList<Requirement> requirementsModified;
    private Action selectImpactInputs;
    private Action saveImpact;
    ImpactAnalysisComposites impactComposites;

    public ImpactView() {
        ZigguratInject.inject((Object[])new Object[]{this});
        this.impactComposites = new ImpactAnalysisComposites();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.impactComposites.createInputComposite(composite);
        this.impactComposites.createImpactComposite(composite);
        this.impactComposites.setRequirementSource("Not selected");
        this.impactComposites.setInitialVersion("Not selected");
        this.impactComposites.setFinalVersion("Not selected");
        this.makeActions();
        this.contributeToActionBars();
    }

    public void setImpactAnalysis(ImpactAnalysis impact) {
        this.impact = impact;
    }

    public static void openNewImpactView(Collection<RequirementSource> requirementSources) {
        IViewPart view = ImpactView.createNewView();
        if (view == null) {
            return;
        }
        ImpactView reqView = (ImpactView)view;
        reqView.setRequirementSource(requirementSources.iterator().next());
    }

    public static IViewPart createNewView() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int nbView = 0;
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().startsWith(VIEW_ID)) {
                ++nbView;
            }
            ++n2;
        }
        ++nbView;
        IViewPart view = null;
        try {
            view = activePage.showView(VIEW_ID, "org.polarsys.reqcycle.impact.ui.views.impact_" + nbView, 1);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return view;
    }

    public void setRequirementSource(RequirementSource requirementSource) {
        this.requirementSource = requirementSource;
        this.impactComposites.setRequirementSource(this.requirementSource.getName());
    }

    public RequirementSource getRequirementSource() {
        return this.requirementSource;
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.selectImpactInputs);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.saveImpact);
    }

    protected void makeActions() {
        this.selectImpactInputs = new Action("Select Impact Analysis inputs"){

            public void run() {
                RequirementSource reqSource = ImpactView.this.getRequirementSource();
                ImpactAnalysisInputSelectorDialog dialog = new ImpactAnalysisInputSelectorDialog(Display.getDefault().getActiveShell(), reqSource);
                if (dialog.open() == 0) {
                    ImpactAnalysis analysis = ImpactFactory.eINSTANCE.createImpactAnalysis();
                    if (reqSource == null) {
                        reqSource = dialog.getRequirementSource();
                    }
                    RequirementSource requirementSourceFrom = dialog.getRequirementSourceFrom();
                    RequirementSource requirementSourceTo = dialog.getRequirementSourceTo();
                    analysis.launchAnalysis(requirementSourceFrom, requirementSourceTo);
                    ImpactView.this.impactComposites.setRequirementSource(dialog.getRequirementSource().getName());
                    ImpactView.this.impactComposites.setInitialVersion(dialog.getInitialVersion());
                    ImpactView.this.impactComposites.setFinalVersion(dialog.getFinalVersion());
                    ImpactView.this.setImpactAnalysis(analysis);
                    ImpactView.this.impactComposites.setImpactResult((EList<RequirementImpacted>)ImpactView.this.impact.getRequirementsAdded(), (EList<RequirementImpacted>)ImpactView.this.impact.getRequirementsDeleted(), (EList<RequirementImpacted>)ImpactView.this.impact.getRequirementsModified());
                }
            }
        };
        this.selectImpactInputs.setImageDescriptor(Activator.getImageDescriptor("icons/goto_input-1.gif"));
        this.saveImpact = new Action("Save Impact Analysis"){

            public void run() {
                SaveAsDialog d = new SaveAsDialog(Display.getDefault().getActiveShell()){};
                if (d.open() == 0) {
                    String extension = d.getResult().getFileExtension();
                    String path = d.getResult().toString();
                    if (extension == null || extension.equals(ImpactView.this.FileExtension)) {
                        path = String.valueOf(path) + "." + ImpactView.this.FileExtension;
                    }
                    ImpactView.this.impact.saveAnalysis(URI.createPlatformResourceURI((String)path, (boolean)true));
                    try {
                        ResourcesPlugin.getWorkspace().getRoot().getFile(d.getResult()).getParent().refreshLocal(1, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.saveImpact.setImageDescriptor(Activator.getImageDescriptor("icons/Save_obj.gif"));
    }

    protected Resource newResource(URI uri, RequirementSource requirementSource) {
        XMIResourceImpl resource = new XMIResourceImpl(){

            protected boolean useUUIDs() {
                return true;
            }
        };
        resource.getContents().add((Object)requirementSource.getContents());
        resource.setURI(uri);
        return resource;
    }

    public void setFocus() {
    }
}

