/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.extenders;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.utils.SerializationUtils;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.services.IReachableExtender;

public class TTypeExtender
implements IReachableExtender {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_LABEL = "label";

    public static String getId(Reachable reachable) {
        return reachable.get(PROPERTY_ID);
    }

    public static String getLabel(Reachable reachable) {
        return reachable.get(PROPERTY_LABEL);
    }

    public static String getData(Reachable reachable) {
        return reachable.get(PROPERTY_DATA);
    }

    public Map<String, String> getExtendedProperties(URI uri, Object originalObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (originalObject != null && originalObject instanceof TType) {
            TType ttype = (TType)originalObject;
            map.put(PROPERTY_ID, ttype.getId());
            map.put(PROPERTY_LABEL, ttype.getLabel());
            map.put(PROPERTY_DATA, SerializationUtils.serialize(ttype));
        }
        return map;
    }

    public boolean handles(URI uri, Object object) {
        return object != null && object instanceof TType;
    }
}

