/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.collect.collectors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.polarsys.reqcycle.utils.collect.Picker;
import org.polarsys.reqcycle.utils.collect.ResultHandler;
import org.polarsys.reqcycle.utils.collect.collectors.AbstractCollector;
import org.polarsys.reqcycle.utils.collect.exceptions.CannotHandleException;
import org.polarsys.reqcycle.utils.collect.exceptions.CannotPickException;
import org.polarsys.reqcycle.utils.collect.exceptions.CollectionAbortedException;

public class DepthMeasuringHarvester<T>
extends AbstractCollector<T> {
    protected Map<T, Integer> longestPath = new HashMap<T, Integer>();

    public DepthMeasuringHarvester(T startingElement, Iterable<? extends Picker<T>> pickers) {
        super(startingElement, pickers);
    }

    @Override
    public void collect(ResultHandler<T> handler) throws CollectionAbortedException {
        this.getLongestPathMap().put(this.start, 0);
        this.collectDepthWise(handler, this.start, 0);
    }

    public Map<T, Integer> getLongestPathMap() {
        return this.longestPath;
    }

    protected void collectDepthWise(ResultHandler<T> handler, T element, int depth) throws CollectionAbortedException {
        try {
            handler.handleResult(element);
            for (Picker<T> picker : this.getPickers()) {
                Iterable nexts = picker.getNexts(element);
                if (nexts == null) continue;
                for (Object next : nexts) {
                    Integer nextOldDepth = this.getLongestPathMap().get(next);
                    Integer nextCurrentDepth = Math.max(nextOldDepth != null ? nextOldDepth : -1, depth + 1);
                    if (nextCurrentDepth != nextOldDepth) {
                        this.getLongestPathMap().put(next, nextCurrentDepth);
                    }
                    this.collectDepthWise(handler, next, nextCurrentDepth);
                }
            }
        }
        catch (CannotHandleException cannotHandleException) {
        }
        catch (CannotPickException e) {
            throw new CollectionAbortedException(e);
        }
    }

    public List<T> getElementsFromDeepest() {
        Set<T> keySet = this.longestPath.keySet();
        ArrayList result = Lists.newArrayList(keySet);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                Integer depth0 = DepthMeasuringHarvester.this.getLongestPathMap().get(arg0);
                Integer depth1 = DepthMeasuringHarvester.this.getLongestPathMap().get(arg1);
                if (depth0 > depth1) {
                    return -1;
                }
                if (depth0 == depth1) {
                    return 0;
                }
                return 1;
            }
        });
        return result;
    }
}

