/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.collect.collectors;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.polarsys.reqcycle.utils.collect.Picker;
import org.polarsys.reqcycle.utils.collect.ResultHandler;
import org.polarsys.reqcycle.utils.collect.collectors.AbstractCollector;
import org.polarsys.reqcycle.utils.collect.exceptions.CannotHandleException;
import org.polarsys.reqcycle.utils.collect.exceptions.CollectionAbortedException;

public class WidthCollector<T>
extends AbstractCollector<T> {
    protected Iterable<T> startingElements;

    public WidthCollector(T startingElement, Iterable<? extends Picker<T>> pickers) {
        super(startingElement, pickers);
    }

    public WidthCollector(Iterable<T> startingElements, Iterable<? extends Picker<T>> pickers) {
        super(null, pickers);
        this.startingElements = startingElements;
    }

    @Override
    public void collect(ResultHandler<T> handler) throws CollectionAbortedException {
        if (this.start != null && this.startingElements == null) {
            this.collectWidthWise(handler, this.start);
        }
        if (this.start == null && this.startingElements != null) {
            this.collectWidthWise(handler, this.startingElements);
        }
    }

    protected void collectWidthWise(ResultHandler<T> handler, T element) throws CollectionAbortedException {
        List<T> singleton = Collections.singletonList(element);
        this.collectWidthWise(handler, (Iterable<T>)singleton);
    }

    protected void collectWidthWise(ResultHandler<T> handler, Iterable<T> currentLayer) throws CollectionAbortedException {
        Iterable<Object> nextLayer = Collections.emptyList();
        while (currentLayer != null && !Iterables.isEmpty(currentLayer)) {
            for (T currentElement : currentLayer) {
                try {
                    handler.handleResult(currentElement);
                    for (Picker<T> picker : this.getPickers()) {
                        Iterable nexts = picker.getNexts(currentElement);
                        if (nexts == null) continue;
                        nextLayer = Iterables.concat(nextLayer, nexts);
                    }
                }
                catch (CannotHandleException cannotHandleException) {
                }
                catch (Exception e) {
                    throw new CollectionAbortedException(e);
                }
            }
            currentLayer = nextLayer;
            nextLayer = Collections.emptyList();
        }
    }
}

