/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.Impact.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.EAttributeValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EElementPresence;
import org.eclipse.emf.diffmerge.diffdata.EReferenceValuePresence;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.polarsys.reqcycle.impact.IVersionManager;
import org.polarsys.reqcycle.impact.Impact.AttributeImpacted;
import org.polarsys.reqcycle.impact.Impact.ImpactAnalysis;
import org.polarsys.reqcycle.impact.Impact.ImpactFactory;
import org.polarsys.reqcycle.impact.Impact.ImpactPackage;
import org.polarsys.reqcycle.impact.Impact.RequirementImpacted;
import org.polarsys.reqcycle.impact.Impact.TraceabilityLink;
import org.polarsys.reqcycle.impact.merge.CustomRootedModelScope;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Trash;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.engine.Request;
import org.polarsys.reqcycle.traceability.exceptions.EngineException;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.model.scopes.CompositeScope;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.traceability.model.scopes.Scopes;
import org.polarsys.reqcycle.traceability.ui.TraceabilityUtils;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ImpactAnalysisImpl
extends MinimalEObjectImpl.Container
implements ImpactAnalysis {
    protected EList<RequirementImpacted> requirementsAdded;
    protected EList<RequirementImpacted> requirementsDeleted;
    protected EList<RequirementImpacted> requirementsModified;
    @Inject
    IReachableManager manager;
    @Inject
    IDataManager dataManager;
    @Inject
    IVersionManager versionManager;
    @Inject
    ITraceabilityEngine engine;

    protected ImpactAnalysisImpl() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    protected EClass eStaticClass() {
        return ImpactPackage.Literals.IMPACT_ANALYSIS;
    }

    @Override
    public EList<RequirementImpacted> getRequirementsAdded() {
        if (this.requirementsAdded == null) {
            this.requirementsAdded = new EObjectContainmentEList(RequirementImpacted.class, (InternalEObject)this, 0);
        }
        return this.requirementsAdded;
    }

    @Override
    public EList<RequirementImpacted> getRequirementsDeleted() {
        if (this.requirementsDeleted == null) {
            this.requirementsDeleted = new EObjectContainmentEList(RequirementImpacted.class, (InternalEObject)this, 1);
        }
        return this.requirementsDeleted;
    }

    @Override
    public EList<RequirementImpacted> getRequirementsModified() {
        if (this.requirementsModified == null) {
            this.requirementsModified = new EObjectContainmentEList(RequirementImpacted.class, (InternalEObject)this, 2);
        }
        return this.requirementsModified;
    }

    public Collection<Requirement> getRequirement(AbstractElement absElt) {
        LinkedList<Requirement> req = new LinkedList<Requirement>();
        if (absElt instanceof Requirement) {
            req.add((Requirement)absElt);
        } else if (absElt instanceof Section) {
            for (AbstractElement e : ((Section)absElt).getChildren()) {
                if (e instanceof Requirement) {
                    req.add((Requirement)e);
                    continue;
                }
                if (!(e instanceof Section) || e instanceof Trash) continue;
                req.addAll(this.getRequirement(e));
            }
        }
        return req;
    }

    @Override
    public void launchAnalysis(RequirementSource sourceFrom, RequirementSource sourceTo) {
        this.getRequirementsAdded().clear();
        this.getRequirementsDeleted().clear();
        this.getRequirementsModified().clear();
        if (sourceFrom != null && sourceTo != null) {
            LinkedList<Requirement> targetObjects = new LinkedList<Requirement>();
            for (AbstractElement elt : sourceTo.getRequirements()) {
                if (elt instanceof Requirement) {
                    targetObjects.add((Requirement)elt);
                    continue;
                }
                if (!(elt instanceof Section) || elt instanceof Trash) continue;
                targetObjects.addAll(this.getRequirement(elt));
            }
            Collections.sort(targetObjects, new Comparator<Requirement>(){

                @Override
                public int compare(Requirement arg0, Requirement arg1) {
                    return arg0.getId().compareTo(arg1.getId());
                }
            });
            LinkedList<Requirement> refObjects = new LinkedList<Requirement>();
            for (AbstractElement elt : sourceFrom.getRequirements()) {
                if (elt instanceof Requirement) {
                    refObjects.add((Requirement)elt);
                    continue;
                }
                if (!(elt instanceof Section)) continue;
                refObjects.addAll(this.getRequirement(elt));
            }
            Collections.sort(refObjects, new Comparator<Requirement>(){

                @Override
                public int compare(Requirement arg0, Requirement arg1) {
                    return arg0.getId().compareTo(arg1.getId());
                }
            });
            CustomRootedModelScope refScope = new CustomRootedModelScope(refObjects);
            CustomRootedModelScope targetScope = new CustomRootedModelScope(targetObjects);
            EComparisonImpl comparison = new EComparisonImpl((IEditableModelScope)targetScope, (IEditableModelScope)refScope, null);
            comparison.compute(null, null, null, null);
            ArrayList toMergeDiffs = Lists.newArrayList((Iterable)comparison.getRemainingDifferences());
            for (IDifference diff : toMergeDiffs) {
                AttributeImpacted attImpacted;
                AttributeImpacted att;
                RequirementImpacted reqModified;
                Requirement req;
                EReferenceValuePresence ref;
                if (diff instanceof EElementPresence) {
                    EElementPresence presence = (EElementPresence)diff;
                    if (presence.getPresenceRole() == Role.TARGET) {
                        if (!(presence.getElement() instanceof Requirement)) continue;
                        RequirementImpacted reqAdded = ImpactFactory.eINSTANCE.createRequirementImpacted();
                        reqAdded.setId(((Requirement)presence.getElement()).getId());
                        this.getRequirementsAdded().add((Object)reqAdded);
                        continue;
                    }
                    if (!(presence.getElement() instanceof Requirement)) continue;
                    RequirementImpacted reqDeleted = ImpactFactory.eINSTANCE.createRequirementImpacted();
                    reqDeleted.setId(((Requirement)presence.getElement()).getId());
                    Requirement req2 = (Requirement)presence.getElement();
                    reqDeleted.getLinkList().addAll(this.getTraceabilityLinks(req2));
                    this.getRequirementsDeleted().add((Object)reqDeleted);
                    continue;
                }
                if (diff instanceof EReferenceValuePresence) {
                    ref = (EReferenceValuePresence)diff;
                    ref.getPresenceRole();
                    continue;
                }
                if (!(diff instanceof EAttributeValuePresence)) continue;
                ref = (EAttributeValuePresence)diff;
                if (ref.getPresenceRole() == Role.TARGET) {
                    if (!(ref.getElementMatch().getReference() instanceof Requirement)) continue;
                    req = (Requirement)ref.getElementMatch().getReference();
                    reqModified = this.getReqModified(req);
                    att = reqModified.getImpactedAttribute(ref.getFeature().getName());
                    if (att != null) {
                        att.setNewValue(ref.getValue().toString());
                        continue;
                    }
                    attImpacted = ImpactFactory.eINSTANCE.createAttributeImpacted();
                    ref.getElementMatch();
                    attImpacted.setId(ref.getFeature().getName());
                    attImpacted.setNewValue(ref.getValue().toString());
                    reqModified.getAttributesImpacted().add((Object)attImpacted);
                    continue;
                }
                req = (Requirement)ref.getElementMatch().getReference();
                reqModified = this.getReqModified(req);
                att = reqModified.getImpactedAttribute(ref.getFeature().getName());
                if (att != null) {
                    att.setOldValue(ref.getValue().toString());
                    continue;
                }
                attImpacted = ImpactFactory.eINSTANCE.createAttributeImpacted();
                ref.getElementMatch();
                attImpacted.setId(ref.getFeature().getName());
                attImpacted.setOldValue(ref.getValue().toString());
                reqModified.getAttributesImpacted().add((Object)attImpacted);
            }
        }
    }

    @Override
    public void saveAnalysis(URI targetName) {
        ResourceSet set = null;
        if (this.eResource() != null) {
            set = this.eResource().getResourceSet();
        }
        if (set == null) {
            set = new ResourceSetImpl();
            set.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        }
        Resource r = set.createResource(targetName);
        r.getContents().add((Object)this);
        try {
            r.save(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getRequirementsAdded()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getRequirementsDeleted()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getRequirementsModified()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    protected RequirementImpacted getReqModified(Requirement requirement) {
        for (RequirementImpacted req : this.getRequirementsModified()) {
            if (!req.getId().equals(requirement.getId())) continue;
            return req;
        }
        RequirementImpacted reqModified = ImpactFactory.eINSTANCE.createRequirementImpacted();
        reqModified.setId(requirement.getId());
        reqModified.getLinkList().addAll(this.getTraceabilityLinks(requirement));
        this.getRequirementsModified().add((Object)reqModified);
        return reqModified;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getRequirementsAdded();
            }
            case 1: {
                return this.getRequirementsDeleted();
            }
            case 2: {
                return this.getRequirementsModified();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getRequirementsAdded().clear();
                this.getRequirementsAdded().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getRequirementsDeleted().clear();
                this.getRequirementsDeleted().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getRequirementsModified().clear();
                this.getRequirementsModified().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getRequirementsAdded().clear();
                return;
            }
            case 1: {
                this.getRequirementsDeleted().clear();
                return;
            }
            case 2: {
                this.getRequirementsModified().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.requirementsAdded != null && !this.requirementsAdded.isEmpty();
            }
            case 1: {
                return this.requirementsDeleted != null && !this.requirementsDeleted.isEmpty();
            }
            case 2: {
                return this.requirementsModified != null && !this.requirementsModified.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                this.launchAnalysis((RequirementSource)arguments.get(0), (RequirementSource)arguments.get(1));
                return null;
            }
            case 1: {
                this.saveAnalysis((URI)arguments.get(0));
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    protected Collection<TraceabilityLink> getTraceabilityLinks(Requirement requirement) {
        LinkedList<TraceabilityLink> traceabilityLinks = new LinkedList<TraceabilityLink>();
        Iterable<Link> itUp = this.getLinks(requirement, ITraceabilityEngine.DIRECTION.UPWARD);
        this.addLinks(traceabilityLinks, itUp, "UP");
        Iterable<Link> itDown = this.getLinks(requirement, ITraceabilityEngine.DIRECTION.DOWNWARD);
        this.addLinks(traceabilityLinks, itDown, "DOWN");
        return traceabilityLinks;
    }

    private void addLinks(List<TraceabilityLink> traceabilityLinks, Iterable<Link> itUp, String direction) {
        if (itUp != null && itUp.iterator() != null) {
            for (Link link : itUp) {
                TraceabilityLink traceabilityLink = ImpactFactory.eINSTANCE.createTraceabilityLink();
                TType kind = link.getKind();
                StringBuilder builder = new StringBuilder(kind.getLabel());
                TType superKind = kind.getSuperType();
                if (superKind != null) {
                    builder.append(String.format(" [Transverse : %s]", superKind.getLabel()));
                }
                traceabilityLink.setLinkType(builder.toString());
                Set set = link.getTargets();
                if (set != null && set.size() == 1) {
                    Reachable reachable = (Reachable)Iterables.get((Iterable)set, (int)0);
                    traceabilityLink.setLinkDirection(direction);
                    traceabilityLink.setLinkedElement(TraceabilityUtils.getText((Reachable)reachable));
                }
                traceabilityLinks.add(traceabilityLink);
            }
        }
    }

    protected Iterable<Link> getLinks(final Requirement req, final ITraceabilityEngine.DIRECTION direction) {
        return new Iterable<Link>(){

            @Override
            public Iterator<Link> iterator() {
                Request request = new Request();
                CompositeScope scope = new CompositeScope();
                scope.add(Scopes.getWorkspaceScope());
                request.setScope((IScope)scope);
                request.setDepth(Request.DEPTH.ONE);
                request.setDirection(direction);
                try {
                    Reachable reachable = ImpactAnalysisImpl.this.manager.getHandlerFromObject((Object)req).getFromObject((Object)req).getReachable();
                    request.addSource(reachable);
                }
                catch (IReachableHandlerException e1) {
                    e1.printStackTrace();
                    return new ArrayList().iterator();
                }
                try {
                    Iterator traceability = ImpactAnalysisImpl.this.engine.getTraceability(new Request[]{request});
                    return Iterators.transform((Iterator)traceability, (Function)new Function<Pair<Link, Reachable>, Link>(){

                        public Link apply(Pair<Link, Reachable> arg0) {
                            return (Link)arg0.getFirst();
                        }
                    });
                }
                catch (EngineException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                return new ArrayList().iterator();
            }
        };
    }
}

